/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints;

import com.jcabi.xml.XML;
import com.jcabi.xml.XMLDocument;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cactoos.iterable.Sticky;
import org.eolang.lints.Defect;
import org.eolang.lints.Lint;
import org.eolang.lints.units.UnitTestMissing;

public final class Programs {
    private static final Iterable<Lint<Map<String, XML>>> LINTS = new Sticky((Object[])new Lint[]{new UnitTestMissing()});
    private final Map<String, XML> pkg;

    public Programs(Path ... dirs) throws IOException {
        this(Arrays.asList(dirs));
    }

    public Programs(Collection<Path> dirs) throws IOException {
        this(Programs.discover(dirs));
    }

    public Programs(Map<String, XML> map) {
        this.pkg = Collections.unmodifiableMap(map);
    }

    public Collection<Defect> defects() throws IOException {
        LinkedList<Defect> messages = new LinkedList<Defect>();
        for (Lint<Map<String, XML>> lint : LINTS) {
            messages.addAll(lint.defects(this.pkg));
        }
        return messages;
    }

    private static Map<String, XML> discover(Iterable<Path> dirs) throws IOException {
        HashMap<String, XML> map = new HashMap<String, XML>(0);
        for (Path dir : dirs) {
            map.putAll(Programs.discover(dir));
        }
        return map;
    }

    private static Map<String, XML> discover(Path dir) throws IOException {
        try (Stream<Path> walk = Files.walk(dir, new FileVisitOption[0]);){
            Map<String, XML> map = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toMap(path -> path.getFileName().toString().replaceAll("\\.xmir$", ""), path -> {
                try {
                    return new XMLDocument(path);
                }
                catch (FileNotFoundException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }));
            return map;
        }
    }
}

