/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints.misc;

import com.jcabi.xml.XML;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.CoreDocument;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cactoos.Input;
import org.cactoos.io.ResourceOf;
import org.cactoos.text.TextOf;
import org.eolang.lints.Defect;
import org.eolang.lints.Lint;
import org.eolang.lints.Severity;

public final class UnitTestIsNotVerb
implements Lint<XML> {
    private static final Pattern KEBAB = Pattern.compile("-");
    private final StanfordCoreNLP pipeline;

    public UnitTestIsNotVerb(Properties props) {
        this(new StanfordCoreNLP(props));
    }

    public UnitTestIsNotVerb() {
        this(UnitTestIsNotVerb.defaults());
    }

    public UnitTestIsNotVerb(StanfordCoreNLP pipe) {
        this.pipeline = pipe;
    }

    @Override
    public Collection<Defect> defects(XML xmir) throws IOException {
        LinkedList<Defect> defects = new LinkedList<Defect>();
        for (XML object : xmir.nodes("/program[metas/meta[head='tests']]/objects/o[@name]")) {
            String name = (String)object.xpath("@name").get(0);
            CoreDocument doc = new CoreDocument(Stream.concat(Stream.of("It"), Arrays.stream(KEBAB.split(name))).map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.joining(" ")));
            this.pipeline.annotate(doc);
            if ("VBZ".equals(((CoreLabel)doc.tokens().get(1)).get(CoreAnnotations.PartOfSpeechAnnotation.class))) continue;
            defects.add(new Defect.Default("unit-test-is-not-verb", Severity.WARNING, xmir.xpath("/program/@name").stream().findFirst().orElse("unknown"), Integer.parseInt((String)object.xpath("@line").get(0)), String.format("Test object name: \"%s\" doesn't start with verb in singular form", name)));
        }
        return defects;
    }

    @Override
    public String motive() throws Exception {
        return new TextOf((Input)new ResourceOf((CharSequence)"org/eolang/motives/misc/test-object-is-not-verb-in-singular.md")).asString();
    }

    private static Properties defaults() {
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize,pos");
        return props;
    }
}

