/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints.units;

import com.jcabi.xml.XML;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.eolang.lints.Defect;
import org.eolang.lints.Lint;
import org.eolang.lints.Severity;

public final class UnitTestMissing
implements Lint<Map<String, XML>> {
    @Override
    public Collection<Defect> defects(Map<String, XML> pkg) throws IOException {
        LinkedList<Defect> defects = new LinkedList<Defect>();
        for (String name : pkg.keySet()) {
            if (name.endsWith("-test")) continue;
            if (pkg.containsKey(String.format("%s-test", name))) continue;
            defects.add(new Defect.Default("unit-test-missing", Severity.WARNING, name, 0, String.format("Unit test is not found for %s", name)));
        }
        return defects;
    }

    @Override
    public String motive() throws Exception {
        return "";
    }
}

