/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints;

import com.github.lombrozo.xnav.Filter;
import com.github.lombrozo.xnav.Xnav;
import com.jcabi.xml.ClasspathSources;
import com.jcabi.xml.Sources;
import com.jcabi.xml.XML;
import com.jcabi.xml.XMLDocument;
import com.jcabi.xml.XSL;
import com.jcabi.xml.XSLDocument;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.cactoos.Input;
import org.cactoos.Text;
import org.cactoos.io.ResourceOf;
import org.cactoos.text.IoCheckedText;
import org.cactoos.text.TextOf;
import org.eolang.lints.Defect;
import org.eolang.lints.Lint;
import org.eolang.lints.MeasuredXsl;
import org.eolang.lints.Severity;

final class LtByXsl
implements Lint<XML> {
    private final String rule;
    private final XSL sheet;
    private final Input doc;

    LtByXsl(String xsl) throws IOException {
        this((Input)new ResourceOf((CharSequence)String.format("org/eolang/lints/%s.xsl", xsl)), (Input)new ResourceOf((CharSequence)String.format("org/eolang/motives/%s.md", xsl)));
    }

    LtByXsl(Input xsl, Input motive) throws IOException {
        XMLDocument xml = new XMLDocument(new IoCheckedText((Text)new TextOf(xsl)).asString());
        this.rule = (String)new Xnav(xml.toString()).element("xsl:stylesheet").attribute("id").text().orElseThrow();
        this.sheet = new MeasuredXsl(this.rule, new XSLDocument((XML)xml, this.rule).with((Sources)new ClasspathSources()));
        this.doc = motive;
    }

    @Override
    public String name() {
        return this.rule;
    }

    @Override
    public Collection<Defect> defects(XML xmir) {
        XML report = this.sheet.transform(xmir);
        LinkedList<Defect> defects = new LinkedList<Defect>();
        for (XML defect : LtByXsl.findDefects(report)) {
            List severity = defect.xpath("@severity");
            if (severity.isEmpty()) {
                throw new IllegalStateException(String.format("No severity reported by %s", this.rule));
            }
            defects.add(new Defect.Default(this.rule, Severity.parsed((String)severity.get(0)), LtByXsl.findName(xmir), this.lineno(defect), (String)defect.xpath("text()").get(0)));
        }
        return defects;
    }

    @Override
    public String motive() throws IOException {
        return new IoCheckedText((Text)new TextOf(this.doc)).asString();
    }

    private int lineno(XML defect) {
        int lineno;
        List lines = defect.xpath("@line");
        if (lines.isEmpty()) {
            throw new IllegalStateException(String.format("No line number reported by %s", this.rule));
        }
        String line = (String)lines.get(0);
        if (line.isEmpty()) {
            throw new IllegalStateException(String.format("Empty line number reported by %s", this.rule));
        }
        try {
            lineno = Integer.parseInt(line);
        }
        catch (NumberFormatException ex) {
            throw new IllegalStateException(String.format("Wrong line number reported by %s: '%s'", this.rule, lines.get(0)), ex);
        }
        return lineno;
    }

    private static String findName(XML program) {
        return new Xnav(program.inner()).element("program").attribute("name").text().orElse("unknown");
    }

    private static Collection<XML> findDefects(XML report) {
        return new Xnav(report.inner()).element("defects").elements(new Filter[]{Filter.withName((String)"defect")}).map(Xnav::copy).map(Xnav::node).map(XMLDocument::new).collect(Collectors.toList());
    }
}

