/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints.errors;

import com.jcabi.xml.XML;
import com.jcabi.xml.XSL;
import com.jcabi.xml.XSLDocument;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.cactoos.Input;
import org.cactoos.Text;
import org.cactoos.io.ResourceOf;
import org.cactoos.io.UncheckedInput;
import org.cactoos.list.ListOf;
import org.cactoos.text.TextOf;
import org.cactoos.text.UncheckedText;
import org.eolang.lints.Defect;
import org.eolang.lints.Lint;
import org.eolang.lints.Severity;

public final class LtAtomIsNotUnique
implements Lint<Map<String, XML>> {
    private final XSL pre;

    public LtAtomIsNotUnique() {
        this((XSL)new XSLDocument(new UncheckedInput((Input)new ResourceOf((CharSequence)"org/eolang/funcs/atom-fqns.xsl")).stream()));
    }

    public LtAtomIsNotUnique(XSL sheet) {
        this.pre = sheet;
    }

    @Override
    public String name() {
        return "atom-is-not-unique";
    }

    @Override
    public Collection<Defect> defects(Map<String, XML> pkg) {
        LinkedList<Defect> defects = new LinkedList<Defect>();
        Map index = pkg.values().stream().map(arg_0 -> ((XSL)this.pre).transform(arg_0)).collect(Collectors.toMap(Function.identity(), LtAtomIsNotUnique::fqns));
        HashSet checked = new HashSet(0);
        index.forEach((xmir, fqns) -> {
            fqns.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).forEach((aname, count) -> IntStream.range(0, Math.toIntExact(count)).forEach(pos -> defects.add(this.singleDefect((XML)xmir, (String)aname, pos))));
            index.forEach((next, names) -> {
                String pair;
                if (!Objects.equals(next, xmir) && !checked.contains(pair = LtAtomIsNotUnique.pairHash(xmir, next))) {
                    checked.add(pair);
                    names.stream().filter(fqns::contains).forEach(aname -> {
                        defects.add(this.sharedDefect((XML)next, (XML)xmir, (String)aname));
                        defects.add(this.sharedDefect((XML)xmir, (XML)next, (String)aname));
                    });
                }
            });
        });
        return defects;
    }

    @Override
    public String motive() {
        return new UncheckedText((Text)new TextOf((Input)new ResourceOf((CharSequence)String.format("org/eolang/motives/errors/%s.md", this.name())))).asString();
    }

    private Defect singleDefect(XML xmir, String fqn, int pos) {
        return new Defect.Default(this.name(), Severity.ERROR, xmir.xpath("/program/@name").stream().findFirst().orElse("unknown"), Integer.parseInt((String)xmir.xpath(String.format("//o[@atom and @name='%s']/@line", LtAtomIsNotUnique.oname(fqn))).get(pos)), String.format("Atom \"%s\" is duplicated", fqn));
    }

    private Defect sharedDefect(XML xmir, XML original, String fqn) {
        return new Defect.Default(this.name(), Severity.ERROR, xmir.xpath("/program/@name").stream().findFirst().orElse("unknown"), Integer.parseInt((String)xmir.xpath(String.format("//o[@atom and @name='%s']/@line", LtAtomIsNotUnique.oname(fqn))).get(0)), String.format("Atom with FQN \"%s\" is duplicated, original was found in \"%s\"", fqn, original.xpath("/program/@name").stream().findFirst().orElse("unknown")));
    }

    private static List<String> fqns(XML xmir) {
        List result;
        List fqns = xmir.xpath("//o[@fqn]/@fqn");
        if (xmir.nodes("/program/metas/meta[head='package']").size() == 1) {
            String pack = (String)xmir.xpath("/program/metas/meta[head='package']/tail/text()").get(0);
            result = fqns.stream().map(fqn -> String.format("%s.%s", pack, fqn)).collect(Collectors.toList());
        } else {
            result = fqns;
        }
        return result.stream().map(fqn -> String.format("\u0424.%s", fqn)).collect(Collectors.toList());
    }

    private static String oname(String fqn) {
        ListOf parts = new ListOf((Object[])fqn.split("\\."));
        String result = parts.size() > 1 ? (String)parts.get(parts.size() - 1) : (String)parts.get(0);
        return result;
    }

    private static String pairHash(XML first, XML second) {
        String pair = first.hashCode() < second.hashCode() ? String.format("%d:%d", first.hashCode(), second.hashCode()) : String.format("%d:%d", second.hashCode(), first.hashCode());
        return pair;
    }
}

