/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints.errors;

import com.jcabi.xml.XML;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.cactoos.Input;
import org.cactoos.Text;
import org.cactoos.io.ResourceOf;
import org.cactoos.text.TextOf;
import org.cactoos.text.UncheckedText;
import org.eolang.lints.Defect;
import org.eolang.lints.Lint;
import org.eolang.lints.Severity;

public final class LtObjectIsNotUnique
implements Lint<Map<String, XML>> {
    @Override
    public String name() {
        return "object-is-not-unique";
    }

    @Override
    public Collection<Defect> defects(Map<String, XML> pkg) {
        LinkedList<Defect> defects = new LinkedList<Defect>();
        for (XML xmir : pkg.values()) {
            String src = xmir.xpath("/program/@name").stream().findFirst().orElse("unknown");
            if (xmir.nodes("/program/objects/o").isEmpty()) continue;
            for (XML oth : pkg.values()) {
                if (Objects.equals(oth, xmir) || oth.nodes("/program/objects/o").isEmpty()) continue;
                LtObjectIsNotUnique.programObjects(oth).entrySet().stream().filter(object -> LtObjectIsNotUnique.containsDuplicate(xmir, oth, (String)object.getKey())).map(object -> new Defect.Default(this.name(), Severity.ERROR, oth.xpath("/program/@name").stream().findFirst().orElse("unknown"), Integer.parseInt((String)object.getValue()), String.format("The object name \"%s\" is not unique, original object was found in \"%s\"", object.getKey(), src))).forEach(defects::add);
            }
        }
        return defects;
    }

    @Override
    public String motive() throws IOException {
        return new UncheckedText((Text)new TextOf((Input)new ResourceOf((CharSequence)String.format("org/eolang/motives/errors/%s.md", this.name())))).asString();
    }

    private static boolean containsDuplicate(XML original, XML oth, String name) {
        return LtObjectIsNotUnique.programObjects(original).containsKey(name) && LtObjectIsNotUnique.packageName(oth).equals(LtObjectIsNotUnique.packageName(original));
    }

    private static Map<String, String> programObjects(XML xmir) {
        List names = xmir.xpath("/program/objects/o/@name");
        return IntStream.range(0, names.size()).boxed().collect(Collectors.toMap(names::get, pos -> xmir.xpath(String.format("/program/objects/o[%d]/@line", pos + 1)).stream().findFirst().orElse("0"), (existing, replacement) -> replacement));
    }

    private static String packageName(XML xmir) {
        String name = xmir.nodes("/program/metas/meta[head='package']").size() == 1 ? (String)xmir.xpath("/program/metas/meta[head='package']/tail/text()").get(0) : "";
        return name;
    }
}

