/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints.misc;

import com.jcabi.xml.XML;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSTaggerME;
import org.cactoos.Input;
import org.cactoos.Text;
import org.cactoos.io.ResourceOf;
import org.cactoos.list.ListOf;
import org.cactoos.text.TextOf;
import org.cactoos.text.UncheckedText;
import org.eolang.lints.Defect;
import org.eolang.lints.Lint;
import org.eolang.lints.Severity;

public final class LtTestNotVerb
implements Lint<XML> {
    private static final Pattern KEBAB = Pattern.compile("-");
    private final POSTaggerME model;

    public LtTestNotVerb() {
        this(LtTestNotVerb.defaultPosModel());
    }

    public LtTestNotVerb(POSModel mdl) {
        this(new POSTaggerME(mdl));
    }

    public LtTestNotVerb(POSTaggerME pos) {
        this.model = pos;
    }

    @Override
    public Collection<Defect> defects(XML xmir) throws IOException {
        LinkedList<Defect> defects = new LinkedList<Defect>();
        for (XML object : xmir.nodes("/program[metas/meta[head='tests']]/objects/o[@name]")) {
            String name = (String)object.xpath("@name").get(0);
            String first = (String)new ListOf((Object[])this.model.tag((String[])Stream.concat(Stream.of("It"), Arrays.stream(KEBAB.split(name))).map(s -> s.toLowerCase(Locale.ROOT)).toArray(String[]::new))).get(1);
            if ("VBZ".equals(first)) continue;
            defects.add(new Defect.Default("unit-test-is-not-verb", Severity.WARNING, xmir.xpath("/program/@name").stream().findFirst().orElse("unknown"), Integer.parseInt((String)object.xpath("@line").get(0)), String.format("Test object name: \"%s\" doesn't start with verb in singular form", name)));
        }
        return defects;
    }

    @Override
    public String motive() throws IOException {
        return new UncheckedText((Text)new TextOf((Input)new ResourceOf((CharSequence)"org/eolang/motives/misc/test-object-is-not-verb-in-singular.md"))).asString();
    }

    @Override
    public String name() {
        return "unit-test-is-not-verb";
    }

    private static POSModel defaultPosModel() {
        try {
            return new POSModel(new URI("https://opennlp.sourceforge.net/models-1.5/en-pos-perceptron.bin").toURL());
        }
        catch (IOException exception) {
            throw new IllegalStateException("Failed to read from I/O", exception);
        }
        catch (URISyntaxException exception) {
            throw new IllegalStateException("URI syntax is broken", exception);
        }
    }
}

