/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints;

import com.github.lombrozo.xnav.Filter;
import com.github.lombrozo.xnav.Xnav;
import com.jcabi.xml.XML;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.cactoos.Input;
import org.cactoos.Text;
import org.cactoos.io.ResourceOf;
import org.cactoos.text.TextOf;
import org.cactoos.text.UncheckedText;
import org.eolang.lints.Defect;
import org.eolang.lints.Lint;
import org.eolang.lints.Severity;

final class LtObjectIsNotUnique
implements Lint<Map<String, XML>> {
    LtObjectIsNotUnique() {
    }

    @Override
    public String name() {
        return "object-is-not-unique";
    }

    @Override
    public Collection<Defect> defects(Map<String, XML> pkg) {
        LinkedList<Defect> defects = new LinkedList<Defect>();
        for (XML xmir : pkg.values()) {
            Xnav xml = new Xnav(xmir.inner());
            String src = xml.element("program").attribute("name").text().orElse("unknown");
            if (LtObjectIsNotUnique.hasObjects(xml)) continue;
            for (XML oth : pkg.values()) {
                Xnav second = new Xnav(oth.inner());
                if (Objects.equals(oth, xmir) || LtObjectIsNotUnique.hasObjects(second)) continue;
                LtObjectIsNotUnique.programObjects(second).entrySet().stream().filter(object -> LtObjectIsNotUnique.containsDuplicate(xml, second, (String)object.getKey())).map(object -> new Defect.Default(this.name(), Severity.ERROR, second.element("program").attribute("name").text().orElse("unknown"), Integer.parseInt((String)object.getValue()), String.format("The object name \"%s\" is not unique, original object was found in \"%s\"", object.getKey(), src))).forEach(defects::add);
            }
        }
        return defects;
    }

    @Override
    public String motive() throws IOException {
        return new UncheckedText((Text)new TextOf((Input)new ResourceOf((CharSequence)String.format("org/eolang/motives/errors/%s.md", this.name())))).asString();
    }

    private static boolean hasObjects(Xnav xml) {
        return xml.element("program").element("objects").elements(new Filter[]{Filter.withName((String)"o")}).findAny().isEmpty();
    }

    private static boolean containsDuplicate(Xnav original, Xnav oth, String name) {
        return LtObjectIsNotUnique.programObjects(original).containsKey(name) && LtObjectIsNotUnique.packageName(oth).equals(LtObjectIsNotUnique.packageName(original));
    }

    private static Map<String, String> programObjects(Xnav xml) {
        List names = xml.path("/program/objects/o/@name").map(oname -> (String)oname.text().get()).collect(Collectors.toList());
        return IntStream.range(0, names.size()).boxed().collect(Collectors.toMap(names::get, pos -> xml.path(String.format("/program/objects/o[%d]/@line", pos + 1)).findFirst().flatMap(Xnav::text).orElse("0"), (existing, replacement) -> replacement));
    }

    private static String packageName(Xnav xml) {
        String name = xml.path("/program/metas/meta[head='package']").count() == 1L ? (String)((Xnav)xml.path("/program/metas/meta[head='package']/tail").findFirst().get()).text().get() : "";
        return name;
    }
}

