/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints;

import com.jcabi.xml.XML;
import com.jcabi.xml.XMLDocument;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cactoos.Scalar;
import org.cactoos.iterable.Filtered;
import org.cactoos.iterable.Sticky;
import org.cactoos.list.ListOf;
import org.cactoos.list.Synced;
import org.eolang.lints.Defect;
import org.eolang.lints.Lint;
import org.eolang.lints.PkWpa;
import org.eolang.lints.XmirKey;

public final class Programs {
    private static final Iterable<Lint<Map<String, XML>>> WPA = new Synced((List)new ListOf((Iterable)new Sticky((Iterable)((Object)new PkWpa()))));
    private final Iterable<Lint<Map<String, XML>>> lints;
    private final Map<String, XML> pkg;

    public Programs(Path ... dirs) throws IOException {
        this(Arrays.asList(dirs));
    }

    public Programs(Collection<Path> dirs) throws IOException {
        this(Programs.discover(dirs));
    }

    public Programs(Map<String, XML> map) {
        this(map, WPA);
    }

    Programs(Map<String, XML> map, Iterable<Lint<Map<String, XML>>> list) {
        this.pkg = Collections.unmodifiableMap(map);
        this.lints = list;
    }

    public Programs without(String ... names) {
        ListOf listed = new ListOf((Object[])names);
        return new Programs(this.pkg, (Iterable<Lint<Map<String, XML>>>)new Filtered(this.lints, arg_0 -> Programs.lambda$without$1((Collection)listed, arg_0)));
    }

    public Collection<Defect> defects() {
        LinkedList<Defect> messages = new LinkedList<Defect>();
        for (Lint<Map<String, XML>> lint : this.lints) {
            try {
                messages.addAll(lint.defects(this.pkg));
            }
            catch (IOException exception) {
                throw new IllegalStateException(String.format("Failed to find defects in the '%s' package with '%s' lint", this.pkg, lint), exception);
            }
        }
        return messages;
    }

    private static Map<String, XML> discover(Iterable<Path> dirs) throws IOException {
        HashMap<String, XML> map = new HashMap<String, XML>(0);
        for (Path dir : dirs) {
            map.putAll(Programs.discover(dir));
        }
        return map;
    }

    private static Map<String, XML> discover(Path dir) throws IOException {
        try (Stream<Path> walk = Files.walk(dir, new FileVisitOption[0]);){
            Map<String, XML> map = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toMap(path -> new XmirKey((Path)path, dir).asString(), path -> {
                try {
                    return new XMLDocument(path);
                }
                catch (FileNotFoundException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }));
            return map;
        }
    }

    private static /* synthetic */ Scalar lambda$without$1(Collection listed, Lint lint) throws Exception {
        return () -> !listed.contains(lint.name());
    }
}

