/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints;

import com.github.lombrozo.xnav.Xnav;
import com.jcabi.xml.XML;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.cactoos.Input;
import org.cactoos.Text;
import org.cactoos.io.ResourceOf;
import org.cactoos.text.IoCheckedText;
import org.cactoos.text.TextOf;
import org.eolang.lints.Defect;
import org.eolang.lints.Lint;
import org.eolang.lints.Severity;
import org.eolang.parser.ObjectName;

final class LtAsciiOnly
implements Lint<XML> {
    LtAsciiOnly() {
    }

    @Override
    public Collection<Defect> defects(XML xmir) throws IOException {
        ArrayList<Defect> defects = new ArrayList<Defect>(0);
        Xnav xml = new Xnav(xmir.inner());
        List comments = xml.path("/object/comments/comment").collect(Collectors.toList());
        for (Xnav comment : comments) {
            Optional<Character> abusive = ((String)comment.text().get()).chars().filter(chr -> chr < 32 || chr > 127).mapToObj(chr -> Character.valueOf((char)chr)).findFirst();
            if (!abusive.isPresent()) continue;
            String line = comment.attribute("line").text().orElse("0");
            Character chr2 = abusive.get();
            defects.add(new Defect.Default("ascii-only", Severity.ERROR, new ObjectName(xmir).get(), Integer.parseInt(line), String.format("Only ASCII characters are allowed in comments, while \"%s\" is used at the line no.%s at the position no.%s", chr2, line, ((String)comment.text().get()).indexOf(chr2.charValue()) + 1)));
        }
        return defects;
    }

    @Override
    public String name() {
        return "ascii-only";
    }

    @Override
    public String motive() throws IOException {
        return new IoCheckedText((Text)new TextOf((Input)new ResourceOf((CharSequence)"org/eolang/motives/comments/ascii-only.md"))).asString();
    }
}

