/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints;

import com.github.lombrozo.xnav.Xnav;
import com.jcabi.xml.XML;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.cactoos.Input;
import org.cactoos.Text;
import org.cactoos.io.ResourceOf;
import org.cactoos.set.SetOf;
import org.cactoos.text.TextOf;
import org.cactoos.text.UncheckedText;
import org.eolang.lints.Defect;
import org.eolang.lints.Lint;
import org.eolang.lints.Severity;
import org.eolang.parser.ObjectName;

final class LtIncorrectUnlint
implements Lint<XML> {
    private final Collection<String> names;

    LtIncorrectUnlint(Iterable<String> lints) {
        this.names = new SetOf(lints);
    }

    @Override
    public String name() {
        return "incorrect-unlint";
    }

    @Override
    public Collection<Defect> defects(XML xmir) throws IOException {
        ArrayList<Defect> defects = new ArrayList<Defect>(0);
        Xnav xml = new Xnav(xmir.inner());
        xml.path("/object/metas/meta[head='unlint']").filter(u -> !this.names.contains(u.element("tail").text().orElse("unknown").split(":", -1)[0])).forEach(u -> defects.add(new Defect.Default(this.name(), Severity.ERROR, new ObjectName(xmir).get(), Integer.parseInt(u.attribute("line").text().orElse("0")), String.format("Suppressing \"%s\" does not make sense, because there is no lint with that name", u.element("tail").text().orElse("unknown")))));
        return defects;
    }

    @Override
    public String motive() throws IOException {
        return new UncheckedText((Text)new TextOf((Input)new ResourceOf((CharSequence)"org/eolang/motives/errors/lt-incorrect-unlint.md"))).asString();
    }
}

