/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints;

import com.jcabi.xml.XML;
import com.jcabi.xml.XMLDocument;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cactoos.iterable.Sticky;
import org.cactoos.list.ListOf;
import org.cactoos.list.Synced;
import org.eolang.lints.Defect;
import org.eolang.lints.Lint;
import org.eolang.lints.PkWpa;
import org.eolang.lints.ScopedDefects;
import org.eolang.lints.WpaWithout;
import org.eolang.lints.XmirKey;

public final class Program {
    private static final Iterable<Lint<Map<String, XML>>> WPA = new Synced((List)new ListOf((Iterable)new Sticky((Iterable)((Object)new PkWpa()))));
    private final Iterable<Lint<Map<String, XML>>> lints;
    private final Map<String, XML> pkg;

    public Program(Path ... dirs) throws IOException {
        this(Arrays.asList(dirs));
    }

    public Program(Collection<Path> dirs) throws IOException {
        this(Program.discover(dirs));
    }

    public Program(Map<String, XML> map) {
        this(map, WPA);
    }

    Program(Map<String, XML> map, Iterable<Lint<Map<String, XML>>> list) {
        this.pkg = Collections.unmodifiableMap(map);
        this.lints = list;
    }

    public Program without(String ... names) {
        return new Program(this.pkg, (Iterable<Lint<Map<String, XML>>>)((Object)new WpaWithout(names)));
    }

    public Collection<Defect> defects() {
        ArrayList<Defect> messages = new ArrayList<Defect>(0);
        for (Lint<Map<String, XML>> lint : this.lints) {
            try {
                messages.addAll((Collection<Defect>)((Object)new ScopedDefects(lint.defects(this.pkg), "WPA")));
            }
            catch (IOException exception) {
                throw new IllegalStateException(String.format("Failed to find defects in the '%s' package with '%s' lint", this.pkg, lint), exception);
            }
        }
        return messages;
    }

    private static Map<String, XML> discover(Iterable<Path> dirs) throws IOException {
        HashMap<String, XML> map = new HashMap<String, XML>(0);
        for (Path dir : dirs) {
            map.putAll(Program.discover(dir));
        }
        return map;
    }

    private static Map<String, XML> discover(Path dir) throws IOException {
        try (Stream<Path> walk = Files.walk(dir, new FileVisitOption[0]);){
            Map<String, XML> map = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toMap(path -> new XmirKey((Path)path, dir).asString(), path -> {
                try {
                    return new XMLDocument(path);
                }
                catch (FileNotFoundException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }));
            return map;
        }
    }
}

