/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.xax;

import com.jcabi.xml.XML;
import com.jcabi.xml.XMLDocument;
import com.jcabi.xml.XSL;
import com.jcabi.xml.XSLDocument;
import com.yegor256.xsline.Shift;
import com.yegor256.xsline.StClasspath;
import com.yegor256.xsline.StXSL;
import com.yegor256.xsline.TrDefault;
import com.yegor256.xsline.Train;
import com.yegor256.xsline.Xsline;
import java.io.FileNotFoundException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eolang.xax.Xtory;
import org.yaml.snakeyaml.Yaml;

public final class XtYaml
implements Xtory {
    private final String yaml;
    private final Train<Shift> train;
    private final Xtory.Parser parser;

    public XtYaml(String yml) {
        this(yml, input -> {
            throw new UnsupportedOperationException("Parser is not provided, while YAML doesn't have the 'document' property");
        });
    }

    public XtYaml(String yml, Xtory.Parser prsr) {
        this(yml, prsr, (Train<Shift>)new TrDefault());
    }

    public XtYaml(String yml, Xtory.Parser prsr, Train<Shift> trn) {
        this.yaml = yml;
        this.parser = prsr;
        this.train = trn;
    }

    @Override
    public Map<String, Object> map() {
        return (Map)new Yaml().load((String)String.class.cast(this.yaml));
    }

    @Override
    public XML before() {
        XMLDocument xml;
        Object doc = this.map().get("document");
        if (doc == null) {
            Object input = this.map().get("input");
            if (input == null) {
                throw new IllegalArgumentException("Neither 'document' nor 'input' exists in the YAML");
            }
            try {
                xml = this.parser.parse(input.toString());
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex);
            }
        } else {
            xml = new XMLDocument(doc.toString());
        }
        return xml;
    }

    @Override
    public XML after() {
        return this.xsline().pass(this.before());
    }

    @Override
    public Xsline xsline() {
        List<Object> sheets = this.map().get("sheets");
        if (sheets == null) {
            sheets = Arrays.asList(new Object[0]);
        }
        Train trn = this.train;
        for (String sheet : (Iterable)sheets) {
            if (sheet.startsWith("file://")) {
                try {
                    trn = trn.with((Object)new StXSL((XSL)new XSLDocument(Paths.get(sheet.substring(7), new String[0]))));
                    continue;
                }
                catch (FileNotFoundException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
            trn = trn.with((Object)new StClasspath(sheet, new String[0]));
        }
        return new Xsline(trn);
    }

    @Override
    public Collection<String> asserts() {
        List<Object> asserts = this.map().get("asserts");
        if (asserts == null) {
            asserts = Arrays.asList(new Object[0]);
        }
        LinkedList<String> xpaths = new LinkedList<String>();
        for (String xpath : (Iterable)asserts) {
            xpaths.add(xpath);
        }
        return xpaths;
    }
}

