/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.xax;

import com.jcabi.xml.XML;
import java.util.AbstractMap;
import java.util.LinkedList;
import java.util.Map;
import org.eolang.xax.Xtory;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.Assumptions;

public final class XtoryMatcher
extends BaseMatcher<Xtory> {
    private String header;
    private String summary;
    private boolean match;
    private final Matcher<XML> extra;

    public XtoryMatcher() {
        this((Matcher<XML>)new BaseMatcher<XML>(){

            public boolean matches(Object input) {
                return true;
            }

            public void describeTo(Description description) {
                assert (description != null);
            }
        });
    }

    public XtoryMatcher(Matcher<XML> ext) {
        this.extra = ext;
    }

    public boolean matches(Object object) {
        Xtory xtory = (Xtory)Xtory.class.cast(object);
        Assumptions.assumeTrue((xtory.map().get("skip") == null ? 1 : 0) != 0);
        XML after = xtory.xsline().pass(xtory.before());
        LinkedList<AbstractMap.SimpleImmutableEntry<String, Boolean>> xpaths = new LinkedList<AbstractMap.SimpleImmutableEntry<String, Boolean>>();
        int failures = 0;
        for (String xpath : xtory.asserts()) {
            boolean bl = !after.nodes(xpath).isEmpty();
            xpaths.add(new AbstractMap.SimpleImmutableEntry<String, Boolean>(xpath, bl));
            if (bl) continue;
            ++failures;
        }
        this.header = String.format("All %d XPath expressions matched", xpaths.size());
        StringBuilder sum = new StringBuilder(1024).append(String.format("%d XPath expression(s) failed:\n", failures));
        for (Map.Entry entry : xpaths) {
            sum.append("  ");
            if (((Boolean)entry.getValue()).booleanValue()) {
                sum.append("OK");
            } else {
                sum.append("FAIL");
            }
            sum.append(": ").append((String)entry.getKey()).append('\n');
        }
        sum.append("\nXML before XSL transformation:\n  ").append(xtory.before().toString().replace("\n", "\n  ")).append(String.format("\nXML after XSL transformation (%d->%d chars):\n  ", xtory.before().toString().length(), after.toString().length())).append(after.toString().replace("\n", "\n  "));
        this.summary = sum.toString();
        this.match = true;
        for (Map.Entry entry : xpaths) {
            if (((Boolean)entry.getValue()).booleanValue()) continue;
            this.match = false;
            break;
        }
        return this.match && this.extra.matches((Object)after);
    }

    public void describeTo(Description desc) {
        if (this.match) {
            this.extra.describeTo(desc);
        } else {
            desc.appendText(this.header);
        }
    }

    public void describeMismatch(Object story, Description desc) {
        if (this.match) {
            this.extra.describeMismatch(story, desc);
        } else {
            desc.appendText("\n").appendText(this.summary);
        }
    }
}

