/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca;

import gov.aps.jca.CAException;
import gov.aps.jca.Channel;
import gov.aps.jca.Context;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.event.ConnectionEvent;
import gov.aps.jca.event.ConnectionListener;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.epics.ca.BaseV3ChannelGet;
import org.epics.ca.BaseV3ChannelPut;
import org.epics.ca.BaseV3Monitor;
import org.epics.ca.V3Channel;
import org.epics.pvaccess.client.AccessRights;
import org.epics.pvaccess.client.Channel;
import org.epics.pvaccess.client.ChannelArray;
import org.epics.pvaccess.client.ChannelArrayRequester;
import org.epics.pvaccess.client.ChannelFind;
import org.epics.pvaccess.client.ChannelFindRequester;
import org.epics.pvaccess.client.ChannelGet;
import org.epics.pvaccess.client.ChannelGetRequester;
import org.epics.pvaccess.client.ChannelProcess;
import org.epics.pvaccess.client.ChannelProcessRequester;
import org.epics.pvaccess.client.ChannelProvider;
import org.epics.pvaccess.client.ChannelPut;
import org.epics.pvaccess.client.ChannelPutGet;
import org.epics.pvaccess.client.ChannelPutGetRequester;
import org.epics.pvaccess.client.ChannelPutRequester;
import org.epics.pvaccess.client.ChannelRPC;
import org.epics.pvaccess.client.ChannelRPCRequester;
import org.epics.pvaccess.client.ChannelRequester;
import org.epics.pvaccess.client.GetFieldRequester;
import org.epics.pvdata.factory.StandardFieldFactory;
import org.epics.pvdata.factory.StatusFactory;
import org.epics.pvdata.monitor.Monitor;
import org.epics.pvdata.monitor.MonitorRequester;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.MessageType;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.ScalarType;
import org.epics.pvdata.pv.StandardField;
import org.epics.pvdata.pv.Status;
import org.epics.pvdata.pv.StatusCreate;
import org.epics.pvdata.pv.Structure;
import org.epics.pvdata.pv.Type;

public class BaseV3Channel
implements ChannelFind,
Channel,
V3Channel,
ConnectionListener {
    private static final StandardField standardField = StandardFieldFactory.getStandardField();
    private static final StatusCreate statusCreate = StatusFactory.getStatusCreate();
    private static final Status okStatus = statusCreate.getStatusOK();
    private static final Status notSupportedStatus = statusCreate.createStatus(Status.StatusType.ERROR, "not supported", null);
    private static final Status channelNotConnectedStatus = statusCreate.createStatus(Status.StatusType.ERROR, "channel not connected", null);
    private static final Status subFieldDoesNotExistStatus = statusCreate.createStatus(Status.StatusType.ERROR, "subField does not exist", null);
    private final ChannelProvider channelProvider;
    private final ChannelFindRequester channelFindRequester;
    private final ChannelRequester channelRequester;
    private final Context context;
    private final String channelName;
    private final AtomicBoolean gotFirstConnection = new AtomicBoolean(false);
    private final LinkedList<ChannelGet> channelGetList = new LinkedList();
    private final LinkedList<ChannelPut> channelPutList = new LinkedList();
    private final LinkedList<Monitor> monitorList = new LinkedList();
    private volatile gov.aps.jca.Channel jcaChannel = null;
    private boolean isDestroyed = false;

    BaseV3Channel(ChannelProvider channelProvider, ChannelFindRequester channelFindRequester, ChannelRequester channelRequester, Context context, String channelName) {
        this.channelProvider = channelProvider;
        this.channelFindRequester = channelFindRequester;
        this.channelRequester = channelRequester;
        this.context = context;
        this.channelName = channelName;
    }

    public void connectCaV3() {
        try {
            this.jcaChannel = this.context.createChannel(this.channelName, (ConnectionListener)this);
        }
        catch (CAException e) {
            if (this.channelFindRequester != null) {
                this.channelFindRequester.channelFindResult(statusCreate.createStatus(Status.StatusType.FATAL, "failed to create channel", (Throwable)e), this, false);
            } else {
                this.channelRequester.channelCreated(channelNotConnectedStatus, null);
            }
            this.jcaChannel = null;
        }
    }

    @Override
    public void cancel() {
        this.jcaChannel.dispose();
        this.jcaChannel = null;
    }

    @Override
    public ChannelProvider getChannelProvider() {
        return this.channelProvider;
    }

    @Override
    public Channel.ConnectionState getConnectionState() {
        Channel.ConnectionState connectionState = this.jcaChannel.getConnectionState();
        if (connectionState == Channel.ConnectionState.DISCONNECTED) {
            return Channel.ConnectionState.DISCONNECTED;
        }
        if (connectionState == Channel.ConnectionState.CONNECTED) {
            return Channel.ConnectionState.CONNECTED;
        }
        if (connectionState == Channel.ConnectionState.NEVER_CONNECTED) {
            return Channel.ConnectionState.NEVER_CONNECTED;
        }
        if (connectionState == Channel.ConnectionState.CLOSED) {
            return Channel.ConnectionState.DESTROYED;
        }
        throw new RuntimeException("unknown connection state");
    }

    @Override
    public String getRemoteAddress() {
        return this.jcaChannel.getHostName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(ChannelGet channelGet) {
        boolean result = false;
        LinkedList<ChannelGet> linkedList = this.channelGetList;
        synchronized (linkedList) {
            result = this.channelGetList.add(channelGet);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(ChannelPut channelPut) {
        boolean result = false;
        LinkedList<ChannelPut> linkedList = this.channelPutList;
        synchronized (linkedList) {
            result = this.channelPutList.add(channelPut);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Monitor monitor) {
        boolean result = false;
        LinkedList<Monitor> linkedList = this.monitorList;
        synchronized (linkedList) {
            result = this.monitorList.add(monitor);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(ChannelGet channelGet) {
        boolean result = false;
        LinkedList<ChannelGet> linkedList = this.channelGetList;
        synchronized (linkedList) {
            result = this.channelGetList.remove(channelGet);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(ChannelPut channelPut) {
        boolean result = false;
        LinkedList<ChannelPut> linkedList = this.channelPutList;
        synchronized (linkedList) {
            result = this.channelPutList.remove(channelPut);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Monitor monitor) {
        boolean result = false;
        LinkedList<Monitor> linkedList = this.monitorList;
        synchronized (linkedList) {
            result = this.monitorList.remove(monitor);
        }
        return result;
    }

    @Override
    public ChannelArray createChannelArray(ChannelArrayRequester channelArrayRequester, PVStructure pvRequest) {
        channelArrayRequester.channelArrayConnect(notSupportedStatus, null, null);
        return null;
    }

    @Override
    public ChannelGet createChannelGet(ChannelGetRequester channelGetRequester, PVStructure pvRequest) {
        return new BaseV3ChannelGet(channelGetRequester, this, pvRequest);
    }

    @Override
    public Monitor createMonitor(MonitorRequester monitorRequester, PVStructure pvRequest) {
        return new BaseV3Monitor(monitorRequester, this, pvRequest);
    }

    @Override
    public ChannelProcess createChannelProcess(ChannelProcessRequester channelProcessRequester, PVStructure pvRequest) {
        channelProcessRequester.channelProcessConnect(notSupportedStatus, null);
        return null;
    }

    @Override
    public ChannelPut createChannelPut(ChannelPutRequester channelPutRequester, PVStructure pvRequest) {
        return new BaseV3ChannelPut(channelPutRequester, this, pvRequest);
    }

    @Override
    public ChannelPutGet createChannelPutGet(ChannelPutGetRequester channelPutGetRequester, PVStructure pvRequest) {
        channelPutGetRequester.channelPutGetConnect(notSupportedStatus, null, null, null);
        return null;
    }

    @Override
    public ChannelRPC createChannelRPC(ChannelRPCRequester channelRPCRequester, PVStructure pvRequest) {
        channelRPCRequester.channelRPCConnect(notSupportedStatus, null);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        block9: {
            BaseV3Channel baseV3Channel = this;
            synchronized (baseV3Channel) {
                if (this.isDestroyed) {
                    return;
                }
                this.isDestroyed = true;
            }
            while (!this.channelGetList.isEmpty()) {
                ChannelGet channelGet = this.channelGetList.getFirst();
                channelGet.destroy();
            }
            while (!this.channelPutList.isEmpty()) {
                ChannelPut channelPut = this.channelPutList.getFirst();
                channelPut.destroy();
            }
            while (!this.monitorList.isEmpty()) {
                Monitor monitor = this.monitorList.getFirst();
                monitor.destroy();
            }
            try {
                this.jcaChannel.destroy();
            }
            catch (CAException e) {
                if (this.channelRequester == null) break block9;
                this.channelRequester.message("destroy caused CAException " + e.getMessage(), MessageType.error);
            }
        }
        this.jcaChannel = null;
    }

    @Override
    public AccessRights getAccessRights(PVField pvField) {
        return null;
    }

    @Override
    public String getChannelName() {
        return this.channelName;
    }

    @Override
    public ChannelRequester getChannelRequester() {
        return this.channelRequester;
    }

    @Override
    public void getField(GetFieldRequester requester, String subField) {
        if (subField == null || subField.length() == 0) {
            subField = "value";
        } else if (!subField.equals("value")) {
            requester.getDone(subFieldDoesNotExistStatus, null);
            return;
        }
        DBRType nativeDBRType = this.jcaChannel.getFieldType();
        boolean extraProperties = true;
        Type valueType = null;
        ScalarType valueScalarType = null;
        if (nativeDBRType == DBRType.ENUM) {
            valueType = Type.structure;
            extraProperties = false;
        } else if (nativeDBRType == DBRType.STRING) {
            valueScalarType = ScalarType.pvString;
            extraProperties = false;
        } else if (nativeDBRType == DBRType.BYTE) {
            valueScalarType = ScalarType.pvByte;
        } else if (nativeDBRType == DBRType.SHORT) {
            valueScalarType = ScalarType.pvShort;
        } else if (nativeDBRType == DBRType.INT) {
            valueScalarType = ScalarType.pvInt;
        } else if (nativeDBRType == DBRType.FLOAT) {
            valueScalarType = ScalarType.pvFloat;
        } else if (nativeDBRType == DBRType.DOUBLE) {
            valueScalarType = ScalarType.pvDouble;
        }
        if (valueType == null) {
            valueType = this.jcaChannel.getElementCount() > 1 ? Type.scalarArray : Type.scalar;
        }
        String properties = "timeStamp,alarm";
        if (extraProperties) {
            properties = properties + ",display,control,valueAlarm";
        }
        Structure structure = null;
        switch (valueType) {
            case scalar: {
                structure = standardField.scalar(valueScalarType, properties);
                break;
            }
            case scalarArray: {
                structure = standardField.scalarArray(valueScalarType, properties);
                break;
            }
            case structure: {
                structure = standardField.enumerated(properties);
            }
        }
        requester.getDone(okStatus, (Field)structure);
    }

    @Override
    public ChannelProvider getProvider() {
        return this.channelProvider;
    }

    @Override
    public boolean isConnected() {
        gov.aps.jca.Channel ch = this.jcaChannel;
        if (ch != null) {
            return ch.getConnectionState() == Channel.ConnectionState.CONNECTED;
        }
        return false;
    }

    public String getRequesterName() {
        return this.channelRequester.getRequesterName();
    }

    public void message(String message, MessageType messageType) {
        this.channelRequester.message(message, messageType);
    }

    @Override
    public gov.aps.jca.Channel getJCAChannel() {
        return this.jcaChannel;
    }

    public void connectionChanged(ConnectionEvent arg0) {
        boolean isConnected = arg0.isConnected();
        if (isConnected) {
            if (this.gotFirstConnection.getAndSet(true)) {
                this.channelRequester.channelStateChange(this, Channel.ConnectionState.CONNECTED);
                return;
            }
            if (this.channelFindRequester != null) {
                this.channelFindRequester.channelFindResult(okStatus, this, true);
                this.destroy();
                return;
            }
            this.channelRequester.channelCreated(okStatus, this);
            this.channelRequester.channelStateChange(this, Channel.ConnectionState.CONNECTED);
        } else {
            this.channelRequester.channelStateChange(this, Channel.ConnectionState.DISCONNECTED);
        }
    }
}

