/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca;

import gov.aps.jca.Channel;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.dbr.DBR_Byte;
import gov.aps.jca.dbr.DBR_CTRL_Byte;
import gov.aps.jca.dbr.DBR_CTRL_Double;
import gov.aps.jca.dbr.DBR_CTRL_Enum;
import gov.aps.jca.dbr.DBR_CTRL_Float;
import gov.aps.jca.dbr.DBR_CTRL_Int;
import gov.aps.jca.dbr.DBR_CTRL_Short;
import gov.aps.jca.dbr.DBR_CTRL_String;
import gov.aps.jca.dbr.DBR_Double;
import gov.aps.jca.dbr.DBR_Enum;
import gov.aps.jca.dbr.DBR_Float;
import gov.aps.jca.dbr.DBR_GR_Byte;
import gov.aps.jca.dbr.DBR_GR_Double;
import gov.aps.jca.dbr.DBR_GR_Float;
import gov.aps.jca.dbr.DBR_GR_Int;
import gov.aps.jca.dbr.DBR_GR_Short;
import gov.aps.jca.dbr.DBR_GR_String;
import gov.aps.jca.dbr.DBR_Int;
import gov.aps.jca.dbr.DBR_STS_Byte;
import gov.aps.jca.dbr.DBR_STS_Double;
import gov.aps.jca.dbr.DBR_STS_Enum;
import gov.aps.jca.dbr.DBR_STS_Float;
import gov.aps.jca.dbr.DBR_STS_Int;
import gov.aps.jca.dbr.DBR_STS_Short;
import gov.aps.jca.dbr.DBR_STS_String;
import gov.aps.jca.dbr.DBR_Short;
import gov.aps.jca.dbr.DBR_String;
import gov.aps.jca.dbr.DBR_TIME_Byte;
import gov.aps.jca.dbr.DBR_TIME_Double;
import gov.aps.jca.dbr.DBR_TIME_Enum;
import gov.aps.jca.dbr.DBR_TIME_Float;
import gov.aps.jca.dbr.DBR_TIME_Int;
import gov.aps.jca.dbr.DBR_TIME_Short;
import gov.aps.jca.dbr.DBR_TIME_String;
import gov.aps.jca.dbr.Severity;
import gov.aps.jca.dbr.Status;
import gov.aps.jca.dbr.TimeStamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.epics.ca.V3Channel;
import org.epics.ca.V3ChannelStructure;
import org.epics.pvdata.factory.ConvertFactory;
import org.epics.pvdata.factory.PVDataFactory;
import org.epics.pvdata.factory.StandardFieldFactory;
import org.epics.pvdata.factory.StandardPVFieldFactory;
import org.epics.pvdata.misc.BitSet;
import org.epics.pvdata.property.AlarmSeverity;
import org.epics.pvdata.property.AlarmStatus;
import org.epics.pvdata.property.PVEnumerated;
import org.epics.pvdata.property.PVEnumeratedFactory;
import org.epics.pvdata.pv.Convert;
import org.epics.pvdata.pv.MessageType;
import org.epics.pvdata.pv.PVDataCreate;
import org.epics.pvdata.pv.PVDouble;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVInt;
import org.epics.pvdata.pv.PVLong;
import org.epics.pvdata.pv.PVScalar;
import org.epics.pvdata.pv.PVScalarArray;
import org.epics.pvdata.pv.PVString;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.ScalarType;
import org.epics.pvdata.pv.StandardField;
import org.epics.pvdata.pv.StandardPVField;
import org.epics.pvdata.pv.Structure;
import org.epics.pvdata.pv.Type;

public class BaseV3ChannelStructure
implements V3ChannelStructure {
    private static final Convert convert = ConvertFactory.getConvert();
    private static final StandardField standardField = StandardFieldFactory.getStandardField();
    private static final StandardPVField standardPVField = StandardPVFieldFactory.getStandardPVField();
    private static final PVDataCreate pvDataCreate = PVDataFactory.getPVDataCreate();
    private static final Map<Status, AlarmStatus> statusMap = new HashMap<Status, AlarmStatus>();
    private final V3Channel v3Channel;
    private DBRType nativeDBRType = null;
    private DBRType requestDBRType = null;
    private PVStructure pvStructure = null;
    private BitSet bitSet = null;
    private PVStructure pvAlarm = null;
    private PVString pvAlarmMessage = null;
    private PVInt pvAlarmSeverity = null;
    private PVInt pvAlarmStatus = null;
    private PVStructure pvTimeStamp = null;
    private PVLong pvSeconds = null;
    private PVInt pvNanoseconds = null;
    private PVScalar pvScalarValue = null;
    private PVScalarArray pvArrayValue = null;
    private PVEnumerated pvEnumerated = null;
    private PVInt pvEnumeratedIndex = null;
    private final AtomicBoolean firstGetPVStructure = new AtomicBoolean(true);

    public BaseV3ChannelStructure(V3Channel v3Channel) {
        this.v3Channel = v3Channel;
    }

    @Override
    public PVStructure createPVStructure(PVStructure pvRequest, boolean propertiesAllowed) {
        ArrayList<String> propertyList = new ArrayList<String>();
        Channel jcaChannel = this.v3Channel.getJCAChannel();
        int elementCount = jcaChannel.getElementCount();
        this.nativeDBRType = jcaChannel.getFieldType();
        PVField[] pvFields = null;
        PVField pvf = pvRequest.getSubField("field");
        if (pvf != null && pvf.getField().getType() == Type.structure) {
            PVStructure pvStruct = pvRequest.getStructureField("field");
            pvFields = pvStruct.getPVFields();
        } else {
            pvFields = pvRequest.getPVFields();
        }
        boolean valueIsIndex = false;
        boolean valueIsChoice = false;
        if (pvFields.length == 0 && propertiesAllowed) {
            propertyList.add("timeStamp");
            propertyList.add("alarm");
            if (this.nativeDBRType != DBRType.ENUM) {
                propertyList.add("display");
                propertyList.add("control");
                if (this.nativeDBRType != DBRType.STRING) {
                    propertyList.add("valueAlarm");
                }
            }
        }
        for (int indField = 0; indField < pvFields.length; ++indField) {
            PVStructure pvValue;
            PVField[] pvValueFields;
            PVField pvField = pvFields[indField];
            if (pvField.getFieldName().equals("alarm")) {
                if (!propertiesAllowed) continue;
                propertyList.add("alarm");
                continue;
            }
            if (pvField.getFieldName().equals("timeStamp")) {
                if (!propertiesAllowed) continue;
                propertyList.add("timeStamp");
                continue;
            }
            if (pvField.getFieldName().equals("display")) {
                if (!propertiesAllowed || this.nativeDBRType == DBRType.ENUM) continue;
                propertyList.add("display");
                continue;
            }
            if (pvField.getFieldName().equals("control")) {
                if (!propertiesAllowed || this.nativeDBRType == DBRType.ENUM) continue;
                propertyList.add("control");
                continue;
            }
            if (pvField.getFieldName().equals("valueAlarm")) {
                if (!propertiesAllowed || this.nativeDBRType == DBRType.STRING || this.nativeDBRType == DBRType.ENUM) continue;
                propertyList.add("valueAlarm");
                continue;
            }
            if (!pvField.getFieldName().equals("value")) {
                String message = pvField.toString() + " name not suported";
                this.v3Channel.message(message, MessageType.error);
                continue;
            }
            if (this.nativeDBRType != DBRType.ENUM || (pvValueFields = (pvValue = (PVStructure)pvField).getPVFields()).length == 0) continue;
            if (pvValueFields.length != 1) {
                valueIsChoice = true;
                String message = pvField.toString() + " value has unsupported subfields";
                this.v3Channel.message(message, MessageType.error);
                continue;
            }
            String fieldName = pvValueFields[0].getFieldName();
            if (fieldName.equals("index")) {
                valueIsIndex = true;
                continue;
            }
            valueIsChoice = true;
        }
        if (this.nativeDBRType.isENUM()) {
            if (valueIsIndex) {
                this.nativeDBRType = DBRType.INT;
            } else if (valueIsChoice) {
                this.nativeDBRType = DBRType.STRING;
            }
        }
        DBRProperty dbrProperty = DBRProperty.none;
        if (propertyList.size() > 0) {
            for (String propertyName : propertyList) {
                if (propertyName.equals("alarm") && dbrProperty.compareTo(DBRProperty.status) < 0) {
                    dbrProperty = DBRProperty.status;
                    continue;
                }
                if (propertyName.equals("timeStamp") && dbrProperty.compareTo(DBRProperty.time) < 0) {
                    dbrProperty = DBRProperty.time;
                    continue;
                }
                if (propertyName.equals("display") && dbrProperty.compareTo(DBRProperty.graphic) < 0) {
                    dbrProperty = DBRProperty.graphic;
                    continue;
                }
                if (propertyName.equals("control") && dbrProperty.compareTo(DBRProperty.control) < 0) {
                    dbrProperty = DBRProperty.control;
                    continue;
                }
                if (!propertyName.equals("valueAlarm") || dbrProperty.compareTo(DBRProperty.control) >= 0) continue;
                dbrProperty = DBRProperty.control;
            }
        }
        Type type = Type.scalar;
        ScalarType scalarType = null;
        if (this.nativeDBRType.isBYTE()) {
            scalarType = ScalarType.pvByte;
        } else if (this.nativeDBRType.isSHORT()) {
            scalarType = ScalarType.pvShort;
        } else if (this.nativeDBRType.isINT()) {
            scalarType = ScalarType.pvInt;
        } else if (this.nativeDBRType.isFLOAT()) {
            scalarType = ScalarType.pvFloat;
        } else if (this.nativeDBRType.isDOUBLE()) {
            scalarType = ScalarType.pvDouble;
        } else if (this.nativeDBRType.isSTRING()) {
            scalarType = ScalarType.pvString;
        } else if (this.nativeDBRType.isENUM()) {
            type = Type.structure;
        }
        String properties = ((Object)propertyList).toString();
        if (elementCount > 1 && type == Type.scalar) {
            type = Type.scalarArray;
        }
        switch (type) {
            case scalar: {
                this.pvStructure = standardPVField.scalar(scalarType, properties);
                break;
            }
            case scalarArray: {
                this.pvStructure = standardPVField.scalarArray(scalarType, properties);
                break;
            }
            case structure: {
                Structure field = standardField.enumerated(properties);
                this.pvStructure = pvDataCreate.createPVStructure(field);
            }
        }
        if (this.nativeDBRType.isENUM()) {
            PVStructure pvStruct = (PVStructure)this.pvStructure.getPVFields()[0];
            this.pvEnumeratedIndex = pvStruct.getIntField("index");
            this.pvEnumerated = PVEnumeratedFactory.create();
            if (this.pvEnumeratedIndex == null || !this.pvEnumerated.attach((PVField)pvStruct)) {
                this.v3Channel.message("field is not an enumerated structure ", MessageType.error);
                return null;
            }
        }
        if (this.pvStructure.getSubField("alarm") != null) {
            this.pvAlarm = this.pvStructure.getStructureField("alarm");
            if (this.pvAlarm != null) {
                this.pvAlarmMessage = this.pvAlarm.getStringField("message");
                this.pvAlarmSeverity = this.pvAlarm.getIntField("severity");
                this.pvAlarmStatus = this.pvAlarm.getIntField("status");
            }
        }
        if (this.pvStructure.getSubField("timeStamp") != null) {
            this.pvTimeStamp = this.pvStructure.getStructureField("timeStamp");
            if (this.pvTimeStamp != null) {
                this.pvSeconds = this.pvTimeStamp.getLongField("secondsPastEpoch");
                this.pvNanoseconds = this.pvTimeStamp.getIntField("nanoseconds");
            }
        }
        this.bitSet = new BitSet(this.pvStructure.getNumberFields());
        PVField pvValue = this.pvStructure.getPVFields()[0];
        if (this.nativeDBRType.isENUM()) {
            this.requestDBRType = DBRType.CTRL_ENUM;
            return this.pvStructure;
        }
        if (elementCount < 2) {
            this.pvScalarValue = (PVScalar)pvValue;
        } else {
            this.pvArrayValue = (PVScalarArray)pvValue;
        }
        this.requestDBRType = null;
        switch (dbrProperty) {
            case none: {
                this.requestDBRType = this.nativeDBRType;
                break;
            }
            case status: {
                if (this.nativeDBRType == DBRType.BYTE) {
                    this.requestDBRType = DBRType.STS_BYTE;
                    break;
                }
                if (this.nativeDBRType == DBRType.SHORT) {
                    this.requestDBRType = DBRType.STS_SHORT;
                    break;
                }
                if (this.nativeDBRType == DBRType.INT) {
                    this.requestDBRType = DBRType.STS_INT;
                    break;
                }
                if (this.nativeDBRType == DBRType.FLOAT) {
                    this.requestDBRType = DBRType.STS_FLOAT;
                    break;
                }
                if (this.nativeDBRType == DBRType.DOUBLE) {
                    this.requestDBRType = DBRType.STS_DOUBLE;
                    break;
                }
                if (this.nativeDBRType == DBRType.STRING) {
                    this.requestDBRType = DBRType.STS_STRING;
                    break;
                }
                if (this.nativeDBRType != DBRType.ENUM) break;
                this.requestDBRType = DBRType.STS_ENUM;
                break;
            }
            case time: {
                if (this.nativeDBRType == DBRType.BYTE) {
                    this.requestDBRType = DBRType.TIME_BYTE;
                    break;
                }
                if (this.nativeDBRType == DBRType.SHORT) {
                    this.requestDBRType = DBRType.TIME_SHORT;
                    break;
                }
                if (this.nativeDBRType == DBRType.INT) {
                    this.requestDBRType = DBRType.TIME_INT;
                    break;
                }
                if (this.nativeDBRType == DBRType.FLOAT) {
                    this.requestDBRType = DBRType.TIME_FLOAT;
                    break;
                }
                if (this.nativeDBRType == DBRType.DOUBLE) {
                    this.requestDBRType = DBRType.TIME_DOUBLE;
                    break;
                }
                if (this.nativeDBRType == DBRType.STRING) {
                    this.requestDBRType = DBRType.TIME_STRING;
                    break;
                }
                if (this.nativeDBRType != DBRType.ENUM) break;
                this.requestDBRType = DBRType.TIME_ENUM;
                break;
            }
            case graphic: {
                if (this.nativeDBRType == DBRType.BYTE) {
                    this.requestDBRType = DBRType.GR_BYTE;
                    break;
                }
                if (this.nativeDBRType == DBRType.SHORT) {
                    this.requestDBRType = DBRType.GR_SHORT;
                    break;
                }
                if (this.nativeDBRType == DBRType.INT) {
                    this.requestDBRType = DBRType.GR_INT;
                    break;
                }
                if (this.nativeDBRType == DBRType.FLOAT) {
                    this.requestDBRType = DBRType.GR_FLOAT;
                    break;
                }
                if (this.nativeDBRType == DBRType.DOUBLE) {
                    this.requestDBRType = DBRType.GR_DOUBLE;
                    break;
                }
                if (this.nativeDBRType == DBRType.STRING) {
                    this.requestDBRType = DBRType.GR_STRING;
                    break;
                }
                if (this.nativeDBRType != DBRType.ENUM) break;
                this.requestDBRType = DBRType.CTRL_ENUM;
                break;
            }
            case control: {
                if (this.nativeDBRType == DBRType.BYTE) {
                    this.requestDBRType = DBRType.CTRL_BYTE;
                    break;
                }
                if (this.nativeDBRType == DBRType.SHORT) {
                    this.requestDBRType = DBRType.CTRL_SHORT;
                    break;
                }
                if (this.nativeDBRType == DBRType.INT) {
                    this.requestDBRType = DBRType.CTRL_INT;
                    break;
                }
                if (this.nativeDBRType == DBRType.FLOAT) {
                    this.requestDBRType = DBRType.CTRL_FLOAT;
                    break;
                }
                if (this.nativeDBRType == DBRType.DOUBLE) {
                    this.requestDBRType = DBRType.CTRL_DOUBLE;
                    break;
                }
                if (this.nativeDBRType == DBRType.STRING) {
                    this.requestDBRType = DBRType.CTRL_STRING;
                    break;
                }
                if (this.nativeDBRType != DBRType.ENUM) break;
                this.requestDBRType = DBRType.CTRL_ENUM;
            }
        }
        return this.pvStructure;
    }

    @Override
    public PVStructure getPVStructure() {
        return this.pvStructure;
    }

    @Override
    public BitSet getBitSet() {
        return this.bitSet;
    }

    @Override
    public DBRType getNativeDBRType() {
        return this.nativeDBRType;
    }

    @Override
    public DBRType getRequestDBRType() {
        return this.requestDBRType;
    }

    private void setAlarm(AlarmStatus alarmStatus, AlarmSeverity alarmSeverity, String message) {
        int severity = alarmSeverity.ordinal();
        int status = alarmStatus.ordinal();
        if (this.pvAlarm != null) {
            String oldMessage = this.pvAlarmMessage.get();
            if (oldMessage != message || message != null && !message.equals(oldMessage)) {
                this.pvAlarmMessage.put(message);
            }
            this.pvAlarmSeverity.put(severity);
            this.pvAlarmStatus.put(status);
        } else {
            System.err.println(this.v3Channel.getChannelName() + " v3Ca error " + message + " severity " + alarmSeverity.toString() + " status " + alarmStatus.toString());
        }
    }

    @Override
    public void toStructure(DBR fromDBR) {
        PVDouble pvHigh;
        PVString pvUnits;
        if (fromDBR == null) {
            this.setAlarm(AlarmStatus.UNDEFINED, AlarmSeverity.INVALID, "fromDBR is null");
            return;
        }
        Status status = null;
        TimeStamp timeStamp = null;
        Severity severity = null;
        Channel jcaChannel = this.v3Channel.getJCAChannel();
        int elementCount = jcaChannel.getElementCount();
        double displayLow = 0.0;
        double displayHigh = 0.0;
        double controlLow = 0.0;
        double controlHigh = 0.0;
        double lowAlarmLimit = 0.0;
        double lowWarningLimit = 0.0;
        double highWarningLimit = 0.0;
        double highAlarmLimit = 0.0;
        String units = null;
        this.bitSet.clear();
        DBRType requestDBRType = fromDBR.getType();
        if (this.nativeDBRType.isENUM()) {
            DBR_Enum dbr;
            int index = this.pvEnumerated.getIndex();
            if (requestDBRType == DBRType.ENUM) {
                dbr = (DBR_Enum)fromDBR;
                index = dbr.getEnumValue()[0];
            } else if (requestDBRType == DBRType.TIME_ENUM) {
                dbr = (DBR_TIME_Enum)fromDBR;
                index = dbr.getEnumValue()[0];
                status = dbr.getStatus();
                severity = dbr.getSeverity();
                timeStamp = dbr.getTimeStamp();
            } else if (requestDBRType == DBRType.STS_ENUM) {
                dbr = (DBR_STS_Enum)fromDBR;
                index = dbr.getEnumValue()[0];
                status = dbr.getStatus();
                severity = dbr.getSeverity();
            } else if (requestDBRType == DBRType.CTRL_ENUM) {
                dbr = (DBR_CTRL_Enum)fromDBR;
                String[] labels = dbr.getLabels();
                this.pvEnumerated.setChoices(labels);
                index = dbr.getEnumValue()[0];
                status = dbr.getStatus();
                severity = dbr.getSeverity();
                this.requestDBRType = this.pvTimeStamp != null ? DBRType.TIME_ENUM : (this.pvAlarmSeverity != null ? DBRType.STS_ENUM : DBRType.ENUM);
            } else {
                this.setAlarm(AlarmStatus.UNDEFINED, AlarmSeverity.INVALID, " unsupported DBRType " + requestDBRType.getName());
                return;
            }
            if (index != this.pvEnumerated.getIndex()) {
                this.pvEnumerated.setIndex(index);
            }
        } else if (requestDBRType == DBRType.DOUBLE) {
            DBR_Double dbr = (DBR_Double)fromDBR;
            if (elementCount == 1) {
                convert.fromDouble(this.pvScalarValue, dbr.getDoubleValue()[0]);
            } else {
                convert.fromDoubleArray(this.pvArrayValue, 0, dbr.getCount(), dbr.getDoubleValue(), 0);
            }
        } else if (requestDBRType == DBRType.STS_DOUBLE) {
            DBR_STS_Double dbr = (DBR_STS_Double)fromDBR;
            status = dbr.getStatus();
            severity = dbr.getSeverity();
            if (elementCount == 1) {
                convert.fromDouble(this.pvScalarValue, dbr.getDoubleValue()[0]);
            } else {
                convert.fromDoubleArray(this.pvArrayValue, 0, dbr.getCount(), dbr.getDoubleValue(), 0);
            }
        } else if (requestDBRType == DBRType.TIME_DOUBLE) {
            DBR_TIME_Double dbr = (DBR_TIME_Double)fromDBR;
            status = dbr.getStatus();
            timeStamp = dbr.getTimeStamp();
            severity = dbr.getSeverity();
            if (elementCount == 1) {
                convert.fromDouble(this.pvScalarValue, dbr.getDoubleValue()[0]);
            } else {
                convert.fromDoubleArray(this.pvArrayValue, 0, dbr.getCount(), dbr.getDoubleValue(), 0);
            }
        } else if (requestDBRType == DBRType.SHORT) {
            DBR_Short dbr = (DBR_Short)fromDBR;
            if (elementCount == 1) {
                convert.fromShort(this.pvScalarValue, dbr.getShortValue()[0]);
            } else {
                convert.fromShortArray(this.pvArrayValue, 0, dbr.getCount(), dbr.getShortValue(), 0);
            }
        } else if (requestDBRType == DBRType.STS_SHORT) {
            DBR_STS_Short dbr = (DBR_STS_Short)fromDBR;
            status = dbr.getStatus();
            severity = dbr.getSeverity();
            if (elementCount == 1) {
                convert.fromShort(this.pvScalarValue, dbr.getShortValue()[0]);
            } else {
                convert.fromShortArray(this.pvArrayValue, 0, dbr.getCount(), dbr.getShortValue(), 0);
            }
        } else if (requestDBRType == DBRType.TIME_SHORT) {
            DBR_TIME_Short dbr = (DBR_TIME_Short)fromDBR;
            status = dbr.getStatus();
            timeStamp = dbr.getTimeStamp();
            severity = dbr.getSeverity();
            if (elementCount == 1) {
                convert.fromShort(this.pvScalarValue, dbr.getShortValue()[0]);
            } else {
                convert.fromShortArray(this.pvArrayValue, 0, dbr.getCount(), dbr.getShortValue(), 0);
            }
        } else if (requestDBRType == DBRType.INT) {
            DBR_Int dbr = (DBR_Int)fromDBR;
            if (elementCount == 1) {
                convert.fromInt(this.pvScalarValue, dbr.getIntValue()[0]);
            } else {
                convert.fromIntArray(this.pvArrayValue, 0, dbr.getCount(), dbr.getIntValue(), 0);
            }
        } else if (requestDBRType == DBRType.STS_INT) {
            DBR_STS_Int dbr = (DBR_STS_Int)fromDBR;
            status = dbr.getStatus();
            severity = dbr.getSeverity();
            if (elementCount == 1) {
                convert.fromInt(this.pvScalarValue, dbr.getIntValue()[0]);
            } else {
                convert.fromIntArray(this.pvArrayValue, 0, dbr.getCount(), dbr.getIntValue(), 0);
            }
        } else if (requestDBRType == DBRType.TIME_INT) {
            DBR_TIME_Int dbr = (DBR_TIME_Int)fromDBR;
            status = dbr.getStatus();
            timeStamp = dbr.getTimeStamp();
            severity = dbr.getSeverity();
            if (elementCount == 1) {
                convert.fromInt(this.pvScalarValue, dbr.getIntValue()[0]);
            } else {
                convert.fromIntArray(this.pvArrayValue, 0, dbr.getCount(), dbr.getIntValue(), 0);
            }
        } else if (requestDBRType == DBRType.BYTE) {
            DBR_Byte dbr = (DBR_Byte)fromDBR;
            if (elementCount == 1) {
                convert.fromByte(this.pvScalarValue, dbr.getByteValue()[0]);
            } else {
                convert.fromByteArray(this.pvArrayValue, 0, dbr.getCount(), dbr.getByteValue(), 0);
            }
        } else if (requestDBRType == DBRType.STS_BYTE) {
            DBR_STS_Byte dbr = (DBR_STS_Byte)fromDBR;
            status = dbr.getStatus();
            severity = dbr.getSeverity();
            if (elementCount == 1) {
                convert.fromByte(this.pvScalarValue, dbr.getByteValue()[0]);
            } else {
                convert.fromByteArray(this.pvArrayValue, 0, dbr.getCount(), dbr.getByteValue(), 0);
            }
        } else if (requestDBRType == DBRType.TIME_BYTE) {
            DBR_TIME_Byte dbr = (DBR_TIME_Byte)fromDBR;
            status = dbr.getStatus();
            timeStamp = dbr.getTimeStamp();
            severity = dbr.getSeverity();
            if (elementCount == 1) {
                convert.fromByte(this.pvScalarValue, dbr.getByteValue()[0]);
            } else {
                convert.fromByteArray(this.pvArrayValue, 0, dbr.getCount(), dbr.getByteValue(), 0);
            }
        } else if (requestDBRType == DBRType.FLOAT) {
            DBR_Float dbr = (DBR_Float)fromDBR;
            if (elementCount == 1) {
                convert.fromFloat(this.pvScalarValue, dbr.getFloatValue()[0]);
            } else {
                convert.fromFloatArray(this.pvArrayValue, 0, dbr.getCount(), dbr.getFloatValue(), 0);
            }
        } else if (requestDBRType == DBRType.STS_FLOAT) {
            DBR_STS_Float dbr = (DBR_STS_Float)fromDBR;
            status = dbr.getStatus();
            severity = dbr.getSeverity();
            if (elementCount == 1) {
                convert.fromFloat(this.pvScalarValue, dbr.getFloatValue()[0]);
            } else {
                convert.fromFloatArray(this.pvArrayValue, 0, dbr.getCount(), dbr.getFloatValue(), 0);
            }
        } else if (requestDBRType == DBRType.TIME_FLOAT) {
            DBR_TIME_Float dbr = (DBR_TIME_Float)fromDBR;
            status = dbr.getStatus();
            timeStamp = dbr.getTimeStamp();
            severity = dbr.getSeverity();
            if (elementCount == 1) {
                convert.fromFloat(this.pvScalarValue, dbr.getFloatValue()[0]);
            } else {
                convert.fromFloatArray(this.pvArrayValue, 0, dbr.getCount(), dbr.getFloatValue(), 0);
            }
        } else if (requestDBRType == DBRType.STRING) {
            DBR_String dbr = (DBR_String)fromDBR;
            if (elementCount == 1) {
                convert.fromString(this.pvScalarValue, dbr.getStringValue()[0]);
            } else {
                convert.fromStringArray(this.pvArrayValue, 0, dbr.getCount(), dbr.getStringValue(), 0);
            }
        } else if (requestDBRType == DBRType.STS_STRING) {
            DBR_STS_String dbr = (DBR_STS_String)fromDBR;
            status = dbr.getStatus();
            severity = dbr.getSeverity();
            if (elementCount == 1) {
                convert.fromString(this.pvScalarValue, dbr.getStringValue()[0]);
            } else {
                convert.fromStringArray(this.pvArrayValue, 0, dbr.getCount(), dbr.getStringValue(), 0);
            }
        } else if (requestDBRType == DBRType.TIME_STRING) {
            DBR_TIME_String dbr = (DBR_TIME_String)fromDBR;
            status = dbr.getStatus();
            timeStamp = dbr.getTimeStamp();
            severity = dbr.getSeverity();
            if (elementCount == 1) {
                convert.fromString(this.pvScalarValue, dbr.getStringValue()[0]);
            } else {
                convert.fromStringArray(this.pvArrayValue, 0, dbr.getCount(), dbr.getStringValue(), 0);
            }
        } else if (requestDBRType == DBRType.GR_BYTE) {
            DBR_GR_Byte dbr = (DBR_GR_Byte)fromDBR;
            status = dbr.getStatus();
            timeStamp = dbr.getTimeStamp();
            severity = dbr.getSeverity();
            units = dbr.getUnits();
            displayLow = dbr.getLowerDispLimit().doubleValue();
            displayHigh = dbr.getUpperDispLimit().doubleValue();
            if (elementCount == 1) {
                convert.fromByte(this.pvScalarValue, dbr.getByteValue()[0]);
            } else {
                convert.fromByteArray(this.pvArrayValue, 0, dbr.getCount(), dbr.getByteValue(), 0);
            }
            this.requestDBRType = this.pvTimeStamp != null ? DBRType.TIME_BYTE : (this.pvAlarmSeverity != null ? DBRType.STS_BYTE : DBRType.BYTE);
        } else if (requestDBRType == DBRType.CTRL_BYTE) {
            DBR_CTRL_Byte dbr = (DBR_CTRL_Byte)fromDBR;
            status = dbr.getStatus();
            timeStamp = dbr.getTimeStamp();
            severity = dbr.getSeverity();
            units = dbr.getUnits();
            displayLow = dbr.getLowerDispLimit().doubleValue();
            displayHigh = dbr.getUpperDispLimit().doubleValue();
            controlLow = dbr.getLowerCtrlLimit().doubleValue();
            controlHigh = dbr.getUpperCtrlLimit().doubleValue();
            lowAlarmLimit = dbr.getLowerAlarmLimit().doubleValue();
            lowWarningLimit = dbr.getLowerWarningLimit().doubleValue();
            highWarningLimit = dbr.getUpperWarningLimit().doubleValue();
            highAlarmLimit = dbr.getUpperAlarmLimit().doubleValue();
            if (elementCount == 1) {
                convert.fromByte(this.pvScalarValue, dbr.getByteValue()[0]);
            } else {
                convert.fromByteArray(this.pvArrayValue, 0, dbr.getCount(), dbr.getByteValue(), 0);
            }
            this.requestDBRType = this.pvTimeStamp != null ? DBRType.TIME_BYTE : (this.pvAlarmSeverity != null ? DBRType.STS_BYTE : DBRType.BYTE);
        } else if (requestDBRType == DBRType.GR_SHORT) {
            DBR_GR_Short dbr = (DBR_GR_Short)fromDBR;
            status = dbr.getStatus();
            timeStamp = dbr.getTimeStamp();
            severity = dbr.getSeverity();
            units = dbr.getUnits();
            displayLow = dbr.getLowerDispLimit().doubleValue();
            displayHigh = dbr.getUpperDispLimit().doubleValue();
            if (elementCount == 1) {
                convert.fromShort(this.pvScalarValue, dbr.getShortValue()[0]);
            } else {
                convert.fromShortArray(this.pvArrayValue, 0, dbr.getCount(), dbr.getShortValue(), 0);
            }
            this.requestDBRType = this.pvTimeStamp != null ? DBRType.TIME_SHORT : (this.pvAlarmSeverity != null ? DBRType.STS_SHORT : DBRType.SHORT);
        } else if (requestDBRType == DBRType.CTRL_SHORT) {
            DBR_CTRL_Short dbr = (DBR_CTRL_Short)fromDBR;
            status = dbr.getStatus();
            timeStamp = dbr.getTimeStamp();
            severity = dbr.getSeverity();
            units = dbr.getUnits();
            displayLow = dbr.getLowerDispLimit().doubleValue();
            displayHigh = dbr.getUpperDispLimit().doubleValue();
            controlLow = dbr.getLowerCtrlLimit().doubleValue();
            controlHigh = dbr.getUpperCtrlLimit().doubleValue();
            lowAlarmLimit = dbr.getLowerAlarmLimit().doubleValue();
            lowWarningLimit = dbr.getLowerWarningLimit().doubleValue();
            highWarningLimit = dbr.getUpperWarningLimit().doubleValue();
            highAlarmLimit = dbr.getUpperAlarmLimit().doubleValue();
            if (elementCount == 1) {
                convert.fromShort(this.pvScalarValue, dbr.getShortValue()[0]);
            } else {
                convert.fromShortArray(this.pvArrayValue, 0, dbr.getCount(), dbr.getShortValue(), 0);
            }
            this.requestDBRType = this.pvTimeStamp != null ? DBRType.TIME_SHORT : (this.pvAlarmSeverity != null ? DBRType.STS_SHORT : DBRType.SHORT);
        } else if (requestDBRType == DBRType.GR_INT) {
            DBR_GR_Int dbr = (DBR_GR_Int)fromDBR;
            status = dbr.getStatus();
            timeStamp = dbr.getTimeStamp();
            severity = dbr.getSeverity();
            units = dbr.getUnits();
            displayLow = dbr.getLowerDispLimit().doubleValue();
            displayHigh = dbr.getUpperDispLimit().doubleValue();
            if (elementCount == 1) {
                convert.fromInt(this.pvScalarValue, dbr.getIntValue()[0]);
            } else {
                convert.fromIntArray(this.pvArrayValue, 0, dbr.getCount(), dbr.getIntValue(), 0);
            }
            this.requestDBRType = this.pvTimeStamp != null ? DBRType.TIME_INT : (this.pvAlarmSeverity != null ? DBRType.STS_INT : DBRType.INT);
        } else if (requestDBRType == DBRType.CTRL_INT) {
            DBR_CTRL_Int dbr = (DBR_CTRL_Int)fromDBR;
            status = dbr.getStatus();
            timeStamp = dbr.getTimeStamp();
            severity = dbr.getSeverity();
            units = dbr.getUnits();
            displayLow = dbr.getLowerDispLimit().doubleValue();
            displayHigh = dbr.getUpperDispLimit().doubleValue();
            controlLow = dbr.getLowerCtrlLimit().doubleValue();
            controlHigh = dbr.getUpperCtrlLimit().doubleValue();
            lowAlarmLimit = dbr.getLowerAlarmLimit().doubleValue();
            lowWarningLimit = dbr.getLowerWarningLimit().doubleValue();
            highWarningLimit = dbr.getUpperWarningLimit().doubleValue();
            highAlarmLimit = dbr.getUpperAlarmLimit().doubleValue();
            if (elementCount == 1) {
                convert.fromInt(this.pvScalarValue, dbr.getIntValue()[0]);
            } else {
                convert.fromIntArray(this.pvArrayValue, 0, dbr.getCount(), dbr.getIntValue(), 0);
            }
            this.requestDBRType = this.pvTimeStamp != null ? DBRType.TIME_INT : (this.pvAlarmSeverity != null ? DBRType.STS_INT : DBRType.INT);
        } else if (requestDBRType == DBRType.GR_FLOAT) {
            DBR_GR_Float dbr = (DBR_GR_Float)fromDBR;
            status = dbr.getStatus();
            timeStamp = dbr.getTimeStamp();
            severity = dbr.getSeverity();
            units = dbr.getUnits();
            displayLow = dbr.getLowerDispLimit().doubleValue();
            displayHigh = dbr.getUpperDispLimit().doubleValue();
            if (elementCount == 1) {
                convert.fromFloat(this.pvScalarValue, dbr.getFloatValue()[0]);
            } else {
                convert.fromFloatArray(this.pvArrayValue, 0, dbr.getCount(), dbr.getFloatValue(), 0);
            }
            this.requestDBRType = this.pvTimeStamp != null ? DBRType.TIME_FLOAT : (this.pvAlarmSeverity != null ? DBRType.STS_FLOAT : DBRType.FLOAT);
        } else if (requestDBRType == DBRType.CTRL_FLOAT) {
            DBR_CTRL_Float dbr = (DBR_CTRL_Float)fromDBR;
            status = dbr.getStatus();
            timeStamp = dbr.getTimeStamp();
            severity = dbr.getSeverity();
            units = dbr.getUnits();
            displayLow = dbr.getLowerDispLimit().doubleValue();
            displayHigh = dbr.getUpperDispLimit().doubleValue();
            controlLow = dbr.getLowerCtrlLimit().doubleValue();
            controlHigh = dbr.getUpperCtrlLimit().doubleValue();
            lowAlarmLimit = dbr.getLowerAlarmLimit().doubleValue();
            lowWarningLimit = dbr.getLowerWarningLimit().doubleValue();
            highWarningLimit = dbr.getUpperWarningLimit().doubleValue();
            highAlarmLimit = dbr.getUpperAlarmLimit().doubleValue();
            if (elementCount == 1) {
                convert.fromFloat(this.pvScalarValue, dbr.getFloatValue()[0]);
            } else {
                convert.fromFloatArray(this.pvArrayValue, 0, dbr.getCount(), dbr.getFloatValue(), 0);
            }
            this.requestDBRType = this.pvTimeStamp != null ? DBRType.TIME_FLOAT : (this.pvAlarmSeverity != null ? DBRType.STS_FLOAT : DBRType.FLOAT);
        } else if (requestDBRType == DBRType.GR_DOUBLE) {
            DBR_GR_Double dbr = (DBR_GR_Double)fromDBR;
            status = dbr.getStatus();
            timeStamp = dbr.getTimeStamp();
            severity = dbr.getSeverity();
            units = dbr.getUnits();
            displayLow = dbr.getLowerDispLimit().doubleValue();
            displayHigh = dbr.getUpperDispLimit().doubleValue();
            if (elementCount == 1) {
                convert.fromDouble(this.pvScalarValue, dbr.getDoubleValue()[0]);
            } else {
                convert.fromDoubleArray(this.pvArrayValue, 0, dbr.getCount(), dbr.getDoubleValue(), 0);
            }
            this.requestDBRType = this.pvTimeStamp != null ? DBRType.TIME_DOUBLE : (this.pvAlarmSeverity != null ? DBRType.STS_DOUBLE : DBRType.DOUBLE);
        } else if (requestDBRType == DBRType.CTRL_DOUBLE) {
            DBR_CTRL_Double dbr = (DBR_CTRL_Double)fromDBR;
            status = dbr.getStatus();
            timeStamp = dbr.getTimeStamp();
            severity = dbr.getSeverity();
            units = dbr.getUnits();
            displayLow = dbr.getLowerDispLimit().doubleValue();
            displayHigh = dbr.getUpperDispLimit().doubleValue();
            controlLow = dbr.getLowerCtrlLimit().doubleValue();
            controlHigh = dbr.getUpperCtrlLimit().doubleValue();
            lowAlarmLimit = dbr.getLowerAlarmLimit().doubleValue();
            lowWarningLimit = dbr.getLowerWarningLimit().doubleValue();
            highWarningLimit = dbr.getUpperWarningLimit().doubleValue();
            highAlarmLimit = dbr.getUpperAlarmLimit().doubleValue();
            if (elementCount == 1) {
                convert.fromDouble(this.pvScalarValue, dbr.getDoubleValue()[0]);
            } else {
                convert.fromDoubleArray(this.pvArrayValue, 0, dbr.getCount(), dbr.getDoubleValue(), 0);
            }
            this.requestDBRType = this.pvTimeStamp != null ? DBRType.TIME_DOUBLE : (this.pvAlarmSeverity != null ? DBRType.STS_DOUBLE : DBRType.DOUBLE);
        } else if (requestDBRType == DBRType.GR_STRING) {
            DBR_GR_String dbr = (DBR_GR_String)fromDBR;
            status = dbr.getStatus();
            timeStamp = dbr.getTimeStamp();
            severity = dbr.getSeverity();
            if (elementCount == 1) {
                convert.fromString(this.pvScalarValue, dbr.getStringValue()[0]);
            } else {
                convert.fromStringArray(this.pvArrayValue, 0, dbr.getCount(), dbr.getStringValue(), 0);
            }
            this.requestDBRType = this.pvTimeStamp != null ? DBRType.TIME_STRING : (this.pvAlarmSeverity != null ? DBRType.STS_STRING : DBRType.STRING);
        } else if (requestDBRType == DBRType.CTRL_STRING) {
            DBR_CTRL_String dbr = (DBR_CTRL_String)fromDBR;
            status = dbr.getStatus();
            timeStamp = dbr.getTimeStamp();
            severity = dbr.getSeverity();
            if (elementCount == 1) {
                convert.fromString(this.pvScalarValue, dbr.getStringValue()[0]);
            } else {
                convert.fromStringArray(this.pvArrayValue, 0, dbr.getCount(), dbr.getStringValue(), 0);
            }
            this.requestDBRType = this.pvTimeStamp != null ? DBRType.TIME_STRING : (this.pvAlarmSeverity != null ? DBRType.STS_STRING : DBRType.STRING);
        } else {
            this.setAlarm(AlarmStatus.UNDEFINED, AlarmSeverity.INVALID, " unsupported DBRType " + requestDBRType.getName());
            return;
        }
        PVStructure pvStructure = null;
        if (timeStamp != null && this.pvTimeStamp != null) {
            long seconds = timeStamp.secPastEpoch();
            this.pvSeconds.put(seconds += 631152000L);
            this.pvNanoseconds.put((int)timeStamp.nsec());
        }
        if (severity != null && this.pvAlarm != null) {
            int index = severity.getValue();
            AlarmSeverity alarmSeverity = AlarmSeverity.getSeverity((int)index);
            String message = status.getName();
            this.setAlarm(statusMap.get(status), alarmSeverity, message);
        }
        if (units != null && (pvStructure = this.pvStructure.getStructureField("display")) != null && (pvUnits = pvStructure.getStringField("units")) != null) {
            pvUnits.put(units.toString());
        }
        if (displayLow < displayHigh && (pvStructure = this.pvStructure.getStructureField("display")) != null) {
            PVDouble pvLow = pvStructure.getDoubleField("limitLow");
            pvHigh = pvStructure.getDoubleField("limitHigh");
            if (pvLow != null && pvHigh != null) {
                pvLow.put(displayLow);
                pvHigh.put(displayHigh);
            }
        }
        if (controlLow < controlHigh && (pvStructure = this.pvStructure.getStructureField("control")) != null) {
            PVDouble pvLow = pvStructure.getDoubleField("limitLow");
            pvHigh = pvStructure.getDoubleField("limitHigh");
            if (pvLow != null && pvHigh != null) {
                pvLow.put(displayLow);
                pvHigh.put(displayHigh);
            }
        }
        if ((lowAlarmLimit < highAlarmLimit || lowWarningLimit < highWarningLimit) && (pvStructure = this.pvStructure.getStructureField("valueAlarm")) != null) {
            PVDouble pvLowWarning = pvStructure.getDoubleField("lowWarningLimit");
            PVDouble pvHighWarning = pvStructure.getDoubleField("highWarningLimit");
            if (pvLowWarning != null && pvHighWarning != null) {
                pvLowWarning.put(lowWarningLimit);
                pvHighWarning.put(highWarningLimit);
            }
            PVDouble pvLowAlarm = pvStructure.getDoubleField("lowAlarmLimit");
            PVDouble pvHighAlarm = pvStructure.getDoubleField("highAlarmLimit");
            if (pvLowAlarm != null && pvHighAlarm != null) {
                pvLowAlarm.put(lowAlarmLimit);
                pvHighAlarm.put(highAlarmLimit);
            }
        }
        if (this.firstGetPVStructure.getAndSet(false)) {
            this.bitSet.clear();
            this.bitSet.set(0);
        } else {
            if (this.pvAlarmMessage != null) {
                this.bitSet.set(this.pvAlarmMessage.getFieldOffset());
            }
            if (this.pvAlarmSeverity != null) {
                this.bitSet.set(this.pvAlarmSeverity.getFieldOffset());
            }
            if (this.pvTimeStamp != null) {
                this.bitSet.set(this.pvTimeStamp.getFieldOffset());
            }
            if (this.pvScalarValue != null) {
                this.bitSet.set(this.pvScalarValue.getFieldOffset());
            }
            if (this.pvArrayValue != null) {
                this.bitSet.set(this.pvArrayValue.getFieldOffset());
            }
            if (this.pvEnumerated != null) {
                this.bitSet.set(this.pvEnumeratedIndex.getFieldOffset());
            }
        }
    }

    static {
        statusMap.put(Status.NO_ALARM, AlarmStatus.NONE);
        statusMap.put(Status.READ_ALARM, AlarmStatus.DRIVER);
        statusMap.put(Status.WRITE_ALARM, AlarmStatus.DRIVER);
        statusMap.put(Status.HIHI_ALARM, AlarmStatus.RECORD);
        statusMap.put(Status.HIGH_ALARM, AlarmStatus.RECORD);
        statusMap.put(Status.LOLO_ALARM, AlarmStatus.RECORD);
        statusMap.put(Status.LOW_ALARM, AlarmStatus.RECORD);
        statusMap.put(Status.STATE_ALARM, AlarmStatus.RECORD);
        statusMap.put(Status.COS_ALARM, AlarmStatus.RECORD);
        statusMap.put(Status.COMM_ALARM, AlarmStatus.DRIVER);
        statusMap.put(Status.TIMEOUT_ALARM, AlarmStatus.DRIVER);
        statusMap.put(Status.HW_LIMIT_ALARM, AlarmStatus.DEVICE);
        statusMap.put(Status.CALC_ALARM, AlarmStatus.RECORD);
        statusMap.put(Status.SCAN_ALARM, AlarmStatus.DB);
        statusMap.put(Status.LINK_ALARM, AlarmStatus.DB);
        statusMap.put(Status.SOFT_ALARM, AlarmStatus.CONF);
        statusMap.put(Status.BAD_SUB_ALARM, AlarmStatus.CONF);
        statusMap.put(Status.UDF_ALARM, AlarmStatus.UNDEFINED);
        statusMap.put(Status.DISABLE_ALARM, AlarmStatus.RECORD);
        statusMap.put(Status.SIMM_ALARM, AlarmStatus.RECORD);
        statusMap.put(Status.READ_ACCESS_ALARM, AlarmStatus.DRIVER);
        statusMap.put(Status.WRITE_ACCESS_ALARM, AlarmStatus.DRIVER);
    }

    private static enum DBRProperty {
        none,
        status,
        time,
        graphic,
        control;

    }
}

