/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess;

import org.epics.pvaccess.client.ChannelProvider;
import org.epics.pvaccess.client.ChannelProviderFactory;
import org.epics.pvaccess.client.ChannelProviderRegistryFactory;
import org.epics.pvaccess.client.impl.remote.ClientContextImpl;

public class ClientFactory {
    public static final String PROVIDER_NAME = "pva";
    private static ChannelProviderFactoryImpl factory = null;
    private static ClientContextImpl context = null;

    public static synchronized void start() {
        if (factory != null) {
            return;
        }
        factory = new ChannelProviderFactoryImpl();
        ChannelProviderRegistryFactory.registerChannelProviderFactory(factory);
    }

    public static synchronized void stop() {
        if (factory != null) {
            ChannelProviderRegistryFactory.unregisterChannelProviderFactory(factory);
            if (factory.destroySharedInstance()) {
                factory = null;
            }
        }
    }

    private static class ChannelProviderFactoryImpl
    implements ChannelProviderFactory {
        private ChannelProviderFactoryImpl() {
        }

        @Override
        public String getFactoryName() {
            return ClientFactory.PROVIDER_NAME;
        }

        @Override
        public synchronized ChannelProvider sharedInstance() {
            try {
                if (context == null) {
                    ClientContextImpl lcontext = new ClientContextImpl();
                    lcontext.initialize();
                    context = lcontext;
                }
                return context.getProvider();
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to initialize shared pvAccess client instance.", e);
            }
        }

        @Override
        public ChannelProvider newInstance() {
            try {
                ClientContextImpl lcontext = new ClientContextImpl();
                lcontext.initialize();
                return lcontext.getProvider();
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to initialize new pvAccess client instance.", e);
            }
        }

        public synchronized boolean destroySharedInstance() {
            boolean destroyed = true;
            if (context != null) {
                context.dispose();
                destroyed = context.isDestroyed();
                context = null;
            }
            return destroyed;
        }
    }
}

