/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess;

import org.epics.pvaccess.PVAException;
import org.epics.pvaccess.client.ChannelProviderRegistryFactory;
import org.epics.pvaccess.server.impl.remote.ServerContextImpl;
import org.epics.pvaccess.server.impl.remote.plugins.DefaultBeaconServerDataProvider;
import org.epics.pvdata.misc.RunnableReady;
import org.epics.pvdata.misc.ThreadCreate;
import org.epics.pvdata.misc.ThreadCreateFactory;
import org.epics.pvdata.misc.ThreadReady;

public class ServerFactory {
    private static final ThreadCreate threadCreate = ThreadCreateFactory.getThreadCreate();

    public static void start() {
        new ThreadInstance();
    }

    private static class ThreadInstance
    implements RunnableReady {
        private ServerContextImpl context = null;

        private ThreadInstance() {
            threadCreate.create("pvAccessServer", 3, (RunnableReady)this);
        }

        private void initialize() throws PVAException {
            this.context = new ServerContextImpl();
            this.context.setBeaconServerStatusProvider(new DefaultBeaconServerDataProvider(this.context));
            this.context.initialize(ChannelProviderRegistryFactory.getChannelProviderRegistry());
            System.out.println(this.context.getVersion().getVersionString());
            this.context.printInfo();
            System.out.println();
        }

        private void destroy() {
            try {
                if (this.context != null) {
                    this.context.destroy();
                }
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }

        public void run(ThreadReady threadReady) {
            Thread runThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        this.initialize();
                        System.out.println("Running server...");
                        context.run(0);
                        System.out.println("Done.");
                    }
                    catch (Throwable th) {
                        th.printStackTrace();
                    }
                    finally {
                        this.destroy();
                    }
                }
            }, "pvAccess-server");
            runThread.setDaemon(false);
            runThread.start();
            threadReady.ready();
        }
    }
}

