/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess;

public class Version {
    private final String productName;
    private final String implementationLanguage;
    private final int majorVersion;
    private final int minorVersion;
    private final int maintenanceVersion;
    private final boolean developmentFlag;

    public Version(String productName, String implementationLangugage, int majorVersion, int minorVersion, int maintenanceVersion, boolean developmentFlag) {
        this.productName = productName;
        this.implementationLanguage = implementationLangugage;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.maintenanceVersion = maintenanceVersion;
        this.developmentFlag = developmentFlag;
    }

    public String getVersionString() {
        String version = this.getProductName() + " v" + this.getMajorVersion() + "." + this.getMinorVersion() + "." + this.getMaintenanceVersion();
        if (this.isDevelopmentVersion()) {
            version = version + "-SNAPSHOT";
        }
        return version;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getImplementationLanguage() {
        return this.implementationLanguage;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getMaintenanceVersion() {
        return this.maintenanceVersion;
    }

    public boolean isDevelopmentVersion() {
        return this.developmentFlag;
    }

    public String toString() {
        return this.getVersionString();
    }
}

