/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client;

import java.util.Map;
import java.util.TreeMap;
import org.epics.pvaccess.client.ChannelProvider;
import org.epics.pvaccess.client.ChannelProviderFactory;
import org.epics.pvaccess.client.ChannelProviderRegistry;

public class ChannelProviderRegistryFactory {
    private static final Map<String, ChannelProviderFactory> channelProviderMap = new TreeMap<String, ChannelProviderFactory>();
    private static final ChannelProviderRegistryImpl channelProviderRegistry = new ChannelProviderRegistryImpl();

    public static ChannelProviderRegistry getChannelProviderRegistry() {
        return channelProviderRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerChannelProviderFactory(ChannelProviderFactory channelProviderFactory) {
        Map<String, ChannelProviderFactory> map = channelProviderMap;
        synchronized (map) {
            channelProviderMap.put(channelProviderFactory.getFactoryName(), channelProviderFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterChannelProviderFactory(ChannelProviderFactory channelProviderFactory) {
        Map<String, ChannelProviderFactory> map = channelProviderMap;
        synchronized (map) {
            ChannelProviderFactory registered = channelProviderMap.get(channelProviderFactory.getFactoryName());
            if (registered == channelProviderFactory) {
                channelProviderMap.remove(channelProviderFactory.getFactoryName());
            }
        }
    }

    private static class ChannelProviderRegistryImpl
    implements ChannelProviderRegistry {
        private ChannelProviderRegistryImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ChannelProvider getProvider(String providerName) {
            Map map = channelProviderMap;
            synchronized (map) {
                ChannelProviderFactory cpf = (ChannelProviderFactory)channelProviderMap.get(providerName);
                if (cpf != null) {
                    return cpf.sharedInstance();
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ChannelProvider createProvider(String providerName) {
            Map map = channelProviderMap;
            synchronized (map) {
                ChannelProviderFactory cpf = (ChannelProviderFactory)channelProviderMap.get(providerName);
                if (cpf != null) {
                    return cpf.newInstance();
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String[] getProviderNames() {
            Map map = channelProviderMap;
            synchronized (map) {
                String[] names = new String[channelProviderMap.size()];
                channelProviderMap.keySet().toArray(names);
                return names;
            }
        }
    }
}

