/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.impl.remote;

import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;
import org.epics.pvaccess.PVFactory;
import org.epics.pvaccess.client.Channel;
import org.epics.pvaccess.client.impl.remote.ChannelImpl;
import org.epics.pvaccess.client.impl.remote.ClientContextImpl;
import org.epics.pvaccess.impl.remote.QoS;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.TransportSendControl;
import org.epics.pvaccess.impl.remote.TransportSender;
import org.epics.pvaccess.impl.remote.request.DataResponse;
import org.epics.pvaccess.impl.remote.request.SubscriptionRequest;
import org.epics.pvdata.misc.BitSet;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.PVDataCreate;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.Requester;
import org.epics.pvdata.pv.Status;
import org.epics.pvdata.pv.StatusCreate;

public abstract class BaseRequestImpl
implements DataResponse,
SubscriptionRequest,
TransportSender {
    protected static final StatusCreate statusCreate = PVFactory.getStatusCreate();
    protected static final Status okStatus = statusCreate.getStatusOK();
    protected static final Status destroyedStatus = statusCreate.createStatus(Status.StatusType.ERROR, "request destroyed", null);
    protected static final Status channelNotConnected = statusCreate.createStatus(Status.StatusType.ERROR, "channel not connected", null);
    protected static final Status channelDestroyed = statusCreate.createStatus(Status.StatusType.ERROR, "channel destroyed", null);
    protected static final Status otherRequestPendingStatus = statusCreate.createStatus(Status.StatusType.ERROR, "other request pending", null);
    protected static final Status invalidPutStructureStatus = statusCreate.createStatus(Status.StatusType.ERROR, "incompatible put structure", null);
    protected static final Status invalidPutArrayStatus = statusCreate.createStatus(Status.StatusType.ERROR, "incompatible put array", null);
    protected static final Status invalidBitSetLengthStatus = statusCreate.createStatus(Status.StatusType.ERROR, "invalid bit-set length", null);
    protected static final PVDataCreate pvDataCreate = PVFactory.getPVDataCreate();
    protected final ChannelImpl channel;
    protected final ClientContextImpl context;
    protected final int ioid;
    protected final Requester requester;
    protected final PVStructure pvRequest;
    protected volatile boolean lastRequest = false;
    protected volatile boolean destroyed = false;
    protected volatile boolean remotelyDestroyed = false;
    protected volatile boolean subscribed = false;
    protected int pendingRequest = -1;
    protected static final int NULL_REQUEST = -1;
    protected static final int PURE_DESTROY_REQUEST = -2;
    protected static final int PURE_CANCEL_REQUEST = -2;
    protected final ReentrantLock lock = new ReentrantLock();

    public BaseRequestImpl(ChannelImpl channel, Requester requester, PVStructure pvRequest, boolean allowNullPVRequest) {
        if (requester == null) {
            throw new IllegalArgumentException("requester == null");
        }
        if (pvRequest == null && !allowNullPVRequest) {
            throw new IllegalArgumentException("pvRequest == null");
        }
        this.channel = channel;
        this.context = channel.getContext();
        this.requester = requester;
        this.pvRequest = pvRequest;
        this.ioid = this.context.registerResponseRequest(this);
    }

    protected void activate() {
        this.channel.registerResponseRequest(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean startRequest(int qos) {
        BaseRequestImpl baseRequestImpl = this;
        synchronized (baseRequestImpl) {
            if (this.pendingRequest != -1 && qos != -2 && qos != -2) {
                return false;
            }
            this.pendingRequest = qos;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopRequest() {
        BaseRequestImpl baseRequestImpl = this;
        synchronized (baseRequestImpl) {
            this.pendingRequest = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getPendingRequest() {
        BaseRequestImpl baseRequestImpl = this;
        synchronized (baseRequestImpl) {
            return this.pendingRequest;
        }
    }

    @Override
    public Requester getRequester() {
        return this.requester;
    }

    @Override
    public int getIOID() {
        return this.ioid;
    }

    abstract void initResponse(Transport var1, byte var2, ByteBuffer var3, byte var4, Status var5);

    abstract void normalResponse(Transport var1, byte var2, ByteBuffer var3, byte var4, Status var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void response(Transport transport, byte version, ByteBuffer payloadBuffer) {
        boolean destroy = false;
        try {
            transport.ensureData(1);
            byte qos = payloadBuffer.get();
            Status status = statusCreate.deserializeStatus(payloadBuffer, (DeserializableControl)transport);
            if (QoS.INIT.isSet(qos)) {
                this.initResponse(transport, version, payloadBuffer, qos, status);
            } else {
                if (QoS.DESTROY.isSet(qos)) {
                    this.remotelyDestroyed = true;
                    destroy = true;
                }
                this.normalResponse(transport, version, payloadBuffer, qos, status);
            }
        }
        finally {
            if (destroy) {
                this.destroy();
            }
        }
    }

    @Override
    public void cancel() {
        if (this.destroyed) {
            return;
        }
        this.startRequest(-2);
        try {
            this.channel.checkAndGetTransport().enqueueSendRequest(this);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy(boolean createRequestFailed) {
        BaseRequestImpl baseRequestImpl = this;
        synchronized (baseRequestImpl) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
        }
        this.context.unregisterResponseRequest(this);
        this.channel.unregisterResponseRequest(this);
        if (!createRequestFailed && !this.remotelyDestroyed) {
            this.startRequest(-2);
            try {
                this.channel.checkAndGetTransport().enqueueSendRequest(this);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void destroy() {
        this.destroy(false);
    }

    @Override
    public void timeout() {
        this.cancel();
    }

    @Override
    public void reportStatus(Status status) {
        if (status == ChannelImpl.channelDestroyed) {
            this.destroy();
        } else if (status == ChannelImpl.channelDisconnected) {
            this.subscribed = false;
            this.stopRequest();
        }
    }

    @Override
    public void lock() {
        this.lock.lock();
    }

    @Override
    public void send(ByteBuffer buffer, TransportSendControl control) {
        int qos = this.getPendingRequest();
        if (qos == -1) {
            return;
        }
        if (qos == -2) {
            control.startMessage((byte)15, 8);
            buffer.putInt(this.channel.getServerChannelID());
            buffer.putInt(this.ioid);
        } else if (qos == -2) {
            control.startMessage((byte)21, 8);
            buffer.putInt(this.channel.getServerChannelID());
            buffer.putInt(this.ioid);
        }
        this.stopRequest();
    }

    @Override
    public void unlock() {
        this.lock.unlock();
    }

    public static final BitSet createBitSetFor(PVStructure pvStructure, BitSet existingBitSet) {
        int pvStructureSize = pvStructure.getNumberFields();
        if (existingBitSet != null && existingBitSet.size() >= pvStructureSize) {
            existingBitSet.clear();
            return existingBitSet;
        }
        return new BitSet(pvStructureSize);
    }

    public static final PVField reuseOrCreatePVField(Field field, PVField existingPVField) {
        if (existingPVField != null && field.equals(existingPVField.getField())) {
            return existingPVField;
        }
        return pvDataCreate.createPVField(field);
    }

    @Override
    public void resubscribeSubscription(Transport transport) {
        if (transport != null && !this.subscribed && this.startRequest(QoS.INIT.getMaskValue())) {
            this.subscribed = true;
            transport.enqueueSendRequest(this);
        }
    }

    @Override
    public void updateSubscription() {
    }

    public void lastRequest() {
        this.lastRequest = true;
    }

    public Channel getChannel() {
        return this.channel;
    }
}

