/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.impl.remote;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import org.epics.pvaccess.client.ChannelProcess;
import org.epics.pvaccess.client.ChannelProcessRequester;
import org.epics.pvaccess.client.impl.remote.BaseRequestImpl;
import org.epics.pvaccess.client.impl.remote.ChannelImpl;
import org.epics.pvaccess.impl.remote.QoS;
import org.epics.pvaccess.impl.remote.SerializationHelper;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.TransportSendControl;
import org.epics.pvdata.pv.MessageType;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.Status;

public class ChannelProcessRequestImpl
extends BaseRequestImpl
implements ChannelProcess {
    protected final ChannelProcessRequester callback;

    public static ChannelProcessRequestImpl create(ChannelImpl channel, ChannelProcessRequester callback, PVStructure pvRequest) {
        ChannelProcessRequestImpl thisInstance = new ChannelProcessRequestImpl(channel, callback, pvRequest);
        thisInstance.activate();
        return thisInstance;
    }

    protected ChannelProcessRequestImpl(ChannelImpl channel, ChannelProcessRequester callback, PVStructure pvRequest) {
        super(channel, callback, pvRequest, true);
        this.callback = callback;
    }

    @Override
    protected void activate() {
        super.activate();
        try {
            this.resubscribeSubscription(this.channel.checkDestroyedAndGetTransport());
        }
        catch (IllegalStateException ise) {
            this.callback.channelProcessConnect(channelDestroyed, this);
            this.destroy(true);
        }
    }

    @Override
    public void send(ByteBuffer buffer, TransportSendControl control) {
        int pendingRequest = this.getPendingRequest();
        if (pendingRequest < 0) {
            super.send(buffer, control);
            return;
        }
        control.startMessage((byte)16, 9);
        buffer.putInt(this.channel.getServerChannelID());
        buffer.putInt(this.ioid);
        buffer.put((byte)pendingRequest);
        if (QoS.INIT.isSet(pendingRequest)) {
            SerializationHelper.serializePVRequest(buffer, control, this.pvRequest);
        }
        this.stopRequest();
    }

    @Override
    void initResponse(Transport transport, byte version, ByteBuffer payloadBuffer, byte qos, Status status) {
        try {
            this.callback.channelProcessConnect(status, this);
        }
        catch (Throwable th) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            th.printStackTrace(printWriter);
            this.requester.message("Unexpected exception caught while calling a callback: " + writer, MessageType.fatalError);
        }
    }

    @Override
    void normalResponse(Transport transport, byte version, ByteBuffer payloadBuffer, byte qos, Status status) {
        try {
            this.callback.processDone(status, this);
        }
        catch (Throwable th) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            th.printStackTrace(printWriter);
            this.requester.message("Unexpected exception caught while calling a callback: " + writer, MessageType.fatalError);
        }
    }

    @Override
    public void process() {
        if (this.destroyed) {
            this.callback.processDone(destroyedStatus, this);
            return;
        }
        if (!this.startRequest(this.lastRequest ? QoS.DESTROY.getMaskValue() : QoS.DEFAULT.getMaskValue())) {
            this.callback.processDone(otherRequestPendingStatus, this);
            return;
        }
        try {
            this.channel.checkAndGetTransport().enqueueSendRequest(this);
        }
        catch (IllegalStateException ise) {
            this.stopRequest();
            this.callback.processDone(channelNotConnected, this);
        }
    }
}

