/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.impl.remote;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import org.epics.pvaccess.client.ChannelPutGet;
import org.epics.pvaccess.client.ChannelPutGetRequester;
import org.epics.pvaccess.client.impl.remote.BaseRequestImpl;
import org.epics.pvaccess.client.impl.remote.ChannelImpl;
import org.epics.pvaccess.impl.remote.QoS;
import org.epics.pvaccess.impl.remote.SerializationHelper;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.TransportSendControl;
import org.epics.pvdata.misc.BitSet;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.MessageType;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Status;

public class ChannelPutGetRequestImpl
extends BaseRequestImpl
implements ChannelPutGet {
    protected final ChannelPutGetRequester callback;
    protected PVStructure putData = null;
    protected BitSet putDataBitSet = null;
    protected PVStructure getData = null;
    protected BitSet getDataBitSet = null;
    protected PVStructure putPutData = null;
    protected BitSet putPutDataBitSet = null;

    public static ChannelPutGetRequestImpl create(ChannelImpl channel, ChannelPutGetRequester callback, PVStructure pvRequest) {
        ChannelPutGetRequestImpl thisInstance = new ChannelPutGetRequestImpl(channel, callback, pvRequest);
        thisInstance.activate();
        return thisInstance;
    }

    protected ChannelPutGetRequestImpl(ChannelImpl channel, ChannelPutGetRequester callback, PVStructure pvRequest) {
        super(channel, callback, pvRequest, false);
        this.callback = callback;
    }

    @Override
    protected void activate() {
        super.activate();
        try {
            this.resubscribeSubscription(this.channel.checkDestroyedAndGetTransport());
        }
        catch (IllegalStateException ise) {
            this.callback.channelPutGetConnect(channelDestroyed, this, null, null);
            this.destroy(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(ByteBuffer buffer, TransportSendControl control) {
        int pendingRequest = this.getPendingRequest();
        if (pendingRequest < 0) {
            super.send(buffer, control);
            return;
        }
        control.startMessage((byte)12, 9);
        buffer.putInt(this.channel.getServerChannelID());
        buffer.putInt(this.ioid);
        if (pendingRequest != QoS.INIT.getMaskValue()) {
            buffer.put((byte)pendingRequest);
        }
        if (QoS.INIT.isSet(pendingRequest)) {
            buffer.put((byte)QoS.INIT.getMaskValue());
            SerializationHelper.serializePVRequest(buffer, control, this.pvRequest);
        } else if (!QoS.GET.isSet(pendingRequest) && !QoS.GET_PUT.isSet(pendingRequest)) {
            this.lock();
            try {
                this.putPutDataBitSet.serialize(buffer, (SerializableControl)control);
                this.putPutData.serialize(buffer, (SerializableControl)control, this.putPutDataBitSet);
            }
            finally {
                this.putPutData = null;
                this.putPutDataBitSet = null;
                this.unlock();
            }
        }
        this.stopRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void initResponse(Transport transport, byte version, ByteBuffer payloadBuffer, byte qos, Status status) {
        try {
            if (!status.isSuccess()) {
                this.callback.channelPutGetConnect(status, this, null, null);
                return;
            }
            this.lock();
            try {
                this.putData = SerializationHelper.deserializeStructureAndCreatePVStructure(payloadBuffer, transport, this.putData);
                this.putDataBitSet = ChannelPutGetRequestImpl.createBitSetFor(this.putData, this.putDataBitSet);
                this.getData = SerializationHelper.deserializeStructureAndCreatePVStructure(payloadBuffer, transport, this.getData);
                this.getDataBitSet = ChannelPutGetRequestImpl.createBitSetFor(this.putData, this.getDataBitSet);
            }
            finally {
                this.unlock();
            }
            this.callback.channelPutGetConnect(status, this, this.putData.getStructure(), this.getData.getStructure());
        }
        catch (Throwable th) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            th.printStackTrace(printWriter);
            this.requester.message("Unexpected exception caught: " + writer, MessageType.fatalError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void normalResponse(Transport transport, byte version, ByteBuffer payloadBuffer, byte qos, Status status) {
        block17: {
            try {
                if (QoS.GET.isSet(qos)) {
                    if (!status.isSuccess()) {
                        this.callback.getGetDone(status, this, null, null);
                        return;
                    }
                    this.lock();
                    try {
                        this.getDataBitSet.deserialize(payloadBuffer, (DeserializableControl)transport);
                        this.getData.deserialize(payloadBuffer, (DeserializableControl)transport, this.getDataBitSet);
                    }
                    finally {
                        this.unlock();
                    }
                    this.callback.getGetDone(status, this, this.getData, this.getDataBitSet);
                    break block17;
                }
                if (QoS.GET_PUT.isSet(qos)) {
                    if (!status.isSuccess()) {
                        this.callback.getPutDone(status, this, null, null);
                        return;
                    }
                    this.lock();
                    try {
                        this.putDataBitSet.deserialize(payloadBuffer, (DeserializableControl)transport);
                        this.putData.deserialize(payloadBuffer, (DeserializableControl)transport, this.putDataBitSet);
                    }
                    finally {
                        this.unlock();
                    }
                    this.callback.getPutDone(status, this, this.putData, this.putDataBitSet);
                    break block17;
                }
                if (!status.isSuccess()) {
                    this.callback.putGetDone(status, this, null, null);
                    return;
                }
                this.lock();
                try {
                    this.getDataBitSet.deserialize(payloadBuffer, (DeserializableControl)transport);
                    this.getData.deserialize(payloadBuffer, (DeserializableControl)transport, this.getDataBitSet);
                }
                finally {
                    this.unlock();
                }
                this.callback.putGetDone(status, this, this.getData, this.getDataBitSet);
            }
            catch (Throwable th) {
                StringWriter writer = new StringWriter();
                PrintWriter printWriter = new PrintWriter(writer);
                th.printStackTrace(printWriter);
                this.requester.message("Unexpected exception caught: " + writer, MessageType.fatalError);
            }
        }
    }

    @Override
    public void putGet(PVStructure pvPutStructure, BitSet bitSet) {
        if (this.destroyed) {
            this.callback.putGetDone(destroyedStatus, this, null, null);
            return;
        }
        if (!this.putData.getStructure().equals(pvPutStructure.getStructure())) {
            this.callback.putGetDone(invalidPutStructureStatus, this, null, null);
            return;
        }
        if (!this.startRequest(this.lastRequest ? QoS.DESTROY.getMaskValue() : QoS.DEFAULT.getMaskValue())) {
            this.callback.putGetDone(otherRequestPendingStatus, this, null, null);
            return;
        }
        try {
            this.lock();
            this.putPutData = pvPutStructure;
            this.putPutDataBitSet = bitSet;
            this.unlock();
            this.channel.checkAndGetTransport().enqueueSendRequest(this);
        }
        catch (IllegalStateException ise) {
            this.stopRequest();
            this.callback.putGetDone(channelNotConnected, this, null, null);
        }
    }

    @Override
    public void getGet() {
        if (this.destroyed) {
            this.callback.getGetDone(destroyedStatus, this, null, null);
            return;
        }
        if (!this.startRequest(this.lastRequest ? QoS.DESTROY.getMaskValue() | QoS.GET.getMaskValue() : QoS.GET.getMaskValue())) {
            this.callback.getGetDone(otherRequestPendingStatus, this, null, null);
            return;
        }
        try {
            this.channel.checkAndGetTransport().enqueueSendRequest(this);
        }
        catch (IllegalStateException ise) {
            this.stopRequest();
            this.callback.getGetDone(channelNotConnected, this, null, null);
        }
    }

    @Override
    public void getPut() {
        if (this.destroyed) {
            this.callback.getPutDone(destroyedStatus, this, null, null);
            return;
        }
        if (!this.startRequest(this.lastRequest ? QoS.DESTROY.getMaskValue() | QoS.GET_PUT.getMaskValue() : QoS.GET_PUT.getMaskValue())) {
            this.callback.getPutDone(otherRequestPendingStatus, this, null, null);
            return;
        }
        try {
            this.channel.checkAndGetTransport().enqueueSendRequest(this);
        }
        catch (IllegalStateException ise) {
            this.stopRequest();
            this.callback.getPutDone(channelNotConnected, this, null, null);
        }
    }
}

