/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.impl.remote;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import org.epics.pvaccess.client.ChannelPut;
import org.epics.pvaccess.client.ChannelPutRequester;
import org.epics.pvaccess.client.impl.remote.BaseRequestImpl;
import org.epics.pvaccess.client.impl.remote.ChannelImpl;
import org.epics.pvaccess.impl.remote.QoS;
import org.epics.pvaccess.impl.remote.SerializationHelper;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.TransportSendControl;
import org.epics.pvdata.misc.BitSet;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.MessageType;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Status;

public class ChannelPutRequestImpl
extends BaseRequestImpl
implements ChannelPut {
    protected final ChannelPutRequester callback;
    protected PVStructure data = null;
    protected BitSet bitSet = null;
    protected PVStructure pvPutStructure = null;
    protected BitSet putBitSet = null;

    public static ChannelPutRequestImpl create(ChannelImpl channel, ChannelPutRequester callback, PVStructure pvRequest) {
        ChannelPutRequestImpl thisInstance = new ChannelPutRequestImpl(channel, callback, pvRequest);
        thisInstance.activate();
        return thisInstance;
    }

    protected ChannelPutRequestImpl(ChannelImpl channel, ChannelPutRequester callback, PVStructure pvRequest) {
        super(channel, callback, pvRequest, false);
        this.callback = callback;
    }

    @Override
    protected void activate() {
        super.activate();
        try {
            this.resubscribeSubscription(this.channel.checkDestroyedAndGetTransport());
        }
        catch (IllegalStateException ise) {
            this.callback.channelPutConnect(channelDestroyed, this, null);
            this.destroy(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(ByteBuffer buffer, TransportSendControl control) {
        int pendingRequest = this.getPendingRequest();
        if (pendingRequest < 0) {
            super.send(buffer, control);
            return;
        }
        control.startMessage((byte)11, 9);
        buffer.putInt(this.channel.getServerChannelID());
        buffer.putInt(this.ioid);
        buffer.put((byte)pendingRequest);
        if (QoS.INIT.isSet(pendingRequest)) {
            SerializationHelper.serializePVRequest(buffer, control, this.pvRequest);
        } else if (!QoS.GET.isSet(pendingRequest)) {
            this.lock();
            try {
                this.putBitSet.serialize(buffer, (SerializableControl)control);
                this.pvPutStructure.serialize(buffer, (SerializableControl)control, this.putBitSet);
            }
            finally {
                this.putBitSet = null;
                this.pvPutStructure = null;
                this.unlock();
            }
        }
        this.stopRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void initResponse(Transport transport, byte version, ByteBuffer payloadBuffer, byte qos, Status status) {
        try {
            if (!status.isSuccess()) {
                this.callback.channelPutConnect(status, this, null);
                return;
            }
            this.lock();
            try {
                this.data = SerializationHelper.deserializeStructureAndCreatePVStructure(payloadBuffer, transport, this.data);
                this.bitSet = ChannelPutRequestImpl.createBitSetFor(this.data, this.bitSet);
            }
            finally {
                this.unlock();
            }
            this.callback.channelPutConnect(status, this, this.data.getStructure());
        }
        catch (Throwable th) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            th.printStackTrace(printWriter);
            this.requester.message("Unexpected exception caught: " + writer, MessageType.fatalError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void normalResponse(Transport transport, byte version, ByteBuffer payloadBuffer, byte qos, Status status) {
        block8: {
            try {
                if (QoS.GET.isSet(qos)) {
                    if (!status.isSuccess()) {
                        this.callback.getDone(status, this, null, null);
                        return;
                    }
                    this.lock();
                    try {
                        this.bitSet.deserialize(payloadBuffer, (DeserializableControl)transport);
                        this.data.deserialize(payloadBuffer, (DeserializableControl)transport, this.bitSet);
                    }
                    finally {
                        this.unlock();
                    }
                    this.callback.getDone(status, this, this.data, this.bitSet);
                    break block8;
                }
                this.callback.putDone(status, this);
            }
            catch (Throwable th) {
                StringWriter writer = new StringWriter();
                PrintWriter printWriter = new PrintWriter(writer);
                th.printStackTrace(printWriter);
                this.requester.message("Unexpected exception caught while calling a callback: " + writer, MessageType.fatalError);
            }
        }
    }

    @Override
    public void get() {
        if (this.destroyed) {
            this.callback.getDone(destroyedStatus, this, null, null);
            return;
        }
        if (!this.startRequest(this.lastRequest ? QoS.DESTROY.getMaskValue() | QoS.GET.getMaskValue() : QoS.GET.getMaskValue())) {
            this.callback.getDone(otherRequestPendingStatus, this, null, null);
            return;
        }
        try {
            this.channel.checkAndGetTransport().enqueueSendRequest(this);
        }
        catch (IllegalStateException ise) {
            this.stopRequest();
            this.callback.getDone(channelNotConnected, this, null, null);
        }
    }

    @Override
    public void put(PVStructure pvPutStructure, BitSet bitSet) {
        if (this.destroyed) {
            this.callback.putDone(destroyedStatus, this);
            return;
        }
        if (!this.data.getStructure().equals(pvPutStructure.getStructure())) {
            this.callback.putDone(invalidPutStructureStatus, this);
            return;
        }
        if (bitSet.size() < this.data.getNumberFields()) {
            this.callback.putDone(invalidBitSetLengthStatus, this);
            return;
        }
        if (!this.startRequest(this.lastRequest ? QoS.DESTROY.getMaskValue() : QoS.DEFAULT.getMaskValue())) {
            this.callback.putDone(otherRequestPendingStatus, this);
            return;
        }
        try {
            this.lock();
            this.pvPutStructure = pvPutStructure;
            this.putBitSet = bitSet;
            this.unlock();
            this.channel.checkAndGetTransport().enqueueSendRequest(this);
        }
        catch (IllegalStateException ise) {
            this.stopRequest();
            this.callback.putDone(channelNotConnected, this);
        }
    }
}

