/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.impl.remote;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import org.epics.pvaccess.client.ChannelRPC;
import org.epics.pvaccess.client.ChannelRPCRequester;
import org.epics.pvaccess.client.impl.remote.BaseRequestImpl;
import org.epics.pvaccess.client.impl.remote.ChannelImpl;
import org.epics.pvaccess.impl.remote.QoS;
import org.epics.pvaccess.impl.remote.SerializationHelper;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.TransportSendControl;
import org.epics.pvdata.pv.MessageType;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.Status;

public class ChannelRPCRequestImpl
extends BaseRequestImpl
implements ChannelRPC {
    protected final ChannelRPCRequester callback;
    protected PVStructure argumentData;

    public static ChannelRPCRequestImpl create(ChannelImpl channel, ChannelRPCRequester callback, PVStructure pvRequest) {
        ChannelRPCRequestImpl thisInstance = new ChannelRPCRequestImpl(channel, callback, pvRequest);
        thisInstance.activate();
        return thisInstance;
    }

    protected ChannelRPCRequestImpl(ChannelImpl channel, ChannelRPCRequester callback, PVStructure pvRequest) {
        super(channel, callback, pvRequest, true);
        this.callback = callback;
    }

    @Override
    protected void activate() {
        super.activate();
        try {
            this.resubscribeSubscription(this.channel.checkDestroyedAndGetTransport());
        }
        catch (IllegalStateException ise) {
            this.callback.channelRPCConnect(channelDestroyed, this);
            this.destroy(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(ByteBuffer buffer, TransportSendControl control) {
        int pendingRequest = this.getPendingRequest();
        if (pendingRequest < 0) {
            super.send(buffer, control);
            return;
        }
        control.startMessage((byte)20, 9);
        buffer.putInt(this.channel.getServerChannelID());
        buffer.putInt(this.ioid);
        if (pendingRequest != QoS.INIT.getMaskValue()) {
            buffer.put((byte)pendingRequest);
        }
        if (QoS.INIT.isSet(pendingRequest)) {
            buffer.put((byte)QoS.INIT.getMaskValue());
            SerializationHelper.serializePVRequest(buffer, control, this.pvRequest);
        } else {
            this.lock();
            try {
                SerializationHelper.serializeStructureFull(buffer, control, this.argumentData);
                this.argumentData = null;
            }
            finally {
                this.unlock();
            }
        }
        this.stopRequest();
    }

    @Override
    void initResponse(Transport transport, byte version, ByteBuffer payloadBuffer, byte qos, Status status) {
        try {
            if (!status.isSuccess()) {
                this.callback.channelRPCConnect(status, this);
                return;
            }
            this.callback.channelRPCConnect(status, this);
        }
        catch (Throwable th) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            th.printStackTrace(printWriter);
            this.requester.message("Unexpected exception caught: " + writer, MessageType.fatalError);
        }
    }

    @Override
    void normalResponse(Transport transport, byte version, ByteBuffer payloadBuffer, byte qos, Status status) {
        try {
            if (!status.isSuccess()) {
                this.callback.requestDone(status, this, null);
                return;
            }
            PVStructure retVal = SerializationHelper.deserializeStructureFull(payloadBuffer, transport);
            this.callback.requestDone(status, this, retVal);
        }
        catch (Throwable th) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            th.printStackTrace(printWriter);
            this.requester.message("Unexpected exception caught: " + writer, MessageType.fatalError);
        }
    }

    @Override
    public void request(PVStructure pvArgument) {
        if (this.destroyed) {
            this.callback.requestDone(destroyedStatus, this, null);
            return;
        }
        if (!this.startRequest(this.lastRequest ? QoS.DESTROY.getMaskValue() : QoS.DEFAULT.getMaskValue())) {
            this.callback.requestDone(otherRequestPendingStatus, this, null);
            return;
        }
        try {
            this.lock();
            this.argumentData = pvArgument;
            this.unlock();
            this.channel.checkAndGetTransport().enqueueSendRequest(this);
        }
        catch (IllegalStateException ise) {
            this.stopRequest();
            this.callback.requestDone(channelNotConnected, this, null);
        }
    }
}

