/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.impl.remote;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.epics.pvaccess.PVAException;
import org.epics.pvaccess.PVFactory;
import org.epics.pvaccess.Version;
import org.epics.pvaccess.client.Channel;
import org.epics.pvaccess.client.ChannelFind;
import org.epics.pvaccess.client.ChannelFindRequester;
import org.epics.pvaccess.client.ChannelListRequester;
import org.epics.pvaccess.client.ChannelProvider;
import org.epics.pvaccess.client.ChannelRequester;
import org.epics.pvaccess.client.impl.remote.BeaconHandler;
import org.epics.pvaccess.client.impl.remote.BeaconHandlerImpl;
import org.epics.pvaccess.client.impl.remote.ChannelImpl;
import org.epics.pvaccess.client.impl.remote.ClientResponseHandler;
import org.epics.pvaccess.client.impl.remote.search.ChannelSearchManager;
import org.epics.pvaccess.client.impl.remote.search.SearchInstance;
import org.epics.pvaccess.client.impl.remote.search.SimpleChannelSearchManagerImpl;
import org.epics.pvaccess.client.impl.remote.tcp.BlockingClientTCPTransport;
import org.epics.pvaccess.client.impl.remote.tcp.BlockingTCPConnector;
import org.epics.pvaccess.impl.remote.ConnectionException;
import org.epics.pvaccess.impl.remote.Context;
import org.epics.pvaccess.impl.remote.ProtocolType;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.TransportClient;
import org.epics.pvaccess.impl.remote.TransportRegistry;
import org.epics.pvaccess.impl.remote.io.impl.PollerImpl;
import org.epics.pvaccess.impl.remote.request.ResponseHandler;
import org.epics.pvaccess.impl.remote.request.ResponseRequest;
import org.epics.pvaccess.impl.remote.udp.BlockingUDPConnector;
import org.epics.pvaccess.impl.remote.udp.BlockingUDPTransport;
import org.epics.pvaccess.impl.remote.utils.GUID;
import org.epics.pvaccess.plugins.SecurityPlugin;
import org.epics.pvaccess.plugins.impl.client.CAClientSecurityPlugin;
import org.epics.pvaccess.util.InetAddressUtil;
import org.epics.pvaccess.util.configuration.Configuration;
import org.epics.pvaccess.util.configuration.ConfigurationProvider;
import org.epics.pvaccess.util.configuration.impl.ConfigurationFactory;
import org.epics.pvaccess.util.logging.ConsoleLogHandler;
import org.epics.pvaccess.util.sync.NamedLockPattern;
import org.epics.pvdata.factory.StatusFactory;
import org.epics.pvdata.misc.ThreadPriority;
import org.epics.pvdata.misc.Timer;
import org.epics.pvdata.misc.TimerFactory;
import org.epics.pvdata.pv.Status;
import org.epics.pvdata.pv.StatusCreate;

public class ClientContextImpl
implements Context {
    public static final String PROVIDER_NAME = "pva";
    public static final Version VERSION;
    private volatile State state = State.NOT_INITIALIZED;
    protected Logger logger;
    protected int debugLevel;
    protected String addressList = "";
    protected boolean autoAddressList = true;
    protected float connectionTimeout = 30.0f;
    protected float beaconPeriod = 15.0f;
    protected int broadcastPort = 5076;
    protected int receiveBufferSize = 16384;
    protected Timer timer = null;
    protected BlockingUDPTransport broadcastTransport = null;
    protected BlockingUDPTransport searchTransport = null;
    protected InetSocketAddress localBroadcastAddress = null;
    protected BlockingTCPConnector connector = null;
    protected TransportRegistry transportRegistry = null;
    private NamedLockPattern namedLocker;
    private static final int LOCK_TIMEOUT = 20000;
    protected final Map<Integer, Channel> channelsByCID = Collections.synchronizedMap(new HashMap());
    private int lastCID = 0;
    protected final Map<Integer, ResponseRequest> pendingResponseRequests = Collections.synchronizedMap(new HashMap());
    private int lastIOID = 0;
    private ChannelSearchManager channelSearchManager;
    protected final Map<String, Map<InetSocketAddress, BeaconHandlerImpl>> beaconHandlers = new HashMap<String, Map<InetSocketAddress, BeaconHandlerImpl>>();
    private final ResponseHandler clientResponseHandler;
    protected ChannelProvider channelProvider = new ChannelProviderImpl();
    final AtomicBoolean pollerInitialized = new AtomicBoolean();
    PollerImpl poller;
    private final Map<String, SecurityPlugin> securityPlugins = new LinkedHashMap<String, SecurityPlugin>();
    private static final StatusCreate statusCreate;
    private static final Status okStatus;
    private static final Status listNotSupported;
    private static final Status findNotSupported;

    public ClientContextImpl() {
        this.loadConfiguration();
        this.initializeLogger();
        this.initializeSecutiryPlugins();
        this.clientResponseHandler = new ClientResponseHandler(this);
    }

    public Version getVersion() {
        return VERSION;
    }

    protected void initializeLogger() {
        this.logger = Logger.getLogger(this.getClass().getName());
        if (this.debugLevel > 0) {
            this.logger.setLevel(Level.ALL);
            boolean found = false;
            block0: for (Logger inspectedLogger = this.logger; inspectedLogger != null; inspectedLogger = inspectedLogger.getParent()) {
                for (Handler handler : inspectedLogger.getHandlers()) {
                    if (!(handler instanceof ConsoleLogHandler)) continue;
                    found = true;
                    continue block0;
                }
            }
            if (!found) {
                this.logger.addHandler(new ConsoleLogHandler());
            }
        }
    }

    public Configuration getConfiguration() {
        ConfigurationProvider configurationProvider = ConfigurationFactory.getProvider();
        Configuration config = configurationProvider.getConfiguration("pvAccess-client");
        if (config == null) {
            config = configurationProvider.getConfiguration("system");
        }
        return config;
    }

    protected void loadConfiguration() {
        Configuration config = this.getConfiguration();
        this.debugLevel = config.getPropertyAsInteger("EPICS_PVA_DEBUG", 0);
        this.addressList = config.getPropertyAsString("EPICS_PVA_ADDR_LIST", this.addressList);
        this.autoAddressList = config.getPropertyAsBoolean("EPICS_PVA_AUTO_ADDR_LIST", this.autoAddressList);
        this.connectionTimeout = config.getPropertyAsFloat("EPICS_PVA_CONN_TMO", this.connectionTimeout);
        this.beaconPeriod = config.getPropertyAsFloat("EPICS_PVA_BEACON_PERIOD", this.beaconPeriod);
        this.broadcastPort = config.getPropertyAsInteger("EPICS_PVA_BROADCAST_PORT", this.broadcastPort);
        this.receiveBufferSize = config.getPropertyAsInteger("EPICS_PVA_MAX_ARRAY_BYTES", this.receiveBufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkState() throws PVAException, IllegalStateException {
        if (this.state == State.DESTROYED) {
            throw new IllegalStateException("Context destroyed.");
        }
        if (this.state == State.NOT_INITIALIZED) {
            ClientContextImpl clientContextImpl = this;
            synchronized (clientContextImpl) {
                if (this.state == State.NOT_INITIALIZED) {
                    this.initialize();
                }
            }
        }
    }

    public synchronized void initialize() throws PVAException {
        if (this.state == State.DESTROYED) {
            throw new IllegalStateException("Context destroyed.");
        }
        if (this.state == State.INITIALIZED) {
            throw new IllegalStateException("Context already initialized.");
        }
        this.internalInitialize();
        this.state = State.INITIALIZED;
    }

    private void internalInitialize() throws PVAException {
        this.timer = TimerFactory.create((String)"pvAccess-client timer", (ThreadPriority)ThreadPriority.lower);
        BlockingTCPConnector.TransportFactory transportFactory = new BlockingTCPConnector.TransportFactory(){

            @Override
            public Transport create(Context context, SocketChannel channel, ResponseHandler responseHandler, int receiveBufferSize, TransportClient client, short transportRevision, float heartbeatInterval, short priority) {
                try {
                    return new BlockingClientTCPTransport(context, channel, responseHandler, receiveBufferSize, client, transportRevision, heartbeatInterval, priority);
                }
                catch (SocketException e) {
                    throw new RuntimeException("Failed to create transport.");
                }
            }
        };
        this.connector = new BlockingTCPConnector(this, transportFactory, this.receiveBufferSize, this.connectionTimeout);
        this.transportRegistry = new TransportRegistry();
        this.namedLocker = new NamedLockPattern();
        this.initializeUDPTransport();
        this.channelSearchManager = new SimpleChannelSearchManagerImpl(this);
    }

    private void initializeUDPTransport() {
        try {
            NetworkInterface localNIF;
            InetSocketAddress[] broadcastAddressList;
            InetSocketAddress listenLocalAddress = new InetSocketAddress(this.broadcastPort);
            InetSocketAddress[] broadcastAddresses = InetAddressUtil.getBroadcastAddresses(this.broadcastPort);
            BlockingUDPConnector broadcastConnector = new BlockingUDPConnector(this, true, broadcastAddresses, true);
            this.broadcastTransport = (BlockingUDPTransport)broadcastConnector.connect(null, new ClientResponseHandler(this), listenLocalAddress, (byte)1, (short)0);
            BlockingUDPConnector searchConnector = new BlockingUDPConnector(this, false, broadcastAddresses, true);
            this.searchTransport = (BlockingUDPTransport)searchConnector.connect(null, new ClientResponseHandler(this), new InetSocketAddress(0), (byte)1, (short)0);
            if (this.addressList != null && this.addressList.length() > 0) {
                InetSocketAddress[] list;
                InetSocketAddress[] appendList = null;
                if (this.autoAddressList) {
                    appendList = this.broadcastTransport.getSendAddresses();
                }
                if ((list = InetAddressUtil.getSocketAddressList(this.addressList, this.broadcastPort, appendList)) != null && list.length > 0) {
                    this.broadcastTransport.setSendAddresses(list);
                    this.searchTransport.setSendAddresses(list);
                }
            }
            if ((broadcastAddressList = this.broadcastTransport.getSendAddresses()) != null) {
                for (int i = 0; i < broadcastAddressList.length; ++i) {
                    this.logger.finer("Broadcast address #" + i + ": " + broadcastAddressList[i] + '.');
                }
            }
            if ((localNIF = InetAddressUtil.getLoopbackNIF()) != null) {
                try {
                    InetAddress group = InetAddress.getByName("224.0.0.128");
                    this.localBroadcastAddress = new InetSocketAddress(group, this.broadcastPort);
                    this.searchTransport.join(group, localNIF);
                    this.searchTransport.setMutlicastNIF(localNIF, true);
                    this.logger.config("Local multicast enabled on " + this.localBroadcastAddress + ":" + this.broadcastPort + " using " + localNIF.getDisplayName() + ".");
                }
                catch (Exception th) {
                    this.logger.log(Level.CONFIG, "Failed to initialize local multicast, funcionality disabled.", th);
                }
            } else {
                this.logger.config("Failed to detect a loopback network interface, local multicast disabled.");
            }
            this.broadcastTransport.start();
            this.searchTransport.start();
        }
        catch (ConnectionException ce) {
            this.logger.log(Level.SEVERE, "Failed to initialize UDP transport.", ce);
        }
    }

    public synchronized void destroy() {
        if (this.state == State.DESTROYED) {
            throw new IllegalStateException("Context already destroyed.");
        }
        this.state = State.DESTROYED;
        this.internalDestroy();
    }

    private void internalDestroy() {
        if (this.channelSearchManager != null) {
            this.channelSearchManager.cancel();
        }
        if (this.timer != null) {
            this.timer.stop();
        }
        this.destroyAllChannels();
        if (this.broadcastTransport != null) {
            try {
                this.broadcastTransport.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.searchTransport != null) {
            try {
                this.searchTransport.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyAllChannels() {
        Map<Integer, Channel> map = this.channelsByCID;
        synchronized (map) {
            for (Channel channel : new ArrayList<Channel>(this.channelsByCID.values())) {
                try {
                    channel.destroy();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.channelsByCID.clear();
        }
    }

    private final void checkChannelName(String name) throws IllegalArgumentException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("null or empty channel name");
        }
        if (name.length() > 500) {
            throw new IllegalArgumentException("name too long");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel createChannelInternal(String name, ChannelRequester requester, short priority, InetSocketAddress[] addresses) throws PVAException {
        this.checkState();
        this.checkChannelName(name);
        if (requester == null) {
            throw new IllegalArgumentException("null requester");
        }
        if (priority < 0 || priority > 99) {
            throw new IllegalArgumentException("priority out of bounds");
        }
        boolean lockAcquired = this.namedLocker.acquireSynchronizationObject(name, 20000L);
        if (lockAcquired) {
            try {
                int cid = this.generateCID();
                ChannelImpl channelImpl = new ChannelImpl(this, cid, name, requester, priority, addresses);
                return channelImpl;
            }
            finally {
                this.namedLocker.releaseSynchronizationObject(name);
            }
        }
        throw new PVAException("Failed to obtain synchronization lock for '" + name + "', possible deadlock.", null);
    }

    public void destroyChannel(ChannelImpl channel, boolean force) throws PVAException, IllegalStateException {
        boolean lockAcquired = this.namedLocker.acquireSynchronizationObject(channel.getChannelName(), 20000L);
        if (lockAcquired) {
            try {
                channel.destroyChannel(force);
            }
            catch (IOException ioex) {
                this.logger.log(Level.SEVERE, "Failed to cleanly destroy channel.", ioex);
                throw new PVAException("Failed to cleanly destroy channel.", ioex);
            }
            finally {
                this.namedLocker.releaseSynchronizationObject(channel.getChannelName());
            }
        } else {
            throw new PVAException("Failed to obtain synchronization lock for '" + channel.getChannelName() + "', possible deadlock.", null);
        }
    }

    void registerChannel(ChannelImpl channel) {
        this.channelsByCID.put(channel.getChannelID(), channel);
    }

    void unregisterChannel(ChannelImpl channel) {
        this.channelsByCID.remove(channel.getChannelID());
    }

    public ChannelImpl getChannel(int channelID) {
        return (ChannelImpl)this.channelsByCID.get(channelID);
    }

    public void printInfo() {
        this.printInfo(System.out);
    }

    public void printInfo(PrintStream out) {
        out.println("CLASS   : " + this.getClass().getName());
        out.println("VERSION : " + this.getVersion());
        out.println("ADDR_LIST : " + this.addressList);
        out.println("AUTO_ADDR_LIST : " + this.autoAddressList);
        out.println("CONNECTION_TIMEOUT : " + this.connectionTimeout);
        out.println("BEACON_PERIOD : " + this.beaconPeriod);
        out.println("BROADCAST_PORT : " + this.broadcastPort);
        out.println("RCV_BUFFER_SIZE : " + this.receiveBufferSize);
        out.print("STATE : ");
        switch (this.state) {
            case NOT_INITIALIZED: {
                out.println("NOT_INITIALIZED");
                break;
            }
            case INITIALIZED: {
                out.println("INITIALIZED");
                break;
            }
            case DESTROYED: {
                out.println("DESTROYED");
                break;
            }
            default: {
                out.println("UNKNOWN");
            }
        }
    }

    public boolean isInitialized() {
        return this.state == State.INITIALIZED;
    }

    public boolean isDestroyed() {
        return this.state == State.DESTROYED;
    }

    public String getAddressList() {
        return this.addressList;
    }

    public boolean isAutoAddressList() {
        return this.autoAddressList;
    }

    public float getBeaconPeriod() {
        return this.beaconPeriod;
    }

    public float getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public int getDebugLevel() {
        return this.debugLevel;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getBroadcastPort() {
        return this.broadcastPort;
    }

    public void dispose() {
        try {
            this.destroy();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public BlockingUDPTransport getBroadcastTransport() {
        return this.broadcastTransport;
    }

    public BlockingUDPTransport getSearchTransport() {
        return this.searchTransport;
    }

    public InetSocketAddress getLocalMulticastAddress() {
        return this.localBroadcastAddress;
    }

    @Override
    public TransportRegistry getTransportRegistry() {
        return this.transportRegistry;
    }

    @Override
    public Timer getTimer() {
        return this.timer;
    }

    @Override
    public Map<String, SecurityPlugin> getSecurityPlugins() {
        return this.securityPlugins;
    }

    private void initializeSecutiryPlugins() {
        String classes = System.getProperty(SecurityPlugin.SECURITY_PLUGINS_CLIENT_KEY);
        if (classes != null) {
            StringTokenizer tokens = new StringTokenizer(classes, ",");
            while (tokens.hasMoreElements()) {
                String className = tokens.nextToken().trim();
                this.logger.log(Level.FINER, "Loading security plug-in '" + className + "'...");
                try {
                    Class<?> c = Class.forName(className);
                    SecurityPlugin p = (SecurityPlugin)c.newInstance();
                    this.securityPlugins.put(p.getId(), p);
                    this.logger.log(Level.FINER, "Security plug-in '" + className + "' [" + p.getId() + "] loaded.");
                }
                catch (Throwable th) {
                    this.logger.log(Level.WARNING, "Failed to load security plug-in '" + className + "'.", th);
                }
            }
        }
        if (!this.securityPlugins.containsKey("ca")) {
            CAClientSecurityPlugin p = new CAClientSecurityPlugin();
            this.securityPlugins.put(p.getId(), p);
        }
        this.logger.log(Level.FINE, "Installed security plug-ins: " + this.securityPlugins.keySet() + ".");
    }

    public ChannelSearchManager getChannelSearchManager() {
        return this.channelSearchManager;
    }

    public void newServerDetected() {
        if (this.channelSearchManager != null) {
            this.channelSearchManager.newServerDetected();
        }
    }

    Transport getTransport(TransportClient client, InetSocketAddress serverAddress, byte minorRevision, short priority) {
        try {
            return this.connector.connect(client, this.clientResponseHandler, serverAddress, minorRevision, priority);
        }
        catch (ConnectionException cex) {
            this.logger.log(Level.SEVERE, "Failed to create transport for: " + serverAddress, cex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int generateCID() {
        Map<Integer, Channel> map = this.channelsByCID;
        synchronized (map) {
            while (this.getChannel(++this.lastCID) != null) {
            }
            this.channelsByCID.put(this.lastCID, null);
            return this.lastCID;
        }
    }

    private void freeCID(int cid) {
        this.channelsByCID.remove(cid);
    }

    public ResponseRequest getResponseRequest(int ioid) {
        return this.pendingResponseRequests.get(ioid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerResponseRequest(ResponseRequest request) {
        Map<Integer, ResponseRequest> map = this.pendingResponseRequests;
        synchronized (map) {
            int ioid = this.generateIOID();
            this.pendingResponseRequests.put(ioid, request);
            return ioid;
        }
    }

    public ResponseRequest unregisterResponseRequest(ResponseRequest request) {
        return this.pendingResponseRequests.remove(request.getIOID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int generateIOID() {
        Map<Integer, ResponseRequest> map = this.pendingResponseRequests;
        synchronized (map) {
            while (this.pendingResponseRequests.get(++this.lastIOID) != null || this.lastIOID == 0) {
            }
            this.pendingResponseRequests.put(this.lastIOID, null);
            return this.lastIOID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeaconHandler getBeaconHandler(String protocol, InetSocketAddress responseFrom) {
        if (!protocol.equals(ProtocolType.tcp.name())) {
            return null;
        }
        Map<String, Map<InetSocketAddress, BeaconHandlerImpl>> map = this.beaconHandlers;
        synchronized (map) {
            BeaconHandlerImpl handler;
            Map<InetSocketAddress, BeaconHandlerImpl> protocolBeaconHandlersMap = this.beaconHandlers.get(protocol);
            if (protocolBeaconHandlersMap == null) {
                protocolBeaconHandlersMap = new HashMap<InetSocketAddress, BeaconHandlerImpl>();
                this.beaconHandlers.put(protocol, protocolBeaconHandlersMap);
            }
            if ((handler = protocolBeaconHandlersMap.get(responseFrom)) == null) {
                handler = new BeaconHandlerImpl(this, protocol, responseFrom);
                protocolBeaconHandlersMap.put(responseFrom, handler);
            }
            return handler;
        }
    }

    public ChannelProvider getProvider() {
        return this.channelProvider;
    }

    static {
        System.setProperty("java.net.preferIPv4Stack", "true");
        VERSION = new Version("pvAccess Client", "Java", 5, 1, 0, true);
        statusCreate = PVFactory.getStatusCreate();
        okStatus = statusCreate.getStatusOK();
        listNotSupported = StatusFactory.getStatusCreate().createStatus(Status.StatusType.ERROR, "channelList not supported", null);
        findNotSupported = StatusFactory.getStatusCreate().createStatus(Status.StatusType.ERROR, "channelFind not supported", null);
    }

    private class ChannelProviderImpl
    implements ChannelProvider {
        private ChannelProviderImpl() {
        }

        @Override
        public ChannelFind channelFind(String channelName, ChannelFindRequester channelFindRequester) {
            ClientContextImpl.this.checkChannelName(channelName);
            if (channelFindRequester == null) {
                throw new IllegalArgumentException("null requester");
            }
            channelFindRequester.channelFindResult(findNotSupported, null, false);
            return null;
        }

        @Override
        public ChannelFind channelList(ChannelListRequester channelListRequester) {
            if (channelListRequester == null) {
                throw new IllegalArgumentException("null requester");
            }
            channelListRequester.channelListResult(listNotSupported, null, null, false);
            return null;
        }

        @Override
        public Channel createChannel(String channelName, ChannelRequester channelRequester, short priority) {
            return this.createChannel(channelName, channelRequester, priority, null);
        }

        @Override
        public Channel createChannel(String channelName, ChannelRequester channelRequester, short priority, String address) {
            Channel channel;
            try {
                int defaultPort = 5075;
                InetSocketAddress[] addressList = address == null ? null : InetAddressUtil.getSocketAddressList(address, defaultPort);
                channel = ClientContextImpl.this.createChannelInternal(channelName, channelRequester, priority, addressList);
            }
            catch (IllegalArgumentException iae) {
                throw iae;
            }
            catch (Throwable th) {
                channelRequester.channelCreated(statusCreate.createStatus(Status.StatusType.ERROR, "failed to create channel", th), null);
                return null;
            }
            channelRequester.channelCreated(okStatus, channel);
            return channel;
        }

        @Override
        public String getProviderName() {
            return ClientContextImpl.PROVIDER_NAME;
        }

        @Override
        public void destroy() {
            ClientContextImpl.this.dispose();
        }

        private class ChannelFindImpl
        implements ChannelFind,
        SearchInstance {
            final String channelName;
            final ChannelFindRequester requester;
            final int channelID;
            final AtomicInteger userValue = new AtomicInteger();

            public ChannelFindImpl(String channelName, ChannelFindRequester requester) {
                this.channelName = channelName;
                this.requester = requester;
                this.channelID = ClientContextImpl.this.generateCID();
                ClientContextImpl.this.getChannelSearchManager().register(this);
            }

            @Override
            public int getChannelID() {
                return this.channelID;
            }

            @Override
            public String getChannelName() {
                return this.channelName;
            }

            @Override
            public void searchResponse(GUID guid, byte minorRevision, InetSocketAddress serverAddress) {
                ClientContextImpl.this.freeCID(this.channelID);
                this.requester.channelFindResult(okStatus, this, true);
            }

            @Override
            public AtomicInteger getUserValue() {
                return this.userValue;
            }

            @Override
            public void cancel() {
                ClientContextImpl.this.freeCID(this.channelID);
                ClientContextImpl.this.getChannelSearchManager().unregister(this);
            }

            @Override
            public ChannelProvider getChannelProvider() {
                return ClientContextImpl.this.getProvider();
            }
        }
    }

    static enum State {
        NOT_INITIALIZED,
        INITIALIZED,
        DESTROYED;

    }
}

