/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.impl.remote;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.epics.pvaccess.client.impl.remote.ClientContextImpl;
import org.epics.pvaccess.client.impl.remote.handlers.BadResponse;
import org.epics.pvaccess.client.impl.remote.handlers.BeaconHandler;
import org.epics.pvaccess.client.impl.remote.handlers.ConnectionValidatedHandler;
import org.epics.pvaccess.client.impl.remote.handlers.ConnectionValidationHandler;
import org.epics.pvaccess.client.impl.remote.handlers.CreateChannelHandler;
import org.epics.pvaccess.client.impl.remote.handlers.DataResponseHandler;
import org.epics.pvaccess.client.impl.remote.handlers.DestroyChannelHandler;
import org.epics.pvaccess.client.impl.remote.handlers.EchoResponse;
import org.epics.pvaccess.client.impl.remote.handlers.MessageHandler;
import org.epics.pvaccess.client.impl.remote.handlers.MultipleDataResponseHandler;
import org.epics.pvaccess.client.impl.remote.handlers.NoopResponse;
import org.epics.pvaccess.client.impl.remote.handlers.SearchHandler;
import org.epics.pvaccess.client.impl.remote.handlers.SearchResponseHandler;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.request.ResponseHandler;
import org.epics.pvaccess.impl.security.AuthNZHandler;
import org.epics.pvaccess.util.HexDump;

public class ClientResponseHandler
implements ResponseHandler {
    private final ResponseHandler[] handlerTable;
    private final ClientContextImpl context;

    public ClientResponseHandler(ClientContextImpl context) {
        this.context = context;
        BadResponse badResponse = new BadResponse(context);
        DataResponseHandler dataResponse = new DataResponseHandler(context);
        this.handlerTable = new ResponseHandler[]{new BeaconHandler(context), new ConnectionValidationHandler(context), new EchoResponse(context), new SearchHandler(context), new SearchResponseHandler(context), new AuthNZHandler(context.getDebugLevel() >= 3), new NoopResponse(context, "Access rights change"), new CreateChannelHandler(context), new DestroyChannelHandler(context), new ConnectionValidatedHandler(context), dataResponse, dataResponse, dataResponse, dataResponse, dataResponse, badResponse, dataResponse, dataResponse, new MessageHandler(context), new MultipleDataResponseHandler(context), dataResponse, badResponse, new NoopResponse(context, "Origin tag"), badResponse, badResponse, badResponse, badResponse, badResponse};
    }

    @Override
    public final void handleResponse(InetSocketAddress responseFrom, Transport transport, byte version, byte command, int payloadSize, ByteBuffer payloadBuffer) {
        if (command < 0 || command >= this.handlerTable.length) {
            this.context.getLogger().fine("Invalid (or unsupported) command: " + command + ".");
            HexDump.hexDump("Invalid PVA header " + command + " + , its payload buffer", payloadBuffer.array(), payloadBuffer.position(), payloadSize);
            return;
        }
        this.handlerTable[command].handleResponse(responseFrom, transport, version, command, payloadSize, payloadBuffer);
    }
}

