/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.pvms;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.epics.pvaccess.PVFactory;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.FieldCreate;

public final class IncomingMulticastIntrospectionRegistry {
    protected final Map<Short, FieldEntry> registry = Collections.synchronizedMap(new HashMap());
    static final FieldCreate fieldCreate = PVFactory.getFieldCreate();

    public IncomingMulticastIntrospectionRegistry() {
        this.reset();
    }

    public void reset() {
        this.registry.clear();
    }

    public FieldEntry getIntrospectionInterface(short id) {
        return this.registry.get(id);
    }

    public void registerIntrospectionInterface(short id, FieldEntry fieldEntry) {
        this.registry.put(id, fieldEntry);
    }

    public final Field deserialize(ByteBuffer buffer, DeserializableControl control) {
        control.ensureData(1);
        int pos = buffer.position();
        byte typeCode = buffer.get();
        if (typeCode == -1) {
            return null;
        }
        if (typeCode == -3) {
            control.ensureData(2);
            short key = buffer.getShort();
            FieldEntry fieldEntry = this.getIntrospectionInterface(key);
            if (fieldEntry != null) {
                int toSkip = fieldEntry.getSerializationSize();
                control.ensureData(toSkip);
                buffer.position(buffer.position() + toSkip);
                return fieldEntry.getField();
            }
            int startPos = buffer.position();
            Field field = fieldCreate.deserialize(buffer, control);
            int serializationSize = buffer.position() - startPos;
            this.registerIntrospectionInterface(key, new FieldEntry(field, serializationSize));
            return field;
        }
        buffer.position(pos);
        return fieldCreate.deserialize(buffer, control);
    }

    static class FieldEntry {
        private final Field field;
        private final int serializationSize;

        public FieldEntry(Field field, int serializationSize) {
            this.field = field;
            this.serializationSize = serializationSize;
        }

        public FieldEntry(Field field) {
            this.field = field;
            this.serializationSize = -1;
        }

        public Field getField() {
            return this.field;
        }

        public int getSerializationSize() {
            return this.serializationSize;
        }
    }
}

