/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.pvms;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Timer;
import java.util.TimerTask;
import org.epics.pvaccess.client.pvms.OutgoingMulticastIntrospectionRegistry;
import org.epics.pvaccess.client.pvms.PVMSCodec;
import org.epics.pvaccess.impl.remote.SerializationHelper;
import org.epics.pvdata.misc.SerializeHelper;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.SerializableControl;

class PVMSPublisher
extends PVMSCodec
implements SerializableControl {
    private final DatagramSocket socket;
    private final DatagramPacket packet;
    private final ByteBuffer buffer = ByteBuffer.allocate(65487);
    private final TimerTask timerTask;
    private boolean destroyed = false;
    private final OutgoingMulticastIntrospectionRegistry outgoingIR = new OutgoingMulticastIntrospectionRegistry();

    public PVMSPublisher(InetAddress sendAddress, int port) throws SocketException {
        this(sendAddress, port, null, 0);
    }

    public PVMSPublisher(InetAddress sendAddress, int port, Timer timer, final int keepAlivePeriod) throws SocketException {
        this.socket = new DatagramSocket();
        this.packet = new DatagramPacket(this.buffer.array(), 0, sendAddress, port);
        if (timer != null && keepAlivePeriod > 0) {
            this.timerTask = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            if (!PVMSPublisher.this.destroyed) {
                                PVMSPublisher.this.sendKeepAliveControlMessage(keepAlivePeriod);
                            }
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
            timer.schedule(this.timerTask, 0L, (long)(keepAlivePeriod * 1000));
        } else {
            this.timerTask = null;
        }
    }

    public void flushSerializeBuffer() {
    }

    public void ensureBuffer(int size) {
    }

    public void alignBuffer(int alignment) {
    }

    public void cachedSerialize(Field field, ByteBuffer buffer) {
        this.outgoingIR.serialize(field, buffer, this);
    }

    protected synchronized void sendShutdownControlMessage() throws IOException {
        this.buffer.clear();
        this.pmsShutdownControlMessage(this.buffer);
        this.packet.setLength(this.buffer.position());
        this.socket.send(this.packet);
    }

    protected synchronized void sendKeepAliveControlMessage(int expirationTimeSec) throws IOException {
        this.buffer.clear();
        this.pmsKeepAliveControlMessage(this.buffer, expirationTimeSec);
        this.packet.setLength(this.buffer.position());
        this.socket.send(this.packet);
    }

    private void pmsDataMessage(ByteBuffer buffer, String topicId, String[] tags, PVField data) {
        int messageSeqNo = this.incrementMessageSeqNum();
        this.udtDataHeader(buffer, messageSeqNo, PVMSCodec.PacketPosition.SOLO);
        SerializeHelper.serializeString((String)topicId, (ByteBuffer)buffer, (SerializableControl)this);
        if (tags.length == 0) {
            SerializeHelper.writeSize((int)0, (ByteBuffer)buffer, (SerializableControl)this);
        } else {
            SerializeHelper.writeSize((int)tags.length, (ByteBuffer)buffer, (SerializableControl)this);
            for (String tag : tags) {
                SerializeHelper.serializeString((String)tag, (ByteBuffer)buffer, (SerializableControl)this);
            }
        }
        if (data == null) {
            SerializationHelper.serializeNullField(buffer, this);
        } else {
            this.cachedSerialize(data.getField(), buffer);
            data.serialize(buffer, (SerializableControl)this);
        }
    }

    protected synchronized void sendData(String topicId, String[] tags, PVField data) throws IOException {
        this.buffer.clear();
        this.pmsDataMessage(this.buffer, topicId, tags, data);
        this.packet.setLength(this.buffer.position());
        this.socket.send(this.packet);
    }

    public void publishData(String topicId, String[] tags, PVField data) throws IOException {
        this.sendData(topicId, tags, data);
    }

    public synchronized void destroy() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        try {
            this.sendShutdownControlMessage();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.socket.close();
    }
}

