/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.rpc;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.epics.pvaccess.ClientFactory;
import org.epics.pvaccess.client.Channel;
import org.epics.pvaccess.client.ChannelProvider;
import org.epics.pvaccess.client.ChannelProviderRegistryFactory;
import org.epics.pvaccess.client.ChannelRPC;
import org.epics.pvaccess.client.ChannelRPCRequester;
import org.epics.pvaccess.client.ChannelRequester;
import org.epics.pvaccess.client.rpc.RPCClient;
import org.epics.pvaccess.client.rpc.RPCClientRequester;
import org.epics.pvaccess.server.rpc.RPCRequestException;
import org.epics.pvdata.copy.CreateRequest;
import org.epics.pvdata.factory.StatusFactory;
import org.epics.pvdata.pv.MessageType;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.Status;

public class RPCClientImpl
implements RPCClient,
ChannelRequester,
ChannelRPCRequester {
    private static final Logger logger = Logger.getLogger(RPCClientImpl.class.getName());
    private static final PVStructure defaultPVRequest = CreateRequest.create().createRequest("");
    private final RPCClientRequester serviceRequester;
    private final Channel channel;
    private final CountDownLatch connectedSignaler = new CountDownLatch(1);
    private final AtomicBoolean requestPending = new AtomicBoolean(false);
    private volatile ChannelRPC channelRPC = null;
    private final PVStructure pvRequest;
    private final Object resultMonitor = new Object();
    private Status status = null;
    private PVStructure result = null;

    public RPCClientImpl(String serviceName) {
        this(serviceName, defaultPVRequest, null);
    }

    public RPCClientImpl(String serviceName, PVStructure pvRequest) {
        this(serviceName, pvRequest, null);
    }

    public RPCClientImpl(String serviceName, RPCClientRequester requester) {
        this(serviceName, defaultPVRequest, requester);
    }

    public RPCClientImpl(String serviceName, PVStructure pvRequest, RPCClientRequester requester) {
        this.serviceRequester = requester;
        this.pvRequest = pvRequest;
        ClientFactory.start();
        ChannelProvider channelProvider = ChannelProviderRegistryFactory.getChannelProviderRegistry().getProvider("pva");
        this.channel = channelProvider.createChannel(serviceName, this, (short)0);
        this.channel.createChannelRPC(this, pvRequest);
    }

    @Override
    public void destroy() {
        this.channel.destroy();
    }

    @Override
    public boolean waitConnect(double timeout) {
        try {
            return this.connectedSignaler.await((long)(timeout * 1000.0), TimeUnit.MILLISECONDS) && this.channelRPC != null;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    private ChannelRPC checkConnectAndPending(double timeout) {
        ChannelRPC rpc;
        while ((rpc = this.channelRPC) == null) {
            if (timeout != 0.0 && this.waitConnect(timeout)) continue;
            throw new IllegalStateException("ChannelRPC never connected.");
        }
        if (this.requestPending.getAndSet(true)) {
            throw new IllegalStateException("one request already pending");
        }
        return rpc;
    }

    @Override
    public PVStructure request(PVStructure pvArgument, double timeout) throws RPCRequestException {
        long startTime = System.currentTimeMillis();
        long timeoutMs = (long)(timeout * 1000.0);
        Object object = this.resultMonitor;
        synchronized (object) {
            this.sendRequestInternal(timeout, pvArgument);
            long timeLeft = Math.max((timeoutMs - (System.currentTimeMillis() - startTime)) / 1000L, 0L);
            if (this.waitResponse(timeLeft)) {
                if (this.status.isSuccess()) {
                    return this.result;
                }
                String stackDump = this.status.getStackDump();
                if (stackDump != null && !stackDump.isEmpty()) {
                    throw new RPCRequestException(this.status.getType(), this.status.getMessage() + ", cause:\n" + stackDump);
                }
                throw new RPCRequestException(this.status.getType(), this.status.getMessage());
            }
            throw new RPCRequestException(Status.StatusType.ERROR, "timeout");
        }
    }

    @Override
    public void sendRequest(PVStructure pvArgument) {
        this.sendRequestInternal(0.0, pvArgument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequestInternal(double connectTimeout, PVStructure pvArgument) {
        ChannelRPC rpc = this.checkConnectAndPending(connectTimeout);
        Object object = this.resultMonitor;
        synchronized (object) {
            this.status = null;
            this.result = null;
        }
        try {
            rpc.request(pvArgument);
        }
        catch (Throwable th) {
            this.requestDone(StatusFactory.getStatusCreate().createStatus(Status.StatusType.ERROR, "failed to send a RPC request", th), rpc, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitResponse(double timeout) {
        Object object = this.resultMonitor;
        synchronized (object) {
            long diff;
            long timeoutMs = (long)(timeout * 1000.0);
            long startTime = System.currentTimeMillis();
            while (this.status == null && (diff = System.currentTimeMillis() - startTime) < timeoutMs) {
                try {
                    this.resultMonitor.wait(timeoutMs - diff);
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
            return this.status != null;
        }
    }

    public String getRequesterName() {
        return this.serviceRequester != null ? this.serviceRequester.getRequesterName() : this.getClass().getName();
    }

    public void message(String message, MessageType messageType) {
        if (this.serviceRequester != null) {
            this.serviceRequester.message(message, messageType);
        } else {
            logger.finer(this.getRequesterName() + ": [" + messageType + "] " + message);
        }
    }

    @Override
    public void channelCreated(Status status, Channel channel) {
        logger.finer("Channel '" + channel.getChannelName() + "' created with status: " + status + ".");
    }

    @Override
    public void channelStateChange(Channel channel, Channel.ConnectionState connectionState) {
        logger.finer("Channel '" + channel.getChannelName() + "' " + (Object)((Object)connectionState) + ".");
        if (connectionState != Channel.ConnectionState.CONNECTED && this.requestPending.get()) {
            this.requestDone(StatusFactory.getStatusCreate().createStatus(Status.StatusType.ERROR, "channel " + (Object)((Object)connectionState), null), this.channelRPC, null);
        }
    }

    @Override
    public void channelRPCConnect(Status status, ChannelRPC channelRPC) {
        logger.finer("ChannelRPC for '" + this.channel.getChannelName() + "' connected with status: " + status + ".");
        this.channelRPC = channelRPC;
        this.connectedSignaler.countDown();
        if (this.serviceRequester != null) {
            try {
                this.serviceRequester.connectResult(this, status);
            }
            catch (Throwable th) {
                logger.log(Level.SEVERE, "Unhandled exception in RPCClientRequester.connectResult().", th);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestDone(Status status, ChannelRPC channelRPC, PVStructure result) {
        logger.finer("requestDone for '" + this.channel.getChannelName() + "' called with status: " + status + ".");
        this.requestPending.set(false);
        Object object = this.resultMonitor;
        synchronized (object) {
            this.status = status;
            this.result = result;
            this.resultMonitor.notifyAll();
        }
        if (this.serviceRequester != null) {
            try {
                this.serviceRequester.requestResult(this, status, result);
            }
            catch (Throwable th) {
                logger.log(Level.SEVERE, "Unhandled exception in RPCClientRequester.requestResult().", th);
            }
        }
    }
}

