/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.impl.remote.codec.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Logger;
import org.epics.pvaccess.impl.remote.codec.impl.BlockingAbstractCodec;

public abstract class BlockingSocketAbstractCodec
extends BlockingAbstractCodec {
    protected final SocketChannel channel;
    protected final InetSocketAddress socketAddress;

    public BlockingSocketAbstractCodec(boolean serverFlag, SocketChannel channel, ByteBuffer receiveBuffer, ByteBuffer sendBuffer, Logger logger) throws SocketException {
        super(serverFlag, receiveBuffer, sendBuffer, channel.socket().getSendBufferSize(), logger);
        this.channel = channel;
        this.socketAddress = (InetSocketAddress)channel.socket().getRemoteSocketAddress();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.channel.read(dst);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.channel.write(src);
    }

    @Override
    protected void internalDestroy() {
        if (this.channel.isOpen()) {
            try {
                this.channel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public InetSocketAddress getLastReadBufferSocketAddress() {
        return this.socketAddress;
    }

    @Override
    public void invalidDataStreamHandler() {
        try {
            this.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

