/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.impl.remote.codec.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.epics.pvaccess.impl.remote.codec.AbstractCodec;
import org.epics.pvaccess.impl.remote.io.PollEvents;
import org.epics.pvaccess.impl.remote.io.Poller;

public abstract class NonBlockingAbstractCodec
extends AbstractCodec
implements PollEvents {
    private final AtomicBoolean isOpen = new AtomicBoolean(true);
    protected final Poller poller;
    protected volatile SelectionKey key;

    public NonBlockingAbstractCodec(boolean serverFlag, Poller poller, ByteBuffer receiveBuffer, ByteBuffer sendBuffer, int socketSendBufferSize, Logger logger) {
        super(serverFlag, receiveBuffer, sendBuffer, socketSendBufferSize, false, logger);
        this.poller = poller;
    }

    protected abstract void ready();

    @Override
    public void registeredNotify(SelectionKey key, Throwable registrationException) {
        this.setSenderThread();
        this.key = key;
        this.ready();
    }

    @Override
    public void pollNotify(SelectionKey key) throws IOException {
        if (key.isReadable()) {
            this.processRead();
        }
        if (key.isWritable()) {
            this.processWrite();
        }
    }

    @Override
    public void readPollOne() throws IOException {
        this.poller.pollOne();
    }

    @Override
    public void writePollOne() throws IOException {
        this.poller.pollOne();
    }

    @Override
    protected void sendBufferFull(int tries) throws IOException {
        this.writeOpReady = false;
        this.writeMode = AbstractCodec.WriteMode.WAIT_FOR_READY_SIGNAL;
        this.writePollOne();
        this.writeMode = AbstractCodec.WriteMode.PROCESS_SEND_QUEUE;
    }

    @Override
    public void scheduleSend() {
        this.key.interestOps(4);
    }

    @Override
    public void sendCompleted() {
        this.key.interestOps(1);
    }

    @Override
    public void close() throws IOException {
        if (this.isOpen.getAndSet(false)) {
            this.internalDestroy();
        }
    }

    abstract void internalDestroy();

    @Override
    public boolean terminated() {
        return !this.isOpen();
    }

    @Override
    public boolean isOpen() {
        return this.isOpen.get();
    }
}

