/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.impl.remote.utils;

import java.io.PrintStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.epics.pvaccess.ClientFactory;
import org.epics.pvaccess.client.Channel;
import org.epics.pvaccess.client.ChannelGet;
import org.epics.pvaccess.client.ChannelGetRequester;
import org.epics.pvaccess.client.ChannelProvider;
import org.epics.pvaccess.client.ChannelProviderRegistryFactory;
import org.epics.pvaccess.client.ChannelRequester;
import org.epics.pvaccess.impl.remote.utils.getopt.Getopt;
import org.epics.pvaccess.util.logging.ConsoleLogHandler;
import org.epics.pvaccess.util.logging.LoggingUtils;
import org.epics.pvdata.copy.CreateRequest;
import org.epics.pvdata.factory.ConvertFactory;
import org.epics.pvdata.misc.BitSet;
import org.epics.pvdata.monitor.Monitor;
import org.epics.pvdata.monitor.MonitorElement;
import org.epics.pvdata.monitor.MonitorRequester;
import org.epics.pvdata.pv.MessageType;
import org.epics.pvdata.pv.PVBoolean;
import org.epics.pvdata.pv.PVByte;
import org.epics.pvdata.pv.PVDouble;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVFloat;
import org.epics.pvdata.pv.PVInt;
import org.epics.pvdata.pv.PVLong;
import org.epics.pvdata.pv.PVScalar;
import org.epics.pvdata.pv.PVScalarArray;
import org.epics.pvdata.pv.PVShort;
import org.epics.pvdata.pv.PVString;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.PVStructureArray;
import org.epics.pvdata.pv.PVUByte;
import org.epics.pvdata.pv.PVUInt;
import org.epics.pvdata.pv.PVULong;
import org.epics.pvdata.pv.PVUShort;
import org.epics.pvdata.pv.PVUnion;
import org.epics.pvdata.pv.PVUnionArray;
import org.epics.pvdata.pv.Status;
import org.epics.pvdata.pv.Structure;
import org.epics.pvdata.pv.StructureArrayData;
import org.epics.pvdata.pv.Type;
import org.epics.pvdata.pv.UnionArrayData;

public class PVGet {
    private static final BigInteger BI_2_64 = BigInteger.ONE.shiftLeft(64);
    private static final float DEFAULT_TIMEOUT = 3.0f;
    private static final String DEFAULT_REQUEST = "field(value)";

    public static String asString(long l) {
        return l >= 0L ? String.valueOf(l) : PVGet.toBigInteger(l).toString();
    }

    public static BigInteger toBigInteger(long l) {
        BigInteger bi = BigInteger.valueOf(l);
        return l >= 0L ? bi : bi.add(BI_2_64);
    }

    private static void terseScalar(PrintStream o, PVScalar scalar) {
        switch (scalar.getScalar().getScalarType()) {
            case pvBoolean: {
                o.print(((PVBoolean)scalar).get());
                break;
            }
            case pvByte: {
                o.print(((PVByte)scalar).get());
                break;
            }
            case pvDouble: {
                o.print(((PVDouble)scalar).get());
                break;
            }
            case pvFloat: {
                o.print(((PVFloat)scalar).get());
                break;
            }
            case pvInt: {
                o.print(((PVInt)scalar).get());
                break;
            }
            case pvLong: {
                o.print(((PVLong)scalar).get());
                break;
            }
            case pvShort: {
                o.print(((PVShort)scalar).get());
                break;
            }
            case pvString: {
                o.print(((PVString)scalar).get());
                break;
            }
            case pvUByte: {
                o.print(((PVUByte)scalar).get() & 0xFF);
                break;
            }
            case pvUInt: {
                o.print((long)((PVUInt)scalar).get() & 0xFFFFFFFFFFFFFFFFL);
                break;
            }
            case pvULong: {
                o.print(PVGet.asString(((PVULong)scalar).get()));
                break;
            }
            case pvUShort: {
                o.print(((PVUShort)scalar).get() & 0xFFFF);
                break;
            }
            default: {
                throw new RuntimeException("unsupported scalar_t");
            }
        }
    }

    private static void terse(PrintStream o, PVField pv, char separator) {
        switch (pv.getField().getType()) {
            case scalar: {
                PVGet.terseScalar(o, (PVScalar)pv);
                break;
            }
            case scalarArray: {
                PVGet.terseScalarArray(o, (PVScalarArray)pv, separator);
                break;
            }
            case structure: {
                PVGet.terseStructure(o, (PVStructure)pv, separator);
                break;
            }
            case structureArray: {
                PVGet.terseStructureArray(o, (PVStructureArray)pv, separator);
                break;
            }
            case union: {
                PVGet.terseUnion(o, (PVUnion)pv, separator);
                break;
            }
            case unionArray: {
                PVGet.terseUnionArray(o, (PVUnionArray)pv, separator);
                break;
            }
            default: {
                throw new RuntimeException("unsupported field type");
            }
        }
    }

    private static void terseStructure(PrintStream o, PVStructure pvStructure, char separator) {
        if (pvStructure == null) {
            o.print("(null)");
            return;
        }
        PVField[] fieldsData = pvStructure.getPVFields();
        boolean first = true;
        for (PVField fieldData : fieldsData) {
            if (first) {
                first = false;
            } else {
                o.print(separator);
            }
            PVGet.terse(o, fieldData, separator);
        }
    }

    private static void terseUnion(PrintStream o, PVUnion pvUnion, char separator) {
        if (pvUnion == null || pvUnion.get() == null) {
            o.print("(null)");
            return;
        }
        PVGet.terse(o, pvUnion.get(), separator);
    }

    private static void terseScalarArray(PrintStream o, PVScalarArray pvArray, char separator) {
        int length = pvArray.getLength();
        if (length <= 0) {
            o.println('0');
            return;
        }
        o.print(length);
        o.print(separator);
        String[] values = new String[length];
        ConvertFactory.getConvert().toStringArray(pvArray, 0, length, values, 0);
        boolean first = true;
        for (String value : values) {
            if (first) {
                first = false;
            } else {
                o.print(separator);
            }
            o.print(value);
        }
    }

    private static void terseStructureArray(PrintStream o, PVStructureArray pvArray, char separator) {
        int length = pvArray.getLength();
        if (length <= 0) {
            o.println('0');
            return;
        }
        o.print(length);
        o.print(separator);
        StructureArrayData sad = new StructureArrayData();
        pvArray.get(0, length, sad);
        boolean first = true;
        for (PVStructure pvStructure : (PVStructure[])sad.data) {
            if (first) {
                first = false;
            } else {
                o.print(separator);
            }
            PVGet.terseStructure(o, pvStructure, separator);
        }
    }

    private static void terseUnionArray(PrintStream o, PVUnionArray pvArray, char separator) {
        int length = pvArray.getLength();
        if (length <= 0) {
            o.println('0');
            return;
        }
        o.print(length);
        o.print(separator);
        UnionArrayData sad = new UnionArrayData();
        pvArray.get(0, length, sad);
        boolean first = true;
        for (PVUnion pvUnion : (PVUnion[])sad.data) {
            if (first) {
                first = false;
            } else {
                o.print(separator);
            }
            PVGet.terseUnion(o, pvUnion, separator);
        }
    }

    public static void usage() {
        System.err.println("\nUsage: java " + PVGet.class.getName() + " [options] <PV name>...\n\n  -h: Help: Print this message\noptions:\n  -r <pv request>:   Request, specifies what fields to return and options, default is '" + DEFAULT_REQUEST + "'\n  -w <sec>:          Wait time, specifies timeout, default is " + 3.0f + " second(s)\n  -t:                Terse mode - print only value, without names\n  -d:                Enable debug output\n  -F <ofs>:          Use <ofs> as an alternate output field separator\n");
    }

    public static void main(String[] args) throws Throwable {
        int opt;
        boolean debug = false;
        boolean monitor = false;
        boolean quiet = false;
        float timeOut = 3.0f;
        String request = DEFAULT_REQUEST;
        PrintMode printMode = PrintMode.ValueOnlyMode;
        char fieldSeparator = ' ';
        Getopt g = new Getopt(PVGet.class.getSimpleName(), args, ":hr:w:tmqdcF:f:");
        g.setOpterr(false);
        block12: while ((opt = g.getopt()) != -1) {
            switch (opt) {
                case 104: {
                    PVGet.usage();
                    System.exit(0);
                }
                case 119: {
                    timeOut = Float.valueOf(g.getOptarg()).floatValue();
                    if (!((double)timeOut <= 0.0)) continue block12;
                    System.err.println(g.getOptarg() + " is not a valid timeout value - ignored. ('PVGet -h' for help.)");
                    timeOut = 3.0f;
                    continue block12;
                }
                case 114: {
                    request = g.getOptarg();
                    if (printMode != PrintMode.ValueOnlyMode) continue block12;
                    printMode = PrintMode.StructureMode;
                    continue block12;
                }
                case 116: {
                    printMode = PrintMode.TerseMode;
                    continue block12;
                }
                case 109: {
                    monitor = true;
                    continue block12;
                }
                case 113: {
                    quiet = true;
                    continue block12;
                }
                case 100: {
                    debug = true;
                    continue block12;
                }
                case 70: {
                    fieldSeparator = g.getOptarg().charAt(0);
                    continue block12;
                }
                case 63: {
                    System.err.println("Unrecognized option: '-" + (char)g.getOptopt() + "'. ('PVGet -h' for help.)");
                    System.exit(1);
                }
                case 58: {
                    System.err.println("Option '-" + (char)g.getOptopt() + "' requires an argument. ('PVGet -h' for help.)");
                    System.exit(1);
                }
            }
            PVGet.usage();
            System.exit(1);
        }
        int nPvs = args.length - g.getOptind();
        if (nPvs < 1) {
            System.err.println("No pv name(s) specified. ('PVGet -h' for help.)");
            System.exit(1);
        }
        ArrayList<String> pvs = new ArrayList<String>(nPvs);
        for (int i = g.getOptind(); i < args.length; ++i) {
            pvs.add(args[i]);
        }
        ConsoleLogHandler.defaultConsoleLogging(debug || Integer.getInteger("EPICS_PVA_DEBUG", 0) > 0 ? Level.ALL : Level.INFO);
        Logger logger = Logger.getLogger(PVGet.class.getName());
        ClientFactory.start();
        ChannelProvider channelProvider = ChannelProviderRegistryFactory.getChannelProviderRegistry().getProvider("pva");
        ArrayList<Channel> channels = new ArrayList<Channel>(pvs.size());
        for (String channelName : pvs) {
            ChannelRequesterImpl channelRequester = new ChannelRequesterImpl(logger);
            Channel channel = channelProvider.createChannel(channelName, channelRequester, (short)0);
            channels.add(channel);
        }
        CreateRequest createRequest = CreateRequest.create();
        PVStructure pvRequest = createRequest.createRequest(request);
        if (pvRequest != null) {
            if (monitor) {
                CountDownLatch doneSignal = new CountDownLatch(channels.size());
                for (Channel channel : channels) {
                    MonitorRequesterImpl monitorRequester = new MonitorRequesterImpl(logger, channel, doneSignal, printMode, fieldSeparator);
                    channel.createMonitor(monitorRequester, pvRequest);
                }
                doneSignal.await();
            } else {
                for (Channel channel : channels) {
                    CountDownLatch doneSignal = new CountDownLatch(1);
                    ChannelGetRequesterImpl channelGetRequester = new ChannelGetRequesterImpl(logger, channel, doneSignal, printMode, fieldSeparator);
                    channel.createChannelGet(channelGetRequester, pvRequest);
                    if (doneSignal.await(3000L, TimeUnit.MILLISECONDS)) continue;
                    logger.info("[" + channel.getChannelName() + "] connection timeout");
                }
            }
        } else {
            logger.info("createRequest failed " + createRequest.getMessage());
        }
        ClientFactory.stop();
    }

    private static void printData(Channel channel, PrintMode printMode, char fieldSeparator, PVStructure pvStructure) {
        if (printMode == PrintMode.ValueOnlyMode) {
            PVField value = pvStructure.getSubField("value");
            if (value == null) {
                System.err.println("no 'value' field");
                System.out.println(channel.getChannelName() + "\n" + pvStructure + "\n");
            } else {
                Type valueType = value.getField().getType();
                if (valueType != Type.scalar && valueType != Type.scalarArray) {
                    System.out.println(channel.getChannelName() + "\n" + pvStructure + "\n");
                } else {
                    if (fieldSeparator == ' ' && value.getField().getType() == Type.scalar) {
                        System.out.printf("%-30s", channel.getChannelName());
                    } else {
                        System.out.print(channel.getChannelName());
                    }
                    System.out.print(fieldSeparator);
                    PVGet.terse(System.out, value, fieldSeparator);
                    System.out.println();
                }
            }
        } else if (printMode == PrintMode.TerseMode) {
            PVGet.terse(System.out, (PVField)pvStructure, fieldSeparator);
            System.out.println();
        } else {
            System.out.println(channel.getChannelName() + "\n" + pvStructure + "\n");
        }
    }

    static class MonitorRequesterImpl
    implements MonitorRequester {
        private final Logger logger;
        private final Channel channel;
        private final CountDownLatch doneSignaler;
        private final PrintMode printMode;
        private final char fieldSeparator;

        public MonitorRequesterImpl(Logger logger, Channel channel, CountDownLatch doneSignaler, PrintMode printMode, char fieldSeparator) {
            this.logger = logger;
            this.channel = channel;
            this.doneSignaler = doneSignaler;
            this.printMode = printMode;
            this.fieldSeparator = fieldSeparator;
        }

        public String getRequesterName() {
            return this.getClass().getName();
        }

        public void message(String message, MessageType messageType) {
            this.logger.log(LoggingUtils.toLevel(messageType), message);
        }

        public void monitorConnect(Status status, Monitor monitor, Structure structure) {
            this.logger.fine("Monitor for '" + this.channel.getChannelName() + "' connected with status: " + status + ".");
            if (status.isSuccess()) {
                status = monitor.start();
                if (status.isSuccess()) {
                    return;
                }
                this.logger.fine("Monitor::start() for '" + this.channel.getChannelName() + "' status: " + status + ".");
                this.doneSignaler.countDown();
            } else {
                this.doneSignaler.countDown();
            }
        }

        public void monitorEvent(Monitor monitor) {
            MonitorElement element;
            while ((element = monitor.poll()) != null) {
                PVGet.printData(this.channel, this.printMode, this.fieldSeparator, element.getPVStructure());
                monitor.release(element);
            }
        }

        public void unlisten(Monitor monitor) {
            this.logger.log(Level.FINE, "unlisten");
            this.doneSignaler.countDown();
        }
    }

    static class ChannelGetRequesterImpl
    implements ChannelGetRequester {
        private final Logger logger;
        private final Channel channel;
        private final CountDownLatch doneSignaler;
        private final PrintMode printMode;
        private final char fieldSeparator;

        public ChannelGetRequesterImpl(Logger logger, Channel channel, CountDownLatch doneSignaler, PrintMode printMode, char fieldSeparator) {
            this.logger = logger;
            this.channel = channel;
            this.doneSignaler = doneSignaler;
            this.printMode = printMode;
            this.fieldSeparator = fieldSeparator;
        }

        public String getRequesterName() {
            return this.getClass().getName();
        }

        public void message(String message, MessageType messageType) {
            this.logger.log(LoggingUtils.toLevel(messageType), message);
        }

        @Override
        public void channelGetConnect(Status status, ChannelGet channelGet, Structure structure) {
            this.logger.fine("ChannelGet for '" + this.channel.getChannelName() + "' connected with status: " + status + ".");
            if (status.isSuccess()) {
                channelGet.lastRequest();
                channelGet.get();
            } else {
                this.doneSignaler.countDown();
            }
        }

        @Override
        public void getDone(Status status, ChannelGet channelGet, PVStructure pvStructure, BitSet changedBitSet) {
            this.logger.fine("getDone for '" + this.channel.getChannelName() + "' called with status: " + status + ".");
            if (status.isSuccess()) {
                PVGet.printData(this.channel, this.printMode, this.fieldSeparator, pvStructure);
            }
            this.doneSignaler.countDown();
        }
    }

    static class ChannelRequesterImpl
    implements ChannelRequester {
        private final Logger logger;

        public ChannelRequesterImpl(Logger logger) {
            this.logger = logger;
        }

        public String getRequesterName() {
            return this.getClass().getName();
        }

        public void message(String message, MessageType messageType) {
            this.logger.log(LoggingUtils.toLevel(messageType), message);
        }

        @Override
        public void channelCreated(Status status, Channel channel) {
            this.logger.fine("Channel '" + channel.getChannelName() + "' created with status: " + status + ".");
        }

        @Override
        public void channelStateChange(Channel channel, Channel.ConnectionState connectionState) {
            this.logger.fine("Channel '" + channel.getChannelName() + "' " + (Object)((Object)connectionState) + ".");
        }
    }

    static enum PrintMode {
        ValueOnlyMode,
        StructureMode,
        TerseMode;

    }
}

