/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.impl.remote.utils;

import java.net.InetSocketAddress;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.epics.pvaccess.PVAException;
import org.epics.pvaccess.client.impl.remote.BeaconHandler;
import org.epics.pvaccess.client.impl.remote.ClientContextImpl;
import org.epics.pvaccess.impl.remote.utils.GUID;
import org.epics.pvdata.pv.PVField;

public class ServerStatusMonitor {
    private BeaconMonitorContextImpl context = null;

    private void initialize() throws PVAException {
        this.context = new BeaconMonitorContextImpl();
        this.context.initialize();
        System.out.println(this.context.getVersion().getVersionString());
        this.context.printInfo();
        System.out.println();
    }

    public void destroy() {
        try {
            if (this.context != null) {
                this.context.destroy();
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    public void execute() {
        try {
            this.initialize();
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    public static void main(String[] args) {
        new ServerStatusMonitor().execute();
    }

    static class BeaconHandlerImpl
    implements BeaconHandler {
        private static SimpleDateFormat timeFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        private final String protocol;

        public BeaconHandlerImpl(String protocol) {
            this.protocol = protocol;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void beaconNotify(InetSocketAddress from, byte remoteTransportRevision, long timestamp, byte[] guid, int sequentalID, int changeCount, PVField data) {
            SimpleDateFormat simpleDateFormat = timeFormatter;
            synchronized (simpleDateFormat) {
                System.out.printf("[%s] %s@%s: seqID %d, version %d, guid %s, change %d\n", timeFormatter.format(new Date(timestamp)), this.protocol, from, sequentalID, remoteTransportRevision, GUID.toString(guid), changeCount);
                if (data != null) {
                    System.out.println(data);
                }
            }
        }
    }

    private static class BeaconMonitorContextImpl
    extends ClientContextImpl {
        private final Map<String, BeaconHandler> beaconHandlerMap = Collections.synchronizedMap(new HashMap());

        @Override
        public BeaconHandler getBeaconHandler(String protocol, InetSocketAddress responseFrom) {
            BeaconHandler bh = this.beaconHandlerMap.get(protocol);
            if (bh == null) {
                bh = new BeaconHandlerImpl(protocol);
                this.beaconHandlerMap.put(protocol, bh);
            }
            return bh;
        }
    }
}

