/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.server.impl.remote;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.epics.pvaccess.impl.remote.SerializationHelper;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.TransportSendControl;
import org.epics.pvaccess.impl.remote.TransportSender;
import org.epics.pvaccess.server.impl.remote.ServerContextImpl;
import org.epics.pvaccess.server.plugins.BeaconServerStatusProvider;
import org.epics.pvaccess.util.InetAddressUtil;
import org.epics.pvdata.misc.SerializeHelper;
import org.epics.pvdata.misc.Timer;
import org.epics.pvdata.misc.TimerFactory;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.SerializableControl;

public class BeaconEmitter
implements Timer.TimerCallback,
TransportSender {
    protected static final float EPICS_PVA_MIN_BEACON_PERIOD = 1.0f;
    protected static final float EPICS_PVA_MIN_BEACON_COUNT_LIMIT = 3.0f;
    protected final Timer timer;
    protected final Logger logger;
    protected final String protocol;
    protected final Transport transport;
    protected byte beaconSequenceID = 0;
    protected final double fastBeaconPeriod;
    protected final double slowBeaconPeriod;
    protected final short beaconCountLimit;
    protected final byte[] guid;
    protected final InetAddress serverAddress;
    protected final int serverPort;
    private final BeaconServerStatusProvider serverStatusProvider;
    private final Timer.TimerNode timerNode;

    public BeaconEmitter(String protocol, Transport transport, ServerContextImpl context) {
        this.protocol = protocol;
        this.transport = transport;
        this.timer = context.getTimer();
        this.logger = context.getLogger();
        this.guid = context.getGUID();
        this.serverAddress = context.getServerInetAddress();
        this.serverPort = context.getServerPort();
        this.serverStatusProvider = context.getBeaconServerStatusProvider();
        this.fastBeaconPeriod = Math.max(context.getBeaconPeriod(), 1.0f);
        this.slowBeaconPeriod = Math.max(180.0, this.fastBeaconPeriod);
        this.beaconCountLimit = (short)Math.max(10.0f, 3.0f);
        this.timerNode = TimerFactory.createNode((Timer.TimerCallback)this);
    }

    protected void start() {
        this.timer.scheduleAfterDelay(this.timerNode, 0.0);
    }

    protected void reschedule() {
        double period;
        double d = period = this.beaconSequenceID >= this.beaconCountLimit ? this.slowBeaconPeriod : this.fastBeaconPeriod;
        if (period > 0.0) {
            this.timer.scheduleAfterDelay(this.timerNode, period);
        }
    }

    public void callback() {
        this.transport.enqueueSendRequest(this);
    }

    @Override
    public void lock() {
    }

    @Override
    public void send(ByteBuffer buffer, TransportSendControl control) {
        PVField serverStatus = null;
        if (this.serverStatusProvider != null) {
            try {
                serverStatus = this.serverStatusProvider.getServerStatusData();
            }
            catch (Throwable th) {
                this.logger.log(Level.WARNING, "BeaconServerStatusProvider implementation thrown an exception.", th);
            }
        }
        control.startMessage((byte)0, 34);
        buffer.put(this.guid);
        buffer.put((byte)0);
        buffer.put(this.beaconSequenceID);
        buffer.putShort((short)0);
        InetAddressUtil.encodeAsIPv6Address(buffer, this.serverAddress);
        buffer.putShort((short)this.serverPort);
        SerializeHelper.serializeString((String)this.protocol, (ByteBuffer)buffer, (SerializableControl)control);
        if (serverStatus != null) {
            serverStatus.getField().serialize(buffer, (SerializableControl)control);
            serverStatus.serialize(buffer, (SerializableControl)control);
        } else {
            SerializationHelper.serializeNullField(buffer, control);
        }
        control.flush(true);
        this.beaconSequenceID = (byte)(this.beaconSequenceID + 1);
        this.reschedule();
    }

    @Override
    public void unlock() {
    }

    public void timerStopped() {
    }

    public void destroy() {
        this.timerNode.cancel();
    }
}

