/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.server.impl.remote;

import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.epics.pvaccess.client.Channel;
import org.epics.pvaccess.impl.remote.server.ServerChannel;
import org.epics.pvaccess.plugins.SecurityPlugin;
import org.epics.pvdata.misc.Destroyable;

public class ServerChannelImpl
implements ServerChannel {
    protected final Channel channel;
    protected final int sid;
    protected final int cid;
    protected final SecurityPlugin.ChannelSecuritySession channelSecuritySession;
    protected final Map<Integer, Destroyable> requests = Collections.synchronizedMap(new HashMap());
    protected boolean destroyed = false;

    public ServerChannelImpl(Channel channel, int cid, int sid, SecurityPlugin.ChannelSecuritySession css) {
        if (channel == null) {
            throw new IllegalArgumentException("non null local channel required");
        }
        this.cid = cid;
        this.sid = sid;
        this.channel = channel;
        this.channelSecuritySession = css;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    public int getCID() {
        return this.cid;
    }

    @Override
    public int getSID() {
        return this.sid;
    }

    public SecurityPlugin.ChannelSecuritySession getChannelSecuritySession() {
        return this.channelSecuritySession;
    }

    public void registerRequest(int id, Destroyable request) {
        if (request == null) {
            throw new IllegalArgumentException("request == null");
        }
        this.requests.put(id, request);
    }

    public void unregisterRequest(int id) {
        this.requests.remove(id);
    }

    public Destroyable getRequest(int id) {
        return this.requests.get(id);
    }

    @Override
    public synchronized Destroyable[] getRequests() {
        Destroyable[] reqs = new Destroyable[this.requests.size()];
        this.requests.values().toArray(reqs);
        return reqs;
    }

    protected void destroyAllRequests() {
        if (this.requests.size() == 0) {
            return;
        }
        Integer[] keys = new Integer[this.requests.keySet().size()];
        this.requests.keySet().toArray(keys);
        for (int i = 0; i < keys.length; ++i) {
            Destroyable cr = this.requests.remove(keys[i]);
            cr.destroy();
        }
    }

    @Override
    public synchronized void destroy() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        this.destroyAllRequests();
        try {
            this.channelSecuritySession.close();
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        this.channel.destroy();
    }

    public void printInfo() throws IllegalStateException {
        this.printInfo(System.out);
    }

    public void printInfo(PrintStream out) {
        out.println("CLASS        : " + this.getClass().getName());
        out.println("CHANNEL      : " + this.channel);
    }
}

