/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.server.impl.remote.handlers;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.epics.pvaccess.client.ChannelArray;
import org.epics.pvaccess.client.ChannelArrayRequester;
import org.epics.pvaccess.client.impl.remote.BaseRequestImpl;
import org.epics.pvaccess.impl.remote.QoS;
import org.epics.pvaccess.impl.remote.SerializationHelper;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.TransportSendControl;
import org.epics.pvaccess.impl.remote.TransportSender;
import org.epics.pvaccess.impl.remote.server.ChannelHostingTransport;
import org.epics.pvaccess.server.impl.remote.ServerChannelImpl;
import org.epics.pvaccess.server.impl.remote.ServerContextImpl;
import org.epics.pvaccess.server.impl.remote.handlers.AbstractServerResponseHandler;
import org.epics.pvaccess.server.impl.remote.handlers.BaseChannelRequester;
import org.epics.pvdata.factory.StatusFactory;
import org.epics.pvdata.misc.SerializeHelper;
import org.epics.pvdata.pv.Array;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.PVArray;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Status;

public class ArrayHandler
extends AbstractServerResponseHandler {
    private static final Status fixedArrayErrorStatus = StatusFactory.getStatusCreate().createStatus(Status.StatusType.ERROR, "fixed sized array returned as a ChannelArray array instance", null);

    public ArrayHandler(ServerContextImpl context) {
        super(context, "Array request");
    }

    @Override
    public void handleResponse(InetSocketAddress responseFrom, Transport transport, byte version, byte command, int payloadSize, ByteBuffer payloadBuffer) {
        super.handleResponse(responseFrom, transport, version, command, payloadSize, payloadBuffer);
        ChannelHostingTransport casTransport = (ChannelHostingTransport)((Object)transport);
        transport.ensureData(9);
        int sid = payloadBuffer.getInt();
        int ioid = payloadBuffer.getInt();
        byte qosCode = payloadBuffer.get();
        ServerChannelImpl channel = (ServerChannelImpl)casTransport.getChannel(sid);
        if (channel == null) {
            BaseChannelRequester.sendFailureMessage((byte)14, transport, ioid, qosCode, BaseChannelRequester.badCIDStatus);
            return;
        }
        boolean init = QoS.INIT.isSet(qosCode);
        if (init) {
            PVStructure pvRequest = SerializationHelper.deserializePVRequest(payloadBuffer, transport);
            Status asStatus = channel.getChannelSecuritySession().authorizeCreateChannelGet(ioid, pvRequest);
            if (!asStatus.isSuccess()) {
                BaseChannelRequester.sendFailureMessage((byte)14, transport, ioid, (byte)QoS.INIT.getMaskValue(), asStatus);
                return;
            }
            new ChannelArrayRequesterImpl(this.context, channel, ioid, transport, pvRequest);
        } else {
            boolean lastRequest = QoS.DESTROY.isSet(qosCode);
            boolean get = QoS.GET.isSet(qosCode);
            boolean setLength = QoS.GET_PUT.isSet(qosCode);
            boolean getLength = QoS.PROCESS.isSet(qosCode);
            ChannelArrayRequesterImpl request = (ChannelArrayRequesterImpl)channel.getRequest(ioid);
            if (request == null) {
                BaseChannelRequester.sendFailureMessage((byte)14, transport, ioid, qosCode, BaseChannelRequester.badIOIDStatus);
                return;
            }
            if (!request.startRequest(qosCode)) {
                BaseChannelRequester.sendFailureMessage((byte)14, transport, ioid, qosCode, BaseChannelRequester.otherRequestPendingStatus);
                return;
            }
            ChannelArray channelArray = request.getChannelArray();
            if (lastRequest) {
                channelArray.lastRequest();
            }
            if (get) {
                int offset = SerializeHelper.readSize((ByteBuffer)payloadBuffer, (DeserializableControl)transport);
                int count = SerializeHelper.readSize((ByteBuffer)payloadBuffer, (DeserializableControl)transport);
                int stride = SerializeHelper.readSize((ByteBuffer)payloadBuffer, (DeserializableControl)transport);
                Status asStatus = channel.getChannelSecuritySession().authorizeGet(ioid);
                if (!asStatus.isSuccess()) {
                    BaseChannelRequester.sendFailureMessage((byte)14, transport, ioid, qosCode, asStatus);
                    if (lastRequest) {
                        request.destroy();
                    }
                    return;
                }
                channelArray.getArray(offset, count, stride);
            } else if (setLength) {
                int length = SerializeHelper.readSize((ByteBuffer)payloadBuffer, (DeserializableControl)transport);
                Status asStatus = channel.getChannelSecuritySession().authorizeSetLength(ioid);
                if (!asStatus.isSuccess()) {
                    BaseChannelRequester.sendFailureMessage((byte)14, transport, ioid, qosCode, asStatus);
                    if (lastRequest) {
                        request.destroy();
                    }
                    return;
                }
                channelArray.setLength(length);
            } else if (getLength) {
                Status asStatus = channel.getChannelSecuritySession().authorizeGet(ioid);
                if (!asStatus.isSuccess()) {
                    BaseChannelRequester.sendFailureMessage((byte)14, transport, ioid, qosCode, asStatus);
                    if (lastRequest) {
                        request.destroy();
                    }
                    return;
                }
                channelArray.getLength();
            } else {
                int offset = SerializeHelper.readSize((ByteBuffer)payloadBuffer, (DeserializableControl)transport);
                int stride = SerializeHelper.readSize((ByteBuffer)payloadBuffer, (DeserializableControl)transport);
                PVArray array = request.getPVArray();
                array.deserialize(payloadBuffer, (DeserializableControl)transport);
                Status asStatus = channel.getChannelSecuritySession().authorizePut(ioid, array);
                if (!asStatus.isSuccess()) {
                    BaseChannelRequester.sendFailureMessage((byte)14, transport, ioid, qosCode, asStatus);
                    if (lastRequest) {
                        request.destroy();
                    }
                    return;
                }
                channelArray.putArray(array, offset, array.getLength(), stride);
            }
        }
    }

    private static class ChannelArrayRequesterImpl
    extends BaseChannelRequester
    implements ChannelArrayRequester,
    TransportSender {
        private volatile ChannelArray channelArray;
        private volatile int length;
        private volatile Status status;
        private volatile PVArray pvPutArray;
        private volatile PVArray pvArray;
        private volatile Array array;

        public ChannelArrayRequesterImpl(ServerContextImpl context, ServerChannelImpl channel, int ioid, Transport transport, PVStructure pvRequest) {
            super(context, channel, ioid, transport);
            this.startRequest(QoS.INIT.getMaskValue());
            channel.registerRequest(ioid, this);
            try {
                this.channelArray = channel.getChannel().createChannelArray(this, pvRequest);
            }
            catch (Throwable th) {
                BaseChannelRequester.sendFailureMessage((byte)14, transport, ioid, (byte)QoS.INIT.getMaskValue(), statusCreate.createStatus(Status.StatusType.FATAL, "Unexpected exception caught: " + th.getMessage(), th));
                this.destroy();
            }
        }

        @Override
        public void channelArrayConnect(Status status, ChannelArray channelArray, Array array) {
            if (status.isSuccess() && array.getArraySizeType() == Array.ArraySizeType.fixed) {
                this.status = fixedArrayErrorStatus;
                this.channelArray = null;
                this.array = null;
            } else {
                this.status = status;
                this.channelArray = channelArray;
                this.array = array;
            }
            if (status.isSuccess()) {
                this.pvPutArray = (PVArray)BaseRequestImpl.reuseOrCreatePVField((Field)array, (PVField)this.pvPutArray);
            }
            this.transport.enqueueSendRequest(this);
            if (!status.isSuccess()) {
                this.destroy();
            }
        }

        @Override
        public void getArrayDone(Status status, ChannelArray channelArray, PVArray pvArray) {
            this.status = status;
            this.pvArray = pvArray;
            this.transport.enqueueSendRequest(this);
        }

        @Override
        public void putArrayDone(Status status, ChannelArray channelArray) {
            this.status = status;
            this.transport.enqueueSendRequest(this);
        }

        @Override
        public void setLengthDone(Status status, ChannelArray channelArray) {
            this.status = status;
            this.transport.enqueueSendRequest(this);
        }

        @Override
        public void getLengthDone(Status status, ChannelArray channelArray, int length) {
            this.status = status;
            this.length = length;
            this.transport.enqueueSendRequest(this);
        }

        public void destroy() {
            this.channel.unregisterRequest(this.ioid);
            this.channel.getChannelSecuritySession().release(this.ioid);
            if (this.channelArray != null) {
                this.channelArray.destroy();
            }
        }

        public ChannelArray getChannelArray() {
            return this.channelArray;
        }

        public PVArray getPVArray() {
            return this.pvPutArray;
        }

        @Override
        public void lock() {
        }

        @Override
        public void unlock() {
        }

        @Override
        public void send(ByteBuffer buffer, TransportSendControl control) {
            int request = this.getPendingRequest();
            control.startMessage((byte)14, 5);
            buffer.putInt(this.ioid);
            buffer.put((byte)request);
            this.status.serialize(buffer, (SerializableControl)control);
            if (this.status.isSuccess()) {
                if (QoS.GET.isSet(request)) {
                    this.pvArray.serialize(buffer, (SerializableControl)control);
                    this.pvArray = null;
                } else if (QoS.PROCESS.isSet(request)) {
                    SerializeHelper.writeSize((int)this.length, (ByteBuffer)buffer, (SerializableControl)control);
                } else if (QoS.INIT.isSet(request)) {
                    control.cachedSerialize((Field)this.array, buffer);
                }
            }
            this.stopRequest();
            if (QoS.DESTROY.isSet(request)) {
                this.destroy();
            }
        }
    }
}

