/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.server.impl.remote.handlers;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.epics.pvaccess.client.GetFieldRequester;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.TransportSendControl;
import org.epics.pvaccess.impl.remote.TransportSender;
import org.epics.pvaccess.impl.remote.server.ChannelHostingTransport;
import org.epics.pvaccess.server.impl.remote.ServerChannelImpl;
import org.epics.pvaccess.server.impl.remote.ServerContextImpl;
import org.epics.pvaccess.server.impl.remote.handlers.AbstractServerResponseHandler;
import org.epics.pvaccess.server.impl.remote.handlers.BaseChannelRequester;
import org.epics.pvdata.misc.SerializeHelper;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Status;

public class GetFieldHandler
extends AbstractServerResponseHandler {
    public GetFieldHandler(ServerContextImpl context) {
        super(context, "Get field request");
    }

    @Override
    public void handleResponse(InetSocketAddress responseFrom, Transport transport, byte version, byte command, int payloadSize, ByteBuffer payloadBuffer) {
        super.handleResponse(responseFrom, transport, version, command, payloadSize, payloadBuffer);
        ChannelHostingTransport casTransport = (ChannelHostingTransport)((Object)transport);
        transport.ensureData(8);
        int sid = payloadBuffer.getInt();
        int ioid = payloadBuffer.getInt();
        ServerChannelImpl channel = (ServerChannelImpl)casTransport.getChannel(sid);
        if (channel == null) {
            this.getFieldFailureResponse(transport, ioid, BaseChannelRequester.badCIDStatus);
            return;
        }
        String subField = SerializeHelper.deserializeString((ByteBuffer)payloadBuffer, (DeserializableControl)transport);
        Status asStatus = channel.getChannelSecuritySession().authorizeGetField(ioid, subField);
        if (!asStatus.isSuccess()) {
            this.getFieldFailureResponse(transport, ioid, asStatus);
            return;
        }
        channel.getChannel().getField(new GetFieldRequesterImpl(this.context, channel, ioid, transport), subField);
    }

    private void getFieldFailureResponse(Transport transport, final int ioid, final Status errorStatus) {
        transport.enqueueSendRequest(new TransportSender(){

            @Override
            public void send(ByteBuffer buffer, TransportSendControl control) {
                control.startMessage((byte)17, 4);
                buffer.putInt(ioid);
                errorStatus.serialize(buffer, (SerializableControl)control);
            }

            @Override
            public void lock() {
            }

            @Override
            public void unlock() {
            }
        });
    }

    private static class GetFieldRequesterImpl
    extends BaseChannelRequester
    implements GetFieldRequester,
    TransportSender {
        private Status status;
        private Field field;

        public GetFieldRequesterImpl(ServerContextImpl context, ServerChannelImpl channel, int ioid, Transport transport) {
            super(context, channel, ioid, transport);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getDone(Status status, Field field) {
            GetFieldRequesterImpl getFieldRequesterImpl = this;
            synchronized (getFieldRequesterImpl) {
                this.status = status;
                this.field = field;
            }
            this.transport.enqueueSendRequest(this);
        }

        public void destroy() {
        }

        @Override
        public void lock() {
        }

        @Override
        public void unlock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(ByteBuffer buffer, TransportSendControl control) {
            control.startMessage((byte)17, 4);
            buffer.putInt(this.ioid);
            GetFieldRequesterImpl getFieldRequesterImpl = this;
            synchronized (getFieldRequesterImpl) {
                this.status.serialize(buffer, (SerializableControl)control);
                if (this.status.isSuccess()) {
                    control.cachedSerialize(this.field, buffer);
                    this.field = null;
                }
            }
        }
    }
}

