/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.server.impl.remote.handlers;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.epics.pvaccess.client.ChannelGet;
import org.epics.pvaccess.client.ChannelGetRequester;
import org.epics.pvaccess.impl.remote.QoS;
import org.epics.pvaccess.impl.remote.SerializationHelper;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.TransportSendControl;
import org.epics.pvaccess.impl.remote.TransportSender;
import org.epics.pvaccess.impl.remote.server.ChannelHostingTransport;
import org.epics.pvaccess.server.impl.remote.ServerChannelImpl;
import org.epics.pvaccess.server.impl.remote.ServerContextImpl;
import org.epics.pvaccess.server.impl.remote.handlers.AbstractServerResponseHandler;
import org.epics.pvaccess.server.impl.remote.handlers.BaseChannelRequester;
import org.epics.pvdata.misc.BitSet;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Status;
import org.epics.pvdata.pv.Structure;

public class GetHandler
extends AbstractServerResponseHandler {
    public GetHandler(ServerContextImpl context) {
        super(context, "Get request");
    }

    @Override
    public void handleResponse(InetSocketAddress responseFrom, Transport transport, byte version, byte command, int payloadSize, ByteBuffer payloadBuffer) {
        super.handleResponse(responseFrom, transport, version, command, payloadSize, payloadBuffer);
        ChannelHostingTransport casTransport = (ChannelHostingTransport)((Object)transport);
        transport.ensureData(9);
        int sid = payloadBuffer.getInt();
        int ioid = payloadBuffer.getInt();
        byte qosCode = payloadBuffer.get();
        ServerChannelImpl channel = (ServerChannelImpl)casTransport.getChannel(sid);
        if (channel == null) {
            BaseChannelRequester.sendFailureMessage((byte)10, transport, ioid, qosCode, BaseChannelRequester.badCIDStatus);
            return;
        }
        boolean init = QoS.INIT.isSet(qosCode);
        if (init) {
            PVStructure pvRequest = SerializationHelper.deserializePVRequest(payloadBuffer, transport);
            Status asStatus = channel.getChannelSecuritySession().authorizeCreateChannelGet(ioid, pvRequest);
            if (!asStatus.isSuccess()) {
                BaseChannelRequester.sendFailureMessage((byte)10, transport, ioid, (byte)QoS.INIT.getMaskValue(), asStatus);
                return;
            }
            new ChannelGetRequesterImpl(this.context, channel, ioid, transport, pvRequest);
        } else {
            boolean lastRequest = QoS.DESTROY.isSet(qosCode);
            ChannelGetRequesterImpl request = (ChannelGetRequesterImpl)channel.getRequest(ioid);
            if (request == null) {
                BaseChannelRequester.sendFailureMessage((byte)10, transport, ioid, qosCode, BaseChannelRequester.badIOIDStatus);
                return;
            }
            if (!request.startRequest(qosCode)) {
                BaseChannelRequester.sendFailureMessage((byte)10, transport, ioid, qosCode, BaseChannelRequester.otherRequestPendingStatus);
                return;
            }
            Status asStatus = channel.getChannelSecuritySession().authorizeGet(ioid);
            if (!asStatus.isSuccess()) {
                BaseChannelRequester.sendFailureMessage((byte)10, transport, ioid, qosCode, asStatus);
                if (lastRequest) {
                    request.destroy();
                }
                return;
            }
            ChannelGet channelGet = request.getChannelGet();
            if (lastRequest) {
                channelGet.lastRequest();
            }
            channelGet.get();
        }
    }

    private static class ChannelGetRequesterImpl
    extends BaseChannelRequester
    implements ChannelGetRequester,
    TransportSender {
        private volatile ChannelGet channelGet;
        private volatile BitSet bitSet;
        private volatile PVStructure pvStructure;
        private volatile Structure structure;
        private volatile Status status;

        public ChannelGetRequesterImpl(ServerContextImpl context, ServerChannelImpl channel, int ioid, Transport transport, PVStructure pvRequest) {
            super(context, channel, ioid, transport);
            this.startRequest(QoS.INIT.getMaskValue());
            channel.registerRequest(ioid, this);
            try {
                this.channelGet = channel.getChannel().createChannelGet(this, pvRequest);
            }
            catch (Throwable th) {
                BaseChannelRequester.sendFailureMessage((byte)10, transport, ioid, (byte)QoS.INIT.getMaskValue(), statusCreate.createStatus(Status.StatusType.FATAL, "Unexpected exception caught: " + th.getMessage(), th));
                this.destroy();
            }
        }

        @Override
        public void channelGetConnect(Status status, ChannelGet channelGet, Structure structure) {
            this.status = status;
            this.channelGet = channelGet;
            this.structure = structure;
            this.transport.enqueueSendRequest(this);
            if (!status.isSuccess()) {
                this.destroy();
            }
        }

        @Override
        public void getDone(Status status, ChannelGet channelGet, PVStructure pvStructure, BitSet bitSet) {
            this.status = status;
            this.pvStructure = pvStructure;
            this.bitSet = bitSet;
            this.transport.enqueueSendRequest(this);
        }

        public void destroy() {
            this.channel.unregisterRequest(this.ioid);
            this.channel.getChannelSecuritySession().release(this.ioid);
            if (this.channelGet != null) {
                this.channelGet.destroy();
            }
        }

        public ChannelGet getChannelGet() {
            return this.channelGet;
        }

        @Override
        public void lock() {
        }

        @Override
        public void unlock() {
        }

        @Override
        public void send(ByteBuffer buffer, TransportSendControl control) {
            int request = this.getPendingRequest();
            control.startMessage((byte)10, 5);
            buffer.putInt(this.ioid);
            buffer.put((byte)request);
            this.status.serialize(buffer, (SerializableControl)control);
            if (this.status.isSuccess()) {
                if (QoS.INIT.isSet(request)) {
                    control.cachedSerialize((Field)this.structure, buffer);
                } else {
                    this.bitSet.serialize(buffer, (SerializableControl)control);
                    this.pvStructure.serialize(buffer, (SerializableControl)control, this.bitSet);
                    this.pvStructure = null;
                    this.bitSet = null;
                }
            }
            this.stopRequest();
            if (QoS.DESTROY.isSet(request)) {
                this.destroy();
            }
        }
    }
}

