/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.server.impl.remote.handlers;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.epics.pvaccess.client.ChannelPutGet;
import org.epics.pvaccess.client.ChannelPutGetRequester;
import org.epics.pvaccess.client.impl.remote.BaseRequestImpl;
import org.epics.pvaccess.impl.remote.QoS;
import org.epics.pvaccess.impl.remote.SerializationHelper;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.TransportSendControl;
import org.epics.pvaccess.impl.remote.TransportSender;
import org.epics.pvaccess.impl.remote.server.ChannelHostingTransport;
import org.epics.pvaccess.server.impl.remote.ServerChannelImpl;
import org.epics.pvaccess.server.impl.remote.ServerContextImpl;
import org.epics.pvaccess.server.impl.remote.handlers.AbstractServerResponseHandler;
import org.epics.pvaccess.server.impl.remote.handlers.BaseChannelRequester;
import org.epics.pvdata.misc.BitSet;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Status;
import org.epics.pvdata.pv.Structure;

public class PutGetHandler
extends AbstractServerResponseHandler {
    public PutGetHandler(ServerContextImpl context) {
        super(context, "Put-get request");
    }

    @Override
    public void handleResponse(InetSocketAddress responseFrom, Transport transport, byte version, byte command, int payloadSize, ByteBuffer payloadBuffer) {
        super.handleResponse(responseFrom, transport, version, command, payloadSize, payloadBuffer);
        ChannelHostingTransport casTransport = (ChannelHostingTransport)((Object)transport);
        transport.ensureData(9);
        int sid = payloadBuffer.getInt();
        int ioid = payloadBuffer.getInt();
        byte qosCode = payloadBuffer.get();
        ServerChannelImpl channel = (ServerChannelImpl)casTransport.getChannel(sid);
        if (channel == null) {
            BaseChannelRequester.sendFailureMessage((byte)12, transport, ioid, qosCode, BaseChannelRequester.badCIDStatus);
            return;
        }
        boolean init = QoS.INIT.isSet(qosCode);
        if (init) {
            PVStructure pvRequest = SerializationHelper.deserializePVRequest(payloadBuffer, transport);
            Status asStatus = channel.getChannelSecuritySession().authorizeCreateChannelPutGet(ioid, pvRequest);
            if (!asStatus.isSuccess()) {
                BaseChannelRequester.sendFailureMessage((byte)12, transport, ioid, (byte)QoS.INIT.getMaskValue(), asStatus);
                return;
            }
            new ChannelPutGetRequesterImpl(this.context, channel, ioid, transport, pvRequest);
        } else {
            boolean lastRequest = QoS.DESTROY.isSet(qosCode);
            boolean getGet = QoS.GET.isSet(qosCode);
            boolean getPut = QoS.GET_PUT.isSet(qosCode);
            ChannelPutGetRequesterImpl request = (ChannelPutGetRequesterImpl)channel.getRequest(ioid);
            if (request == null) {
                BaseChannelRequester.sendFailureMessage((byte)12, transport, ioid, qosCode, BaseChannelRequester.badIOIDStatus);
                return;
            }
            if (!request.startRequest(qosCode)) {
                BaseChannelRequester.sendFailureMessage((byte)12, transport, ioid, qosCode, BaseChannelRequester.otherRequestPendingStatus);
                return;
            }
            ChannelPutGet channelPutGet = request.getChannelPutGet();
            if (lastRequest) {
                channelPutGet.lastRequest();
            }
            if (getGet) {
                Status asStatus = channel.getChannelSecuritySession().authorizeGet(ioid);
                if (!asStatus.isSuccess()) {
                    BaseChannelRequester.sendFailureMessage((byte)12, transport, ioid, qosCode, asStatus);
                    if (lastRequest) {
                        request.destroy();
                    }
                    return;
                }
                channelPutGet.getGet();
            } else if (getPut) {
                Status asStatus = channel.getChannelSecuritySession().authorizeGet(ioid);
                if (!asStatus.isSuccess()) {
                    BaseChannelRequester.sendFailureMessage((byte)12, transport, ioid, qosCode, asStatus);
                    if (lastRequest) {
                        request.destroy();
                    }
                    return;
                }
                channelPutGet.getPut();
            } else {
                BitSet bitSet = request.getPVPutBitSet();
                PVStructure pvStructure = request.getPVPutStructure();
                bitSet.deserialize(payloadBuffer, (DeserializableControl)transport);
                pvStructure.deserialize(payloadBuffer, (DeserializableControl)transport, bitSet);
                Status asStatus = channel.getChannelSecuritySession().authorizePutGet(ioid, pvStructure, bitSet);
                if (!asStatus.isSuccess()) {
                    BaseChannelRequester.sendFailureMessage((byte)11, transport, ioid, qosCode, asStatus);
                    if (lastRequest) {
                        request.destroy();
                    }
                    return;
                }
                channelPutGet.putGet(pvStructure, bitSet);
            }
        }
    }

    private static class ChannelPutGetRequesterImpl
    extends BaseChannelRequester
    implements ChannelPutGetRequester,
    TransportSender {
        private volatile ChannelPutGet channelPutGet;
        private volatile Status status;
        private volatile PVStructure pvPutStructure;
        private volatile BitSet pvPutBitSet;
        private volatile PVStructure pvGetStructure;
        private volatile BitSet pvGetBitSet;
        private volatile PVStructure pvPutGetStructure;
        private volatile BitSet pvPutGetBitSet;
        private volatile Structure putStructure;
        private volatile Structure getStructure;

        public ChannelPutGetRequesterImpl(ServerContextImpl context, ServerChannelImpl channel, int ioid, Transport transport, PVStructure pvRequest) {
            super(context, channel, ioid, transport);
            this.startRequest(QoS.INIT.getMaskValue());
            channel.registerRequest(ioid, this);
            try {
                this.channelPutGet = channel.getChannel().createChannelPutGet(this, pvRequest);
            }
            catch (Throwable th) {
                BaseChannelRequester.sendFailureMessage((byte)12, transport, ioid, (byte)QoS.INIT.getMaskValue(), statusCreate.createStatus(Status.StatusType.FATAL, "Unexpected exception caught: " + th.getMessage(), th));
                this.destroy();
            }
        }

        @Override
        public void channelPutGetConnect(Status status, ChannelPutGet channelPutGet, Structure putStructure, Structure getStructure) {
            this.status = status;
            this.channelPutGet = channelPutGet;
            this.putStructure = putStructure;
            this.getStructure = getStructure;
            if (status.isSuccess()) {
                this.pvPutGetStructure = (PVStructure)BaseRequestImpl.reuseOrCreatePVField((Field)putStructure, (PVField)this.pvPutGetStructure);
                this.pvPutGetBitSet = BaseRequestImpl.createBitSetFor(this.pvPutGetStructure, this.pvPutGetBitSet);
            }
            this.transport.enqueueSendRequest(this);
            if (!status.isSuccess()) {
                this.destroy();
            }
        }

        @Override
        public void getGetDone(Status status, ChannelPutGet channelPutGet, PVStructure pvGetStructure, BitSet pvGetBitSet) {
            this.status = status;
            this.pvGetStructure = pvGetStructure;
            this.pvGetBitSet = pvGetBitSet;
            this.transport.enqueueSendRequest(this);
        }

        @Override
        public void getPutDone(Status status, ChannelPutGet channelPutGet, PVStructure pvPutStructure, BitSet pvPutBitSet) {
            this.status = status;
            this.pvPutStructure = pvPutStructure;
            this.pvPutBitSet = pvPutBitSet;
            this.transport.enqueueSendRequest(this);
        }

        @Override
        public void putGetDone(Status status, ChannelPutGet channelPutGet, PVStructure pvGetStructure, BitSet pvGetBitSet) {
            this.status = status;
            this.pvGetStructure = pvGetStructure;
            this.pvGetBitSet = pvGetBitSet;
            this.transport.enqueueSendRequest(this);
        }

        public void destroy() {
            this.channel.unregisterRequest(this.ioid);
            this.channel.getChannelSecuritySession().release(this.ioid);
            if (this.channelPutGet != null) {
                this.channelPutGet.destroy();
            }
        }

        public ChannelPutGet getChannelPutGet() {
            return this.channelPutGet;
        }

        public PVStructure getPVPutStructure() {
            return this.pvPutGetStructure;
        }

        public BitSet getPVPutBitSet() {
            return this.pvPutGetBitSet;
        }

        @Override
        public void lock() {
        }

        @Override
        public void unlock() {
        }

        @Override
        public void send(ByteBuffer buffer, TransportSendControl control) {
            int request = this.getPendingRequest();
            control.startMessage((byte)12, 5);
            buffer.putInt(this.ioid);
            buffer.put((byte)request);
            this.status.serialize(buffer, (SerializableControl)control);
            if (this.status.isSuccess()) {
                if (QoS.INIT.isSet(request)) {
                    control.cachedSerialize((Field)this.putStructure, buffer);
                    control.cachedSerialize((Field)this.getStructure, buffer);
                } else if (QoS.GET.isSet(request)) {
                    this.pvGetBitSet.serialize(buffer, (SerializableControl)control);
                    this.pvGetStructure.serialize(buffer, (SerializableControl)control, this.pvGetBitSet);
                    this.pvGetStructure = null;
                    this.pvGetBitSet = null;
                } else if (QoS.GET_PUT.isSet(request)) {
                    this.pvPutBitSet.serialize(buffer, (SerializableControl)control);
                    this.pvPutStructure.serialize(buffer, (SerializableControl)control, this.pvPutBitSet);
                    this.pvPutStructure = null;
                    this.pvPutBitSet = null;
                } else {
                    this.pvGetBitSet.serialize(buffer, (SerializableControl)control);
                    this.pvGetStructure.serialize(buffer, (SerializableControl)control, this.pvGetBitSet);
                    this.pvGetStructure = null;
                    this.pvGetBitSet = null;
                }
            }
            this.stopRequest();
            if (QoS.DESTROY.isSet(request)) {
                this.destroy();
            }
        }
    }
}

