/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.server.impl.remote.handlers;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.epics.pvaccess.client.ChannelPut;
import org.epics.pvaccess.client.ChannelPutRequester;
import org.epics.pvaccess.client.impl.remote.BaseRequestImpl;
import org.epics.pvaccess.impl.remote.QoS;
import org.epics.pvaccess.impl.remote.SerializationHelper;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.TransportSendControl;
import org.epics.pvaccess.impl.remote.TransportSender;
import org.epics.pvaccess.impl.remote.server.ChannelHostingTransport;
import org.epics.pvaccess.server.impl.remote.ServerChannelImpl;
import org.epics.pvaccess.server.impl.remote.ServerContextImpl;
import org.epics.pvaccess.server.impl.remote.handlers.AbstractServerResponseHandler;
import org.epics.pvaccess.server.impl.remote.handlers.BaseChannelRequester;
import org.epics.pvdata.misc.BitSet;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Status;
import org.epics.pvdata.pv.Structure;

public class PutHandler
extends AbstractServerResponseHandler {
    public PutHandler(ServerContextImpl context) {
        super(context, "Put request");
    }

    @Override
    public void handleResponse(InetSocketAddress responseFrom, Transport transport, byte version, byte command, int payloadSize, ByteBuffer payloadBuffer) {
        super.handleResponse(responseFrom, transport, version, command, payloadSize, payloadBuffer);
        ChannelHostingTransport casTransport = (ChannelHostingTransport)((Object)transport);
        transport.ensureData(9);
        int sid = payloadBuffer.getInt();
        int ioid = payloadBuffer.getInt();
        byte qosCode = payloadBuffer.get();
        ServerChannelImpl channel = (ServerChannelImpl)casTransport.getChannel(sid);
        if (channel == null) {
            BaseChannelRequester.sendFailureMessage((byte)11, transport, ioid, qosCode, BaseChannelRequester.badCIDStatus);
            return;
        }
        boolean init = QoS.INIT.isSet(qosCode);
        if (init) {
            PVStructure pvRequest = SerializationHelper.deserializePVRequest(payloadBuffer, transport);
            Status asStatus = channel.getChannelSecuritySession().authorizeCreateChannelPut(ioid, pvRequest);
            if (!asStatus.isSuccess()) {
                BaseChannelRequester.sendFailureMessage((byte)11, transport, ioid, (byte)QoS.INIT.getMaskValue(), asStatus);
                return;
            }
            new ChannelPutRequesterImpl(this.context, channel, ioid, transport, pvRequest);
        } else {
            boolean lastRequest = QoS.DESTROY.isSet(qosCode);
            boolean get = QoS.GET.isSet(qosCode);
            ChannelPutRequesterImpl request = (ChannelPutRequesterImpl)channel.getRequest(ioid);
            if (request == null) {
                BaseChannelRequester.sendFailureMessage((byte)11, transport, ioid, qosCode, BaseChannelRequester.badIOIDStatus);
                return;
            }
            if (!request.startRequest(qosCode)) {
                BaseChannelRequester.sendFailureMessage((byte)11, transport, ioid, qosCode, BaseChannelRequester.otherRequestPendingStatus);
                return;
            }
            ChannelPut channelPut = request.getChannelPut();
            if (lastRequest) {
                channelPut.lastRequest();
            }
            if (get) {
                Status asStatus = channel.getChannelSecuritySession().authorizeGet(ioid);
                if (!asStatus.isSuccess()) {
                    BaseChannelRequester.sendFailureMessage((byte)11, transport, ioid, qosCode, asStatus);
                    if (lastRequest) {
                        request.destroy();
                    }
                    return;
                }
                channelPut.get();
            } else {
                BitSet putBitSet = request.getPutBitSet();
                PVStructure putPVStructure = request.getPutPVStructure();
                putBitSet.deserialize(payloadBuffer, (DeserializableControl)transport);
                putPVStructure.deserialize(payloadBuffer, (DeserializableControl)transport, putBitSet);
                Status asStatus = channel.getChannelSecuritySession().authorizePut(ioid, putPVStructure, putBitSet);
                if (!asStatus.isSuccess()) {
                    BaseChannelRequester.sendFailureMessage((byte)11, transport, ioid, qosCode, asStatus);
                    if (lastRequest) {
                        request.destroy();
                    }
                    return;
                }
                channelPut.put(putPVStructure, putBitSet);
            }
        }
    }

    private static class ChannelPutRequesterImpl
    extends BaseChannelRequester
    implements ChannelPutRequester,
    TransportSender {
        private volatile ChannelPut channelPut;
        private volatile Status status;
        private volatile Structure structure;
        private volatile PVStructure pvStructure;
        private volatile BitSet bitSet;
        private volatile PVStructure putPVStructure;
        private volatile BitSet putBitSet;

        public ChannelPutRequesterImpl(ServerContextImpl context, ServerChannelImpl channel, int ioid, Transport transport, PVStructure pvRequest) {
            super(context, channel, ioid, transport);
            this.startRequest(QoS.INIT.getMaskValue());
            channel.registerRequest(ioid, this);
            try {
                this.channelPut = channel.getChannel().createChannelPut(this, pvRequest);
            }
            catch (Throwable th) {
                BaseChannelRequester.sendFailureMessage((byte)11, transport, ioid, (byte)QoS.INIT.getMaskValue(), statusCreate.createStatus(Status.StatusType.FATAL, "Unexpected exception caught: " + th.getMessage(), th));
                this.destroy();
            }
        }

        @Override
        public void channelPutConnect(Status status, ChannelPut channelPut, Structure structure) {
            this.status = status;
            this.channelPut = channelPut;
            this.structure = structure;
            if (status.isSuccess()) {
                this.putPVStructure = (PVStructure)BaseRequestImpl.reuseOrCreatePVField((Field)structure, (PVField)this.putPVStructure);
                this.putBitSet = BaseRequestImpl.createBitSetFor(this.putPVStructure, this.putBitSet);
            }
            this.transport.enqueueSendRequest(this);
            if (!status.isSuccess()) {
                this.destroy();
            }
        }

        @Override
        public void putDone(Status status, ChannelPut channelPut) {
            this.status = status;
            this.transport.enqueueSendRequest(this);
        }

        @Override
        public void getDone(Status status, ChannelPut channelPut, PVStructure pvStructure, BitSet bitSet) {
            this.status = status;
            this.pvStructure = pvStructure;
            this.bitSet = bitSet;
            this.transport.enqueueSendRequest(this);
        }

        public void destroy() {
            this.channel.unregisterRequest(this.ioid);
            this.channel.getChannelSecuritySession().release(this.ioid);
            if (this.channelPut != null) {
                this.channelPut.destroy();
            }
        }

        public ChannelPut getChannelPut() {
            return this.channelPut;
        }

        public BitSet getPutBitSet() {
            return this.putBitSet;
        }

        public PVStructure getPutPVStructure() {
            return this.putPVStructure;
        }

        @Override
        public void lock() {
        }

        @Override
        public void unlock() {
        }

        @Override
        public void send(ByteBuffer buffer, TransportSendControl control) {
            int request = this.getPendingRequest();
            control.startMessage((byte)11, 5);
            buffer.putInt(this.ioid);
            buffer.put((byte)request);
            this.status.serialize(buffer, (SerializableControl)control);
            if (this.status.isSuccess()) {
                if (QoS.INIT.isSet(request)) {
                    control.cachedSerialize((Field)this.structure, buffer);
                } else if (QoS.GET.isSet(request)) {
                    this.bitSet.serialize(buffer, (SerializableControl)control);
                    this.pvStructure.serialize(buffer, (SerializableControl)control, this.bitSet);
                    this.pvStructure = null;
                    this.bitSet = null;
                }
            }
            this.stopRequest();
            if (QoS.DESTROY.isSet(request)) {
                this.destroy();
            }
        }
    }
}

