/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.server.impl.remote.handlers;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.epics.pvaccess.client.ChannelRPC;
import org.epics.pvaccess.client.ChannelRPCRequester;
import org.epics.pvaccess.impl.remote.QoS;
import org.epics.pvaccess.impl.remote.SerializationHelper;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.TransportSendControl;
import org.epics.pvaccess.impl.remote.TransportSender;
import org.epics.pvaccess.impl.remote.server.ChannelHostingTransport;
import org.epics.pvaccess.server.impl.remote.ServerChannelImpl;
import org.epics.pvaccess.server.impl.remote.ServerContextImpl;
import org.epics.pvaccess.server.impl.remote.handlers.AbstractServerResponseHandler;
import org.epics.pvaccess.server.impl.remote.handlers.BaseChannelRequester;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Status;

public class RPCHandler
extends AbstractServerResponseHandler {
    public RPCHandler(ServerContextImpl context) {
        super(context, "RPC request");
    }

    @Override
    public void handleResponse(InetSocketAddress responseFrom, Transport transport, byte version, byte command, int payloadSize, ByteBuffer payloadBuffer) {
        super.handleResponse(responseFrom, transport, version, command, payloadSize, payloadBuffer);
        ChannelHostingTransport casTransport = (ChannelHostingTransport)((Object)transport);
        transport.ensureData(9);
        int sid = payloadBuffer.getInt();
        int ioid = payloadBuffer.getInt();
        byte qosCode = payloadBuffer.get();
        ServerChannelImpl channel = (ServerChannelImpl)casTransport.getChannel(sid);
        if (channel == null) {
            BaseChannelRequester.sendFailureMessage((byte)20, transport, ioid, qosCode, BaseChannelRequester.badCIDStatus);
            return;
        }
        boolean init = QoS.INIT.isSet(qosCode);
        if (init) {
            PVStructure pvRequest = SerializationHelper.deserializePVRequest(payloadBuffer, transport);
            Status asStatus = channel.getChannelSecuritySession().authorizeCreateChannelRPC(ioid, pvRequest);
            if (!asStatus.isSuccess()) {
                BaseChannelRequester.sendFailureMessage((byte)20, transport, ioid, (byte)QoS.INIT.getMaskValue(), asStatus);
                return;
            }
            new ChannelRPCRequesterImpl(this.context, channel, ioid, transport, pvRequest);
        } else {
            boolean lastRequest = QoS.DESTROY.isSet(qosCode);
            ChannelRPCRequesterImpl request = (ChannelRPCRequesterImpl)channel.getRequest(ioid);
            if (request == null) {
                BaseChannelRequester.sendFailureMessage((byte)20, transport, ioid, qosCode, BaseChannelRequester.badIOIDStatus);
                return;
            }
            if (!request.startRequest(qosCode)) {
                BaseChannelRequester.sendFailureMessage((byte)20, transport, ioid, qosCode, BaseChannelRequester.otherRequestPendingStatus);
                return;
            }
            PVStructure pvArgument = SerializationHelper.deserializeStructureFull(payloadBuffer, transport);
            Status asStatus = channel.getChannelSecuritySession().authorizeRPC(ioid, pvArgument);
            if (!asStatus.isSuccess()) {
                BaseChannelRequester.sendFailureMessage((byte)20, transport, ioid, qosCode, asStatus);
                if (lastRequest) {
                    request.destroy();
                }
                return;
            }
            ChannelRPC channelRPC = request.getChannelRPC();
            if (lastRequest) {
                channelRPC.lastRequest();
            }
            channelRPC.request(pvArgument);
        }
    }

    private static class ChannelRPCRequesterImpl
    extends BaseChannelRequester
    implements ChannelRPCRequester,
    TransportSender {
        private volatile ChannelRPC channelRPC;
        private volatile PVStructure pvResponse;
        private volatile Status status;

        public ChannelRPCRequesterImpl(ServerContextImpl context, ServerChannelImpl channel, int ioid, Transport transport, PVStructure pvRequest) {
            super(context, channel, ioid, transport);
            this.startRequest(QoS.INIT.getMaskValue());
            channel.registerRequest(ioid, this);
            try {
                this.channelRPC = channel.getChannel().createChannelRPC(this, pvRequest);
            }
            catch (Throwable th) {
                BaseChannelRequester.sendFailureMessage((byte)20, transport, ioid, (byte)QoS.INIT.getMaskValue(), statusCreate.createStatus(Status.StatusType.FATAL, "Unexpected exception caught: " + th.getMessage(), th));
                this.destroy();
            }
        }

        @Override
        public void channelRPCConnect(Status status, ChannelRPC channelRPC) {
            this.status = status;
            this.channelRPC = channelRPC;
            this.transport.enqueueSendRequest(this);
            if (!status.isSuccess()) {
                this.destroy();
            }
        }

        @Override
        public void requestDone(Status status, ChannelRPC channelRPC, PVStructure pvResponse) {
            this.status = status;
            this.pvResponse = pvResponse;
            this.transport.enqueueSendRequest(this);
        }

        public void destroy() {
            this.channel.unregisterRequest(this.ioid);
            this.channel.getChannelSecuritySession().release(this.ioid);
            if (this.channelRPC != null) {
                this.channelRPC.destroy();
            }
        }

        public ChannelRPC getChannelRPC() {
            return this.channelRPC;
        }

        @Override
        public void lock() {
        }

        @Override
        public void unlock() {
        }

        @Override
        public void send(ByteBuffer buffer, TransportSendControl control) {
            int request = this.getPendingRequest();
            control.startMessage((byte)20, 5);
            buffer.putInt(this.ioid);
            buffer.put((byte)request);
            this.status.serialize(buffer, (SerializableControl)control);
            if (this.status.isSuccess() && !QoS.INIT.isSet(request)) {
                SerializationHelper.serializeStructureFull(buffer, control, this.pvResponse);
                this.pvResponse = null;
            }
            this.stopRequest();
            if (QoS.DESTROY.isSet(request)) {
                this.destroy();
            }
        }
    }
}

