/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.server.impl.remote.tcp;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.epics.pvaccess.PVAException;
import org.epics.pvaccess.impl.remote.Context;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.server.impl.remote.ServerContextImpl;
import org.epics.pvaccess.server.impl.remote.tcp.BlockingServerTCPTransport;

public class BlockingTCPAcceptor {
    private Context context;
    private InetSocketAddress bindAddress = null;
    private ServerSocketChannel serverSocketChannel = null;
    private int receiveBufferSize;
    private AtomicBoolean destroyed = new AtomicBoolean(false);

    public BlockingTCPAcceptor(Context context, int port, int receiveBufferSize) throws PVAException {
        this.context = context;
        this.receiveBufferSize = receiveBufferSize;
        this.initialize(port);
    }

    public void handleEvents() {
        this.context.getLogger().finer("Accepting connections at " + this.bindAddress + ".");
        while (!this.destroyed.get() && this.serverSocketChannel.isOpen()) {
            try {
                SocketChannel socket = this.serverSocketChannel.accept();
                SocketAddress address = socket.socket().getRemoteSocketAddress();
                this.context.getLogger().finer("Accepted connection from PVA client: " + address);
                socket.socket().setTcpNoDelay(true);
                socket.socket().setKeepAlive(true);
                BlockingServerTCPTransport transport = new BlockingServerTCPTransport(this.context, socket, ((ServerContextImpl)this.context).getServerResponseHandler(), this.receiveBufferSize);
                if (!this.validateConnection(transport, address)) {
                    Thread.sleep(1000L);
                    transport.close();
                    this.context.getLogger().finer("Connection to PVA client " + address + " failed to be validated, closing it.");
                    continue;
                }
                this.context.getLogger().finer("Serving to PVA client: " + address);
            }
            catch (AsynchronousCloseException socket) {
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    private boolean validateConnection(Transport transport, SocketAddress address) {
        try {
            return transport.verify(5000L);
        }
        catch (Throwable th) {
            th.printStackTrace();
            this.context.getLogger().log(Level.FINEST, "Validation of " + address + " failed.", th);
            return false;
        }
    }

    /*
     * Loose catch block
     */
    private int initialize(int port) throws PVAException {
        this.bindAddress = new InetSocketAddress(port);
        int tryCount = 0;
        while (true) {
            ++tryCount;
            try {
                this.context.getLogger().finer("Creating acceptor to " + this.bindAddress + ".");
                this.serverSocketChannel = ServerSocketChannel.open();
                this.serverSocketChannel.socket().bind(this.bindAddress);
                this.serverSocketChannel.configureBlocking(true);
                if (this.bindAddress.getPort() == 0) {
                    this.bindAddress = new InetSocketAddress(this.serverSocketChannel.socket().getLocalPort());
                    this.context.getLogger().info("Using dynamically assigned TCP port " + this.bindAddress.getPort() + ".");
                }
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        BlockingTCPAcceptor.this.handleEvents();
                    }
                }, "TCP-acceptor").start();
                return this.bindAddress.getPort();
            }
            catch (BindException be) {
                if (tryCount == 1) {
                    this.context.getLogger().info("Configured TCP port " + port + " is unavailable, trying to assign it dynamically.");
                    this.bindAddress = new InetSocketAddress(0);
                    continue;
                }
                throw new PVAException("Failed to create acceptor to " + this.bindAddress, be);
            }
            break;
        }
        catch (Throwable th) {
            throw new PVAException("Failed to create acceptor to " + this.bindAddress, th);
        }
    }

    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public void destroy() {
        if (this.destroyed.getAndSet(true)) {
            return;
        }
        if (this.serverSocketChannel != null) {
            this.context.getLogger().finer("Stopped accepting connections at " + this.bindAddress + ".");
            try {
                this.serverSocketChannel.socket().close();
            }
            catch (IOException e) {
                this.context.getLogger().log(Level.FINE, "Failed to close acceptor socket at " + this.bindAddress + ".", e);
            }
        }
    }
}

