/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.util.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class ConsoleLogFormatter
extends Formatter {
    public static String KEY_TRACE = "TRACE";
    private boolean showTrace = System.getProperties().containsKey(KEY_TRACE);
    private static String lineSeparator = System.getProperty("line.separator");
    private static SimpleDateFormat timeFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private Date date = new Date();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(LogRecord record) {
        StringBuffer sb = new StringBuffer(128);
        Date date = this.date;
        synchronized (date) {
            this.date.setTime(record.getMillis());
            sb.append(timeFormatter.format(this.date));
        }
        sb.append(' ');
        sb.append(record.getMessage());
        sb.append(' ');
        if (this.showTrace) {
            sb.append('[');
            if (record.getSourceClassName() != null) {
                sb.append(record.getSourceClassName());
            }
            if (record.getSourceMethodName() != null) {
                sb.append('#');
                sb.append(record.getSourceMethodName());
            }
            sb.append(']');
        }
        sb.append(lineSeparator);
        if (record.getThrown() != null) {
            record.getThrown().printStackTrace();
        }
        return new String(sb);
    }
}

