/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca;

import gov.aps.jca.CAStatus;
import gov.aps.jca.Channel;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.event.ConnectionEvent;
import gov.aps.jca.event.ConnectionListener;
import gov.aps.jca.event.GetEvent;
import gov.aps.jca.event.GetListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.epics.ca.BaseV3ChannelStructure;
import org.epics.ca.V3Channel;
import org.epics.ca.V3ChannelStructure;
import org.epics.pvaccess.client.Channel;
import org.epics.pvaccess.client.ChannelGet;
import org.epics.pvaccess.client.ChannelGetRequester;
import org.epics.pvdata.factory.StatusFactory;
import org.epics.pvdata.pv.MessageType;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.Status;
import org.epics.pvdata.pv.StatusCreate;

public class BaseV3ChannelGet
implements ChannelGet,
GetListener,
ConnectionListener {
    private static final StatusCreate statusCreate = StatusFactory.getStatusCreate();
    private static final Status okStatus = statusCreate.getStatusOK();
    private static final Status channelDestroyedStatus = statusCreate.createStatus(Status.StatusType.ERROR, "channel destroyed", null);
    private static final Status channelNotConnectedStatus = statusCreate.createStatus(Status.StatusType.ERROR, "channel not connected", null);
    private static final Status disconnectedWhileActiveStatus = statusCreate.createStatus(Status.StatusType.ERROR, "disconnected while active", null);
    private static final Status createChannelStructureStatus = statusCreate.createStatus(Status.StatusType.ERROR, "createChannelStructure failed", null);
    private final ChannelGetRequester channelGetRequester;
    private final V3Channel v3Channel;
    private final V3ChannelStructure v3ChannelStructure;
    private final gov.aps.jca.Channel jcaChannel;
    private volatile boolean isDestroyed = false;
    private volatile boolean lastRequest = false;
    private final ReentrantLock lock = new ReentrantLock();
    private final AtomicBoolean isActive = new AtomicBoolean(false);
    private final PVStructure pvRequest;

    public BaseV3ChannelGet(ChannelGetRequester channelGetRequester, V3Channel v3Channel, PVStructure pvRequest) {
        this.channelGetRequester = channelGetRequester;
        this.v3Channel = v3Channel;
        this.pvRequest = pvRequest;
        v3Channel.add(this);
        this.v3ChannelStructure = new BaseV3ChannelStructure(v3Channel);
        this.jcaChannel = v3Channel.getJCAChannel();
        try {
            this.jcaChannel.addConnectionListener((ConnectionListener)this);
        }
        catch (Throwable th) {
            channelGetRequester.channelGetConnect(statusCreate.createStatus(Status.StatusType.ERROR, "addConnectionListener failed", th), this, null);
            this.destroy();
            return;
        }
        if (this.jcaChannel.getConnectionState() == gov.aps.jca.Channel.CONNECTED) {
            this.connectionChanged(new ConnectionEvent(this.jcaChannel, true));
        }
    }

    public void destroy() {
        this.isDestroyed = true;
        this.v3Channel.remove(this);
        try {
            this.jcaChannel.removeConnectionListener((ConnectionListener)this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void get() {
        if (this.isDestroyed) {
            this.getDone(channelDestroyedStatus);
            return;
        }
        gov.aps.jca.Channel jcaChannel = this.v3Channel.getJCAChannel();
        if (jcaChannel.getConnectionState() != Channel.ConnectionState.CONNECTED) {
            this.getDone(channelNotConnectedStatus);
            return;
        }
        this.isActive.set(true);
        try {
            jcaChannel.get(this.v3ChannelStructure.getRequestDBRType(), 0, (GetListener)this);
        }
        catch (Throwable th) {
            this.getDone(statusCreate.createStatus(Status.StatusType.ERROR, "failed to get", th));
        }
    }

    public String getRequesterName() {
        return this.v3Channel.getRequesterName();
    }

    public void message(String message, MessageType messageType) {
        this.v3Channel.message(message, messageType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getCompleted(GetEvent getEvent) {
        DBR fromDBR = getEvent.getDBR();
        if (fromDBR == null) {
            CAStatus caStatus = getEvent.getStatus();
            this.getDone(statusCreate.createStatus(Status.StatusType.ERROR, caStatus.toString(), null));
            return;
        }
        this.lock();
        try {
            this.v3ChannelStructure.toStructure(fromDBR);
        }
        finally {
            this.unlock();
        }
        this.getDone(okStatus);
    }

    public void connectionChanged(ConnectionEvent event) {
        if (!event.isConnected()) {
            this.getDone(disconnectedWhileActiveStatus);
        } else if (this.v3ChannelStructure.createPVStructure(this.pvRequest, true) == null) {
            this.channelGetRequester.channelGetConnect(createChannelStructureStatus, this, null);
            this.destroy();
        } else {
            this.channelGetRequester.channelGetConnect(okStatus, this, this.v3ChannelStructure.getPVStructure().getStructure());
        }
    }

    private void getDone(Status success) {
        if (!this.isActive.getAndSet(false)) {
            return;
        }
        if (this.lastRequest) {
            this.destroy();
        }
        this.channelGetRequester.getDone(success, this, this.v3ChannelStructure.getPVStructure(), this.v3ChannelStructure.getBitSet());
    }

    @Override
    public void lock() {
        this.lock.lock();
    }

    @Override
    public void unlock() {
        this.lock.unlock();
    }

    @Override
    public void cancel() {
    }

    @Override
    public void lastRequest() {
        this.lastRequest = true;
    }

    @Override
    public Channel getChannel() {
        return this.v3Channel;
    }
}

