/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.impl.remote;

import java.net.InetSocketAddress;
import java.util.Arrays;
import org.epics.pvaccess.client.impl.remote.BeaconHandler;
import org.epics.pvaccess.client.impl.remote.ClientContextImpl;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvdata.pv.PVField;

public class BeaconHandlerImpl
implements BeaconHandler {
    private final ClientContextImpl context;
    private final String protocol;
    private final InetSocketAddress responseFrom;
    private byte[] serverGUID = null;
    private int serverChangeCount;

    public BeaconHandlerImpl(ClientContextImpl context, String protocol, InetSocketAddress responseFrom) {
        this.context = context;
        this.protocol = protocol;
        this.responseFrom = responseFrom;
    }

    @Override
    public void beaconNotify(InetSocketAddress from, byte remoteTransportRevision, long timestamp, byte[] guid, int sequentalID, int changeCount, PVField data) {
        boolean networkChanged = this.updateBeacon(remoteTransportRevision, timestamp, guid, sequentalID, changeCount);
        if (networkChanged) {
            this.changedTransport();
        }
    }

    private synchronized boolean updateBeacon(byte remoteTransportRevision, long timestamp, byte[] guid, int sequentalID, int changeCount) {
        if (this.serverGUID == null) {
            this.serverGUID = guid;
            this.serverChangeCount = changeCount;
            this.context.newServerDetected();
            return false;
        }
        boolean networkChange = Arrays.equals(this.serverGUID, guid);
        if (networkChange) {
            this.serverGUID = guid;
            this.serverChangeCount = changeCount;
            this.context.newServerDetected();
            return true;
        }
        if (this.serverChangeCount != changeCount) {
            this.serverChangeCount = changeCount;
            this.context.newServerDetected();
            return true;
        }
        return false;
    }

    private void changedTransport() {
        Transport[] transports = this.context.getTransportRegistry().get(this.protocol, this.responseFrom);
        if (transports == null) {
            return;
        }
        for (int i = 0; i < transports.length; ++i) {
            transports[i].changedTransport();
        }
    }
}

