/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.impl.remote;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.epics.pvaccess.PVFactory;
import org.epics.pvaccess.client.impl.remote.BaseRequestImpl;
import org.epics.pvaccess.client.impl.remote.ChannelImpl;
import org.epics.pvaccess.impl.remote.QoS;
import org.epics.pvaccess.impl.remote.SerializationHelper;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.TransportSendControl;
import org.epics.pvaccess.impl.remote.TransportSender;
import org.epics.pvdata.factory.ConvertFactory;
import org.epics.pvdata.misc.BitSet;
import org.epics.pvdata.misc.BitSetUtil;
import org.epics.pvdata.misc.BitSetUtilFactory;
import org.epics.pvdata.monitor.Monitor;
import org.epics.pvdata.monitor.MonitorElement;
import org.epics.pvdata.monitor.MonitorQueue;
import org.epics.pvdata.monitor.MonitorQueueFactory;
import org.epics.pvdata.monitor.MonitorRequester;
import org.epics.pvdata.pv.Convert;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.PVDataCreate;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVString;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.Requester;
import org.epics.pvdata.pv.Status;
import org.epics.pvdata.pv.Structure;

public class ChannelMonitorImpl
extends BaseRequestImpl
implements Monitor {
    private static final PVDataCreate pvDataCreate = PVFactory.getPVDataCreate();
    protected final MonitorRequester callback;
    protected AtomicBoolean started = new AtomicBoolean(false);
    protected final int queueSize;
    protected final boolean pipeline;
    protected final int ackAny;
    private final MonitorStrategy monitorStrategy;
    private static final BitSetUtil bitSetUtil = BitSetUtilFactory.getCompressBitSet();
    private static final Convert convert = ConvertFactory.getConvert();

    public static ChannelMonitorImpl create(ChannelImpl channel, MonitorRequester callback, PVStructure pvRequest) {
        ChannelMonitorImpl thisInstance = new ChannelMonitorImpl(channel, callback, pvRequest);
        thisInstance.activate();
        return thisInstance;
    }

    protected ChannelMonitorImpl(ChannelImpl channel, MonitorRequester callback, PVStructure pvRequest) {
        super(channel, (Requester)callback, pvRequest, false);
        this.callback = callback;
        int qs = 2;
        boolean pl = false;
        int aa = 1;
        PVField pvField = pvRequest.getSubField("record._options");
        if (pvField != null) {
            String value;
            PVStructure pvOptions = (PVStructure)pvField;
            PVString pvString = pvOptions.getStringField("queueSize");
            if (pvString != null) {
                value = pvString.get();
                try {
                    qs = Integer.parseInt(value);
                    if (qs < 2) {
                        qs = 2;
                    }
                }
                catch (NumberFormatException e) {
                    callback.monitorConnect(PVFactory.getStatusCreate().createStatus(Status.StatusType.ERROR, "queueSize is not a valid integer", (Throwable)e), (Monitor)this, null);
                    this.monitorStrategy = null;
                    this.queueSize = 2;
                    this.pipeline = false;
                    this.ackAny = 1;
                    this.destroy(true);
                    return;
                }
            }
            if ((pvString = pvOptions.getStringField("pipeline")) != null && (pl = Boolean.parseBoolean(value = pvString.get()))) {
                aa = qs / 2;
                pvString = pvOptions.getStringField("ackAny");
                if (pvString != null) {
                    value = pvString.get();
                    boolean percentage = value.endsWith("%");
                    if (percentage) {
                        value = value.substring(0, value.length() - 1);
                    }
                    try {
                        aa = Integer.parseInt(value);
                        if (percentage) {
                            aa = qs * aa / 100;
                        }
                        if (aa <= 1) {
                            aa = 1;
                        }
                        if (aa > qs) {
                            aa = qs - 1;
                        }
                    }
                    catch (NumberFormatException e) {
                        callback.monitorConnect(PVFactory.getStatusCreate().createStatus(Status.StatusType.ERROR, "ackAny is not a valid integer", (Throwable)e), (Monitor)this, null);
                        this.monitorStrategy = null;
                        this.queueSize = 2;
                        this.pipeline = false;
                        this.ackAny = 1;
                        this.destroy(true);
                        return;
                    }
                }
            }
        }
        this.queueSize = qs;
        this.pipeline = pl;
        this.ackAny = aa;
        this.monitorStrategy = new MonitorStrategyQueue(this.queueSize, this.pipeline, this.ackAny);
    }

    @Override
    protected void activate() {
        super.activate();
        try {
            this.resubscribeSubscription(this.channel.checkDestroyedAndGetTransport());
        }
        catch (IllegalStateException ise) {
            this.callback.monitorConnect(channelDestroyed, (Monitor)this, null);
            this.destroy(true);
        }
    }

    @Override
    public void resubscribeSubscription(Transport transport) {
        if (transport != null && !this.subscribed && this.startRequest(this.pipeline ? QoS.INIT.getMaskValue() | QoS.GET_PUT.getMaskValue() : QoS.INIT.getMaskValue())) {
            this.subscribed = true;
            transport.enqueueSendRequest(this);
        }
    }

    @Override
    public void send(ByteBuffer buffer, TransportSendControl control) {
        int pendingRequest = this.getPendingRequest();
        if (pendingRequest < 0) {
            super.send(buffer, control);
            return;
        }
        control.startMessage((byte)13, 9);
        buffer.putInt(this.channel.getServerChannelID());
        buffer.putInt(this.ioid);
        buffer.put((byte)pendingRequest);
        if (QoS.INIT.isSet(pendingRequest)) {
            SerializationHelper.serializePVRequest(buffer, control, this.pvRequest);
            if (this.pipeline) {
                control.ensureBuffer(4);
                buffer.putInt(this.queueSize);
            }
        }
        this.stopRequest();
    }

    @Override
    void initResponse(Transport transport, byte version, ByteBuffer payloadBuffer, byte qos, Status status) {
        if (!status.isSuccess()) {
            this.callback.monitorConnect(status, (Monitor)this, null);
            return;
        }
        Structure structure = (Structure)transport.cachedDeserialize(payloadBuffer);
        this.monitorStrategy.init(structure);
        this.callback.monitorConnect(okStatus, (Monitor)this, structure);
    }

    @Override
    void normalResponse(Transport transport, byte version, ByteBuffer payloadBuffer, byte qos, Status status) {
        if (!QoS.GET.isSet(qos)) {
            if (QoS.DESTROY.isSet(qos)) {
                if (payloadBuffer.hasRemaining()) {
                    this.monitorStrategy.response(transport, payloadBuffer);
                }
                this.monitorStrategy.unlisten();
            } else {
                this.monitorStrategy.response(transport, payloadBuffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void response(Transport transport, byte version, ByteBuffer payloadBuffer) {
        boolean destroy = false;
        try {
            transport.ensureData(1);
            byte qos = payloadBuffer.get();
            if (QoS.INIT.isSet(qos)) {
                Status status = statusCreate.deserializeStatus(payloadBuffer, (DeserializableControl)transport);
                boolean restoreStartedState = this.started.get();
                this.initResponse(transport, version, payloadBuffer, qos, status);
                if (restoreStartedState) {
                    this.start();
                }
            } else if (QoS.DESTROY.isSet(qos)) {
                Status status = statusCreate.deserializeStatus(payloadBuffer, (DeserializableControl)transport);
                this.remotelyDestroyed = true;
                destroy = true;
                this.normalResponse(transport, version, payloadBuffer, qos, status);
            } else {
                this.normalResponse(transport, version, payloadBuffer, qos, okStatus);
            }
        }
        finally {
            if (destroy) {
                this.destroy();
            }
        }
    }

    public Status start() {
        if (this.destroyed) {
            return destroyedStatus;
        }
        this.monitorStrategy.start();
        try {
            this.startRequest(QoS.PROCESS.getMaskValue() | QoS.GET.getMaskValue());
            this.channel.checkAndGetTransport().enqueueSendRequest(this);
            this.started.set(true);
            return okStatus;
        }
        catch (IllegalStateException ise) {
            this.stopRequest();
            return channelNotConnected;
        }
    }

    public Status stop() {
        if (this.destroyed) {
            return destroyedStatus;
        }
        this.monitorStrategy.stop();
        try {
            this.startRequest(QoS.PROCESS.getMaskValue());
            this.channel.checkAndGetTransport().enqueueSendRequest(this);
            this.started.set(false);
            return okStatus;
        }
        catch (IllegalStateException ise) {
            this.stopRequest();
            return channelNotConnected;
        }
    }

    public MonitorElement poll() {
        return this.monitorStrategy.poll();
    }

    public void release(MonitorElement monitorElement) {
        this.monitorStrategy.release(monitorElement);
    }

    private final class MonitorStrategyQueue
    implements MonitorStrategy,
    TransportSender {
        private final int queueSize;
        private MonitorElement monitorElement = null;
        private BitSet bitSet1 = null;
        private BitSet bitSet2 = null;
        private boolean overrunInProgress = false;
        private Structure lastStructure = null;
        private MonitorQueue monitorQueue = null;
        private final Object monitorSync = new Object();
        private boolean needToReleaseFirst = false;
        private int releasedCount = 0;
        private boolean reportQueueStateInProgress = false;
        private final boolean pipeline;
        private final int ackAny;
        private boolean unlisten;

        public MonitorStrategyQueue(int queueSize, boolean pipeline, int ackAny) {
            if (queueSize <= 1) {
                throw new IllegalArgumentException("queueSize <= 1");
            }
            this.queueSize = queueSize;
            this.pipeline = pipeline;
            this.ackAny = ackAny;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void init(Structure structure) {
            Object object = this.monitorSync;
            synchronized (object) {
                this.releasedCount = 0;
                this.reportQueueStateInProgress = false;
                this.unlisten = false;
                if (this.lastStructure == null || !this.lastStructure.equals(structure)) {
                    MonitorElement[] monitorElements = new MonitorElement[this.queueSize];
                    for (int i = 0; i < this.queueSize; ++i) {
                        PVStructure pvNew = pvDataCreate.createPVStructure(structure);
                        monitorElements[i] = MonitorQueueFactory.createMonitorElement((PVStructure)pvNew);
                    }
                    this.monitorQueue = MonitorQueueFactory.create((MonitorElement[])monitorElements);
                    this.lastStructure = structure;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unlisten() {
            boolean notify = false;
            Object object = this.monitorSync;
            synchronized (object) {
                notify = this.monitorQueue.getNumberFree() == this.monitorQueue.capacity() - 1;
                this.unlisten = !notify;
            }
            if (notify) {
                ChannelMonitorImpl.this.callback.unlisten((Monitor)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void response(Transport transport, ByteBuffer payloadBuffer) {
            boolean notify = false;
            Object object = this.monitorSync;
            synchronized (object) {
                MonitorElement newElement;
                if (this.overrunInProgress && (newElement = this.monitorQueue.getFree()) != null) {
                    PVStructure pvStructure = this.monitorElement.getPVStructure();
                    convert.copy((PVField)pvStructure, (PVField)newElement.getPVStructure());
                    bitSetUtil.compress(this.monitorElement.getChangedBitSet(), pvStructure);
                    bitSetUtil.compress(this.monitorElement.getOverrunBitSet(), pvStructure);
                    this.monitorQueue.setUsed(this.monitorElement);
                    this.monitorElement = newElement;
                    notify = true;
                    this.overrunInProgress = false;
                }
            }
            if (notify) {
                ChannelMonitorImpl.this.callback.monitorEvent((Monitor)this);
            }
            object = this.monitorSync;
            synchronized (object) {
                PVStructure pvStructure = this.monitorElement.getPVStructure();
                BitSet changedBitSet = this.monitorElement.getChangedBitSet();
                BitSet overrunBitSet = this.monitorElement.getOverrunBitSet();
                if (this.overrunInProgress) {
                    if (this.bitSet1 == null) {
                        this.bitSet1 = new BitSet(changedBitSet.size());
                    }
                    if (this.bitSet2 == null) {
                        this.bitSet2 = new BitSet(overrunBitSet.size());
                    }
                    this.bitSet1.deserialize(payloadBuffer, (DeserializableControl)transport);
                    pvStructure.deserialize(payloadBuffer, (DeserializableControl)transport, this.bitSet1);
                    this.bitSet2.deserialize(payloadBuffer, (DeserializableControl)transport);
                    overrunBitSet.or_and(changedBitSet, this.bitSet1);
                    changedBitSet.or(this.bitSet1);
                    overrunBitSet.or(this.bitSet2);
                } else {
                    changedBitSet.deserialize(payloadBuffer, (DeserializableControl)transport);
                    pvStructure.deserialize(payloadBuffer, (DeserializableControl)transport, changedBitSet);
                    overrunBitSet.deserialize(payloadBuffer, (DeserializableControl)transport);
                }
                MonitorElement newElement = this.monitorQueue.getFree();
                if (newElement == null) {
                    this.overrunInProgress = true;
                    return;
                }
                if (this.overrunInProgress) {
                    bitSetUtil.compress(changedBitSet, pvStructure);
                    bitSetUtil.compress(overrunBitSet, pvStructure);
                    this.overrunInProgress = false;
                }
                convert.copy((PVField)pvStructure, (PVField)newElement.getPVStructure());
                this.monitorQueue.setUsed(this.monitorElement);
                this.monitorElement = newElement;
            }
            ChannelMonitorImpl.this.callback.monitorEvent((Monitor)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MonitorElement poll() {
            boolean notifyUnlisten = false;
            Object object = this.monitorSync;
            synchronized (object) {
                if (this.needToReleaseFirst) {
                    return null;
                }
                MonitorElement retVal = this.monitorQueue.getUsed();
                if (retVal != null) {
                    this.needToReleaseFirst = true;
                    return retVal;
                }
                if (this.overrunInProgress) {
                    MonitorElement newElement = this.monitorQueue.getFree();
                    if (newElement != null) {
                        PVStructure pvStructure = this.monitorElement.getPVStructure();
                        convert.copy((PVField)pvStructure, (PVField)newElement.getPVStructure());
                        bitSetUtil.compress(this.monitorElement.getChangedBitSet(), pvStructure);
                        bitSetUtil.compress(this.monitorElement.getOverrunBitSet(), pvStructure);
                        this.monitorQueue.setUsed(this.monitorElement);
                        this.monitorElement = newElement;
                        this.overrunInProgress = false;
                        this.needToReleaseFirst = true;
                        return this.monitorQueue.getUsed();
                    }
                    return null;
                }
                if (!this.unlisten) {
                    return null;
                }
                notifyUnlisten = true;
                this.unlisten = false;
            }
            if (notifyUnlisten) {
                ChannelMonitorImpl.this.callback.unlisten((Monitor)this);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release(MonitorElement monitorElement) {
            if (monitorElement.getPVStructure().getStructure() != this.lastStructure) {
                return;
            }
            Object object = this.monitorSync;
            synchronized (object) {
                this.monitorQueue.releaseUsed(monitorElement);
                this.needToReleaseFirst = false;
                if (this.pipeline) {
                    boolean sendAck = false;
                    ++this.releasedCount;
                    if (!this.reportQueueStateInProgress && this.releasedCount > this.ackAny) {
                        sendAck = true;
                        this.reportQueueStateInProgress = true;
                    }
                    if (sendAck) {
                        try {
                            ChannelMonitorImpl.this.channel.checkAndGetTransport().enqueueSendRequest(this);
                        }
                        finally {
                            this.reportQueueStateInProgress = false;
                        }
                    }
                }
            }
        }

        @Override
        public void lock() {
        }

        @Override
        public void unlock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(ByteBuffer buffer, TransportSendControl control) {
            control.startMessage((byte)13, 9);
            buffer.putInt(ChannelMonitorImpl.this.channel.getServerChannelID());
            buffer.putInt(ChannelMonitorImpl.this.ioid);
            buffer.put((byte)QoS.GET_PUT.getMaskValue());
            Object object = this.monitorSync;
            synchronized (object) {
                buffer.putInt(this.releasedCount);
                this.releasedCount = 0;
                this.reportQueueStateInProgress = false;
            }
            control.flush(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Status start() {
            Object object = this.monitorSync;
            synchronized (object) {
                this.overrunInProgress = false;
                this.monitorQueue.clear();
                this.monitorElement = this.monitorQueue.getFree();
                this.needToReleaseFirst = false;
            }
            return BaseRequestImpl.okStatus;
        }

        public Status stop() {
            return BaseRequestImpl.okStatus;
        }

        public void destroy() {
        }
    }

    private static interface MonitorStrategy
    extends Monitor {
        public void init(Structure var1);

        public void response(Transport var1, ByteBuffer var2);

        public void unlisten();
    }
}

