/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.impl.remote.handlers;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.epics.pvaccess.client.impl.remote.ClientContextImpl;
import org.epics.pvaccess.client.impl.remote.handlers.AbstractClientResponseHandler;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvdata.misc.SerializeHelper;
import org.epics.pvdata.pv.DeserializableControl;

public class ConnectionValidationHandler
extends AbstractClientResponseHandler {
    public ConnectionValidationHandler(ClientContextImpl context) {
        super(context, "Connection validation");
    }

    @Override
    public void handleResponse(InetSocketAddress responseFrom, Transport transport, byte version, byte command, int payloadSize, ByteBuffer payloadBuffer) {
        super.handleResponse(responseFrom, transport, version, command, payloadSize, payloadBuffer);
        transport.setRemoteRevision(version);
        transport.ensureData(6);
        transport.setRemoteTransportReceiveBufferSize(payloadBuffer.getInt());
        payloadBuffer.getShort();
        int size = SerializeHelper.readSize((ByteBuffer)payloadBuffer, (DeserializableControl)transport);
        ArrayList<String> offeredSecurityPlugins = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            offeredSecurityPlugins.add(SerializeHelper.deserializeString((ByteBuffer)payloadBuffer, (DeserializableControl)transport));
        }
        transport.authNZInitialize(offeredSecurityPlugins);
    }
}

