/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.pvms;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.epics.pvaccess.impl.remote.SerializationHelper;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Type;

public final class OutgoingMulticastIntrospectionRegistry {
    protected final Map<Field, Short> registry = new HashMap<Field, Short>();
    protected short pointer;

    public OutgoingMulticastIntrospectionRegistry() {
        this.reset();
    }

    public void reset() {
        this.pointer = 1;
        this.registry.clear();
    }

    public short registerIntrospectionInterface(Field field) {
        Short existing = this.registry.get(field);
        if (existing != null) {
            return existing;
        }
        short s = this.pointer;
        this.pointer = (short)(s + 1);
        short key = s;
        this.registry.put(field, key);
        return key;
    }

    public final void serialize(Field field, ByteBuffer buffer, SerializableControl control) {
        if (field == null) {
            SerializationHelper.serializeNullField(buffer, control);
        } else {
            if (field.getType() != Type.scalar && field.getType() != Type.scalarArray) {
                short key = this.registerIntrospectionInterface(field);
                control.ensureBuffer(3);
                buffer.put((byte)-3);
                buffer.putShort(key);
            }
            field.serialize(buffer, control);
        }
    }
}

