/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.pvms;

import java.net.InetAddress;
import java.net.SocketException;
import java.util.Arrays;
import org.epics.pvaccess.client.pvms.PVMSPublisher;
import org.epics.pvaccess.client.pvms.PVMSSubscriber;
import org.epics.pvdata.factory.FieldFactory;
import org.epics.pvdata.factory.PVDataFactory;
import org.epics.pvdata.pv.PVByteArray;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.ScalarType;
import org.epics.pvdata.pv.Structure;

public class PVMSDetectorExample {
    public static final Structure scanStructure = FieldFactory.getFieldCreate().createFieldBuilder().add("scanId", ScalarType.pvInt).add("frameSeq", ScalarType.pvInt).add("fps", ScalarType.pvInt).addArray("data", ScalarType.pvByte).createStructure();

    public static void main(String[] args) throws Throwable {
        String topicId = "DAQ";
        String[] tags = new String[]{"detector01"};
        InetAddress address = InetAddress.getByName("224.0.0.1");
        int port = 5678;
        final PVMSSubscriber subscriber = new PVMSSubscriber(address, 5678);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PVMSSubscriber.PVMSMessage message = new PVMSSubscriber.PVMSMessage("DAQ", null, null);
                    while (true) {
                        subscriber.receive(message, null);
                        System.out.println(message.topicId);
                        System.out.println(Arrays.toString(message.tags));
                        System.out.println(message.data);
                        System.out.println("-------");
                    }
                }
                catch (SocketException message) {
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }, "receiver-thread").start();
        int FRAMES_PER_SCAN = 3;
        int FRAME_DATA_SIZE = 1024;
        PVStructure data = PVDataFactory.getPVDataCreate().createPVStructure(scanStructure);
        data.getIntField("fps").put(3);
        byte[] dataArray = new byte[1024];
        PVByteArray ba = (PVByteArray)data.getScalarArrayField("data", ScalarType.pvByte);
        ba.shareData(dataArray);
        PVMSPublisher publisher = new PVMSPublisher(address, 5678);
        for (int scanId = 0; scanId != 10; ++scanId) {
            for (int frameSeq = 0; frameSeq < 3; ++frameSeq) {
                data.getIntField("scanId").put(scanId);
                data.getIntField("frameSeq").put(frameSeq);
                Arrays.fill(dataArray, (byte)(frameSeq % 255));
                publisher.publishData("DAQ", tags, (PVField)data);
            }
            Thread.sleep(1000L);
        }
        publisher.destroy();
        subscriber.destroy();
    }
}

